<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@rsrcplnBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="confirmContinue" 
        method="post" 
        destination="config"
        >

        <uix:pageLayout messageType="confirmation" >

          <uix:formValue 
            name="pageName" 
            valueBinding="pageName@servletRequest"/>

          <uix:formValue 
            name="oname" 
            valueBinding="oname@servletRequest" />
          <uix:formValue 
            name="otype" 
            valueBinding="otype@servletRequest" />
          <uix:formValue 
            name="backURL" 
            valueBinding="backURL@servletRequest" />
          <uix:formValue 
            name="cancelURL" 
            valueBinding="cancelURL@servletRequest" />
          <uix:formValue 
            name="target" 
            valueBinding="target@servletRequest"/> 
          <uix:formValue 
            name="mode" 
            valueBinding="mode@servletRequest"/>
          <uix:formValue 
            name="emdUrl" 
            valueBinding="emdUrl@servletRequest"/>

          <uix:formValue 
            name="from" 
            valueBinding="from@servletRequest"/>
           
           <uix:formValue 
            name="prevEvent" 
            valueBinding="prevEvent@servletRequest"/>  

          <%-------------------------
           -  Confirmation Message
           ---------------------------%>
          <uix:stackLayout>
            <uix:rowLayout>
              <uix:spacer width="40"/>
              <uix:styledText 
                styleClass="OraDataText"
                textBinding="CONNECT_FAIL_INSTR@configBundle@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer width="40"/>
              <uix:styledText 
                styleClass="OraDataText"
                textBinding="CONFIRM_CONTINUE@configBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:stackLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
               
              <uix:submitButton 
                text="No" 
                name="event" 
                value="confirm_no" 
                formName="confirmContinue"
                />  

              <uix:submitButton 
                text="Yes" 
                name="event" 
                value="confirm_yes" 
                formName="confirmContinue"
                />  
                
            </uix:pageButtonBar>
          </uix:pageButtons>
            
        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

