<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>    
  <uix:body> 
    <db:form 
      copyParams="target,type,cancelURL"
      name="loginForm" method="post" destination="config">   
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/>  
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/> 
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>        
        <uix:stackLayout>
          <uix:contents> 
           <uix:spacer height="10"/>               
	      <uix:train selectedIndex="2">
          <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
            <uix:link textBinding="."/>
          </uix:contents>
        </uix:train>                  
            <uix:header textBinding="credentialsHeader@defaultBean@servletRequest">                              
            
               <uix:rowLayout>             
                <uix:contents>       
                  <uix:styledText styleClass="OraInstructionText" textBinding="credDesc@defaultBean@pageContext" />                     
                </uix:contents>
              </uix:rowLayout> 
              <uix:spacer height="5"/>           
          <uix:tableLayout cellSpacing="5">
            <uix:contents>
               
              <uix:rowLayout hAlign="center"> 
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>     
                      <uix:messagePrompt required="yes" promptBinding="USER_NAME@configBundle@servletRequest" />               
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>
                      <uix:contents> 
                        <uix:textInput name="sysUserName" id="sysUserName" readOnlyBinding="sysUserReadOnly@defaultBean@servletRequest" noAutoComplete="true" textBinding="sysUserName@defaultBean@servletRequest" />
                        <uix:messageText messageType="error" messageBinding="sysUserName@errors@servletRequest"/>                      
                      </uix:contents>  
                    </uix:stackLayout> 
                  </uix:cellFormat>
                </uix:contents>                  
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>   
                      <uix:messagePrompt  required="yes" promptBinding="PASSWORD@configBundle@servletRequest"/>                 
                   </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true">
                    <uix:stackLayout>
                    <uix:contents> 
                      <uix:textInput name="sysUserPassword" textBinding="sysUserPassword@defaultBean@pageContext" noAutoComplete="true" secret="true" />
                      <uix:messageText messageType="error" messageBinding="sysUserPassword@errors@servletRequest"/>                      
                    </uix:contents>  
                    </uix:stackLayout>                
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>                                            
                      <uix:styledText styleClass="OraPromptText" textBinding="CONNECT_AS@configBundle@servletRequest" />                                           
                    </uix:contents>
                  </uix:cellFormat>                   
                  <uix:cellFormat wrappingDisabled="true">
                    <uix:contents>  
                      <uix:choice name="sysRole"
                                 selectedValueBinding="sysRole@defaultBean@servletRequest"
                                 shortDescBinding="CONNECT_AS@configBundle@servletRequest">
                                 <uix:contents childDataBinding="roles@defaultBean@servletRequest">
                                    <uix:option textBinding="text"
                                                valueBinding="value"/>
                                 </uix:contents>
                      </uix:choice>                                                             
                     
                    </uix:contents>   
                 </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>              
              
            </uix:contents>   
         </uix:tableLayout>
                     
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
      
       <uix:pageButtons> 
         <uix:pageButtonBar>         
           <uix:submitButton 
             textBinding="CANCEL@configBundle@servletRequest" 
             name="event" 
             value="cancel" />

           <uix:spacer width="10"/>
           <uix:navigationBar
             name="step"
             minValue="1"
             maxValue="5"
             value="3"  
             formSubmitted="true"
             formName="loginForm"/>

         </uix:pageButtonBar>  
       </uix:pageButtons>

     </uix:pageLayout>       
    </db:form>  
  </uix:body> 
</uix:document> 
	     	     
</uix:renderingContext>
