<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
<script>
function iconButtonFunc( mode, value )
{
    document.forms[0].mode.value=mode;
    document.forms[0].event.value=value;
    document.forms[0].submit();
}
</script>

<uix:document>   
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>
  <uix:body>      
      <db:form 
        copyParams="target,type,cancelURL"
        name="discoverForm" method="POST" destination="config"> 
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/> 
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:formValue name="returnUrl" valueBinding="returnUrl@servletRequest"/>

      <uix:pageLayout
        titleBinding="header@defaultBean@pageContext"
        >
        <%@ include file="/oemGlobal.jspf" %>    

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>    
        <oem:messageBox messageType="warning"
                        errorTableBinding="warning@servletRequest"
                        destTableBinding="warningUrl@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>    
        
        <uix:header textBinding="DATABASES@configBundle@servletRequest">    
         <uix:tableLayout width="100%">          
               <uix:rowLayout>             
                <uix:contents>
                  <uix:switcher childNameBinding="clusterWideDiscovery@defaultBean@servletRequest">
                   <uix:case name="false">
                      <uix:styledText styleClass="OraInstructionText" textBinding="DISCOVER_DESC@configBundle@servletRequest" />
                   </uix:case>
                   <uix:case name="true">
                      <uix:styledText styleClass="OraInstructionText" textBinding="DISCOVER_DESC_CLS@configBundle@servletRequest" />
                   </uix:case>
                  </uix:switcher> 
                </uix:contents>
               </uix:rowLayout>
           </uix:tableLayout> 

           <%-------------------------------------
            -  Partial Configuration Icon Legend
            --------------------------------------%>
           <uix:switcher 
             childNameBinding="hasPartialConfigTgts@defaultBean@servletRequest">
             <uix:case name="true">
               <uix:stackLayout>             
                 <uix:spacer height="5"/>
                 <uix:labeledFieldLayout labelWidth="1%">
                   <uix:contents>
                     <uix:image 
                       source="/em/images/database/config/configure_required.gif"
                       />
                     <uix:styledText
                       styleClass="OraInstructionText" 
                       textBinding="PARTIAL_CONFIG_LEGEND@configSyncBundle@servletRequest"
                       />
                   </uix:contents>
                 </uix:labeledFieldLayout>
                 <uix:spacer height="5"/>
               </uix:stackLayout>             
             </uix:case>
           </uix:switcher>
           
           <%-------%>
      <uix:spacer height="10"/>
      <uix:header textBinding="CLUSTERDBS@configBundle@servletRequest" 
            renderedBinding="clusterWideDiscovery@defaultBean@servletRequest"> 
      <uix:tableLayout width="100%">
                <uix:rowLayout>
                <uix:hGrid id="discoveredTargets"
                           width="100%"
                           summaryBinding="CLUSTERDBS@configBundle@servletRequest"
                           alternateTextBinding="NO_ITEM_FOUND@configBundle@servletRequest"
                           destination="config"
                           formSubmitted="true"
                           columnHeaderDataBinding="targetTreeHeader@defaultBean@servletRequest"
                           columnFormatsBinding="targetTreeHeaderFormats@defaultBean@servletRequest"
                           treeDataBinding="racDBTree@defaultBean@servletRequest"
                           proxyBinding="targetTreeProxy@defaultBean@servletRequest">
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="headerName"
                                        sortableBinding="sort"
                                        valueBinding="sortIndex"/>
                  </uix:columnHeaderStamp>

                 <uix:nodeStamp>
                    <uix:column>
                      <uix:columnFormat width="50%"/>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="headerName@targetTreeNodeHeader@defaultBean@servletRequest"
                                        sortableBinding="sort@targetTreeNodeHeader@defaultBean@servletRequest"
                                        valueBinding="sortIndex@targetTreeNodeHeader@defaultBean@servletRequest"/>
                      </uix:columnHeader>

                        <uix:switcher childNameBinding="existingInst">
                        <uix:case name="true">
                          <uix:styledText styleClass="OraTipText" textBinding="name"/>
                        </uix:case>
                        <uix:default>
                           <uix:styledText textBinding="name"/>   
                        </uix:default>
                        </uix:switcher>   
                    
                    </uix:column>
                  </uix:nodeStamp>

                   <%--   
                      <uix:switcher childNameBinding="hasMetric">
                      <uix:case name="true">
                        <uix:choice nameBinding="monLevName"
                                 selectedValueBinding="selMonLev"
                                 shortDescBinding="MONITOR_LEVEL@configBundle@servletRequest">
                        <uix:contents childDataBinding="choiceList@defaultBean@servletRequest">
                              <uix:option textBinding="ctext"
                                       valueBinding="cval"/>
                        </uix:contents>
                       </uix:choice>                            
                     </uix:case>
                     </uix:switcher>          
                  --%>
                     
                  <uix:switcher childNameBinding="configurable">
                      <uix:case name="true">
                      
                      <%--
                        <uix:submitButton 
                          textBinding="CONFIGURE@configBundle@servletRequest" 
                          name="event" 
                          valueBinding="confEvent"/>
                      --%>
                       <uix:image 
                         sourceBinding="configIcon"
                         destinationBinding="confLink"
                         />
                          
                      </uix:case>
                  </uix:switcher>          
                   
                  <%--
                  <uix:switcher childNameBinding="hasMetric">
                  <uix:case name="true">
                    <uix:submitButton textBinding="SHOW_METRICS@configBundle@servletRequest" name="event" 
                            valueBinding="metEvent" />
                  </uix:case>
                  </uix:switcher>          
                  --%>
                  
                  <uix:tableSelection>
                    <uix:multipleSelection selectedBinding="selected"
                        disabledBinding="selectionDisabled" shortDescBinding="SELECT@configBundle@servletRequest"/>
                 </uix:tableSelection>

                </uix:hGrid>
               </uix:rowLayout>

               <uix:rowLayout>
                <uix:spacer height="2"/>      
               </uix:rowLayout>                              

               <uix:rowLayout hAlign="left">
                 <uix:submitButton 
                   textBinding="MANUAL_ADD@configBundle@servletRequest" 
                   name="event" 
                   value="rac_manual_conf" 
                   />

               </uix:rowLayout>

               <uix:rowLayout>
                <uix:spacer height="5"/>      
               </uix:rowLayout>                              
                
               <uix:rowLayout renderedBinding="anyRacInstExisting@defaultBean@servletRequest">
                  <uix:tip textBinding="EXISTING_INST_TIP@configBundle@servletRequest"/>
               </uix:rowLayout>                              
        </uix:tableLayout>    
       <uix:formParameter name="uniqueID"/>
       <uix:formValue name="rootUniqueID" valueBinding="uniqueID@targetTree@defaultBean@servletRequest"/>
       <uix:formValue name="targetTreeID" valueBinding="targetTreeID@servletRequest"/>
       </uix:header>
<%---------%>
            
           
           <uix:switcher childNameBinding="clusterWideDiscovery@defaultBean@servletRequest">
               <uix:case name="false">
               <uix:tableLayout width="100%">
               <uix:rowLayout>  
                 <uix:table  width="100%"
                           name="db"
                           summaryBinding="DATABASES@configBundle@servletRequest"
                           tableDataBinding="targetsTableData@defaultBean@pageContext"
                           columnHeaderDataBinding="columnHeaderData@defaultBean@pageContext"
                           columnFormatsBinding="columnFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest"
                           blockSizeBinding="blockSize@defaultBean@pageContext"
                           valueBinding="value@defaultBean@servletRequest" 
                           minValueBinding="minValue@defaultBean@servletRequest" 
                           maxValueBinding="maxValue@defaultBean@servletRequest"
                           formSubmitted="true" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:styledText textBinding="text"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <%-- Host --%>
                     <uix:styledText textBinding="name"/>
                     <%-- Configure --%>
                      <uix:image 
                         sourceBinding="configIcon"
                         destinationBinding="configDest"
                      />
                     <%-- Metrics --%>
                      <uix:image 
                         source="/em/images/database/config/metric.gif"
                         destinationBinding="metricDest"
                       />
                   </uix:contents>

                   <uix:tableSelection>
                     <uix:multipleSelection selectedBinding="select" shortDescBinding="SELECT@configBundle@servletRequest"/>
                   </uix:tableSelection>
                 </uix:table> 
                 </uix:rowLayout>
                   <uix:rowLayout>
                    <uix:spacer height="2"/>
                   </uix:rowLayout>  
                   <uix:rowLayout>                
                    <uix:submitButton 
                      textBinding="MANUAL_ADD@configBundle@servletRequest" 
                      name="event" 
                      value="manual_conf" 
                    />
                   </uix:rowLayout>

                 <uix:rowLayout>
                  <uix:spacer height="5"/>
                 </uix:rowLayout>  

                 <uix:rowLayout>
                   <uix:tip textBinding="CONFIGURE_DB_TIP@configBundle@servletRequest" />
                 </uix:rowLayout>
                 </uix:tableLayout>      
                 </uix:case>
                 
                 <uix:case name="true">
                 <uix:header textBinding="SINGLEDBS@configBundle@servletRequest">
                   <uix:tableLayout width="100%">
                     <uix:rowLayout>  
                      <uix:table  width="100%"
                             name="db"
                             summaryBinding="DATABASES@configBundle@servletRequest"
                             tableDataBinding="targetsTableData@defaultBean@pageContext"
                             columnHeaderDataBinding="columnHeaderData@defaultBean@pageContext"
                             columnFormatsBinding="columnFormats@defaultBean@pageContext"
                             alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest"
                             blockSizeBinding="blockSize@defaultBean@pageContext"
                             valueBinding="value@defaultBean@servletRequest" 
                             minValueBinding="minValue@defaultBean@servletRequest" 
                             maxValueBinding="maxValue@defaultBean@servletRequest"
                             formSubmitted="true" > 
                     <uix:tableFormat tableBanding="rowBanding"/>
                     <uix:columnHeaderStamp>
                       <uix:styledText textBinding="text"/>
                     </uix:columnHeaderStamp>
                     
                     <uix:contents>
                       <%-- Host --%>
                       <uix:styledText textBinding="name"/>

                       <%-- Machine Name --%>
                       <uix:styledText textBinding="MachineName"/>
                       
                       <%-- Monitor Level == Commented Out ==
                         <uix:choice 
                           nameBinding="cname"
                           selectedValueBinding="cselval"
                           shortDescBinding="MONITOR_LEVEL@configBundle@servletRequest">
                           <uix:contents childDataBinding="cdata">
                             <uix:option 
                               textBinding="ctext"
                               valueBinding="cval"/>
                           </uix:contents>
                         </uix:choice>
                       --%>

                       <%-- Configure --%>
                       <uix:image 
                         sourceBinding="configIcon"
                         destinationBinding="configDest"
                         />

                       <%-- Metrics --%>
                       <uix:image 
                         source="/em/images/database/config/metric.gif"
                         destinationBinding="metricDest"
                         />

                     </uix:contents>
                     <uix:tableSelection>
                       <uix:multipleSelection selectedBinding="select" shortDescBinding="SELECT@configBundle@servletRequest"/>
                     </uix:tableSelection>
                   </uix:table>       
                   </uix:rowLayout>

                   <uix:rowLayout>
                    <uix:spacer height="2"/>
                   </uix:rowLayout>  

                   <uix:rowLayout>                
                    <uix:submitButton 
                      textBinding="MANUAL_ADD@configBundle@servletRequest" 
                      name="event" 
                      value="manual_conf" 
                      />
                   </uix:rowLayout>

                   <uix:rowLayout>
                    <uix:spacer height="5"/>
                   </uix:rowLayout>  

                   <uix:rowLayout>
                      <uix:tip
                        textBinding="CONFIGURE_DB_TIP@configBundle@servletRequest" 
                        />
                   </uix:rowLayout>
                 </uix:tableLayout>
                 </uix:header>   
                 </uix:case>
                 </uix:switcher>   
           
       </uix:header>

	<%--...  Oracle Storage Manager: manual config not turned on.. 
             not rendered if no osm discovered  ...--%>
       <uix:header textBinding="osmHeader@defaultBean@pageContext" 
         renderedBinding="showOsmTargets@defaultBean@pageContext">         

	    <uix:tableLayout width="100%" 
          renderedBinding="showOsmTargets@defaultBean@pageContext">
          <uix:contents>  
            <uix:rowLayout>             
              <uix:contents>       
                <uix:styledText 
                  styleClass="OraInstructionText" 
                  textBinding="osmDescription@defaultBean@pageContext" />                     
              </uix:contents>
            </uix:rowLayout> 

            <%-------------------------------------
             -  Partial Configuration Icon Legend
             --------------------------------------%>
            <uix:switcher 
              childNameBinding="hasPartialConfigASMTgts@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>             
                  <uix:spacer height="5"/>
                  <uix:labeledFieldLayout labelWidth="1%">
                    <uix:contents>
                      <uix:image 
                        source="/em/images/database/config/configure_required.gif"
                        />
                      <uix:styledText
                        styleClass="OraInstructionText" 
                        textBinding="PARTIAL_CONFIG_LEGEND@configSyncBundle@servletRequest"
                        />
                    </uix:contents>
                  </uix:labeledFieldLayout>
                  <uix:spacer height="5"/>
                </uix:stackLayout>             
              </uix:case>
            </uix:switcher> 

	        <!-- no manual discover at this point -->
            <%-- uix:rowLayout hAlign="right">                
            <uix:button textBinding="MANUAL_ADD@configBundle@servletRequest" 
			  destinationBinding="osmManualConfigUrl@defaultBean@pageContext" />
            </uix:rowLayout --%>

            <uix:rowLayout>     
              <uix:switcher childNameBinding="clusterWideDiscovery@defaultBean@pageContext">
                <uix:case name="true">
                  <uix:table  width="100%"
                    name ="osm"
                    summaryBinding="osmHeader@defaultBean@pageContext"
                    tableDataBinding="osmTargetsTableData@defaultBean@pageContext"
                    columnHeaderDataBinding="osmColumnHeaderData@defaultBean@pageContext"
                    columnFormatsBinding="osmColumnFormats@defaultBean@pageContext"
                    alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest"
                    blockSizeBinding="osmBlockSize@defaultBean@pageContext"
                    valueBinding="osmValue@defaultBean@servletRequest" 
                    minValueBinding="osmMinValue@defaultBean@servletRequest" 
                    maxValueBinding="osmMaxValue@defaultBean@servletRequest"
                    formSubmitted="true" > 
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:columnHeaderStamp>
                     <uix:styledText textBinding="text"/>
                    </uix:columnHeaderStamp>
                    
                    <uix:contents>
                      <uix:styledText textBinding="name"/>
                      <uix:styledText textBinding="MachineName"/>
                      <uix:styledText textBinding="OracleHome"/>
                      <uix:styledText textBinding="SID"/> 
                      <uix:styledText textBinding="Port"/>
                  
                      <%-- Configure --%>
                      <uix:image 
                        sourceBinding="configIcon"
                        destinationBinding="configDest"
                        />
                  
                     </uix:contents>
                    <uix:tableSelection>
                      <uix:multipleSelection 
                        selectedBinding="select" 
                        shortDescBinding="SELECT@configBundle@servletRequest"/>
                    </uix:tableSelection>
                  </uix:table>          
                </uix:case>
                <uix:case name="false">
                  <uix:table  width="100%"
                    name ="osm"
                    summaryBinding="osmHeader@defaultBean@pageContext"
                    tableDataBinding="osmTargetsTableData@defaultBean@pageContext"
                    columnHeaderDataBinding="osmColumnHeaderData@defaultBean@pageContext"
                    columnFormatsBinding="osmColumnFormats@defaultBean@pageContext"
                    alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest"
                    blockSizeBinding="osmBlockSize@defaultBean@pageContext"
                    valueBinding="osmValue@defaultBean@servletRequest" 
                    minValueBinding="osmMinValue@defaultBean@servletRequest" 
                    maxValueBinding="osmMaxValue@defaultBean@servletRequest"
                    formSubmitted="true" > 
                     <uix:tableFormat tableBanding="rowBanding"/>
                     <uix:columnHeaderStamp>
                      <uix:styledText textBinding="text"/>
                     </uix:columnHeaderStamp>
                     
                    <uix:contents>
                      <uix:styledText textBinding="name"/>
                      <uix:styledText textBinding="OracleHome"/>
                      <uix:styledText textBinding="SID"/>
                      <uix:styledText textBinding="Port"/>

                      <%-- Configure --%>
                      <uix:image 
                        sourceBinding="configIcon"
                        destinationBinding="configDest"
                        />
                     </uix:contents>
                     <uix:tableSelection>
                       <uix:multipleSelection 
                         selectedBinding="select" 
                         shortDescBinding="SELECT@configBundle@servletRequest"/>
                     </uix:tableSelection>
                  </uix:table>          
                </uix:case>
              </uix:switcher>
            </uix:rowLayout>         	

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>  

            <uix:rowLayout>
              <uix:tip
                textBinding="CONFIGURE_ASM_TBL_TIP@configBundle@servletRequest" />
            </uix:rowLayout>
	      </uix:contents>
	     </uix:tableLayout>
       </uix:header>
	  <%--.............................. End of Oracle Storage Manager Table ................................--%>
  
          <uix:spacer height="10"/>                                
            <uix:header textBinding="LISTENERS@configBundle@servletRequest">
                        
         <uix:tableLayout width="100%">
             <uix:contents>  
               <uix:rowLayout>             
                <uix:contents>       
                  <uix:switcher childNameBinding="clusterWideDiscovery@defaultBean@servletRequest">
                   <uix:case name="false">
                      <uix:styledText styleClass="OraInstructionText" textBinding="LISTEN_DESC@configBundle@servletRequest" />                     
                   </uix:case>
                   <uix:case name="true">
                      <uix:styledText styleClass="OraInstructionText" textBinding="LISTEN_DESC_CLS@configBundle@servletRequest" />                     
                   </uix:case>
                  </uix:switcher> 
                </uix:contents>
               </uix:rowLayout>
               <uix:rowLayout>
                <uix:spacer height="5"/>      
               </uix:rowLayout> 
               <uix:rowLayout>     

               <uix:switcher childNameBinding="clusterWideDiscovery@defaultBean@servletRequest">
               <uix:case name="false">
               
                 <uix:table  width="100%"
                           name ="listener"
                           summaryBinding="LISTENERS@configBundle@servletRequest"
                           tableDataBinding="lisTableData@defaultBean@pageContext"
                           columnHeaderDataBinding="lisColHeaderData@defaultBean@pageContext"
                           columnFormatsBinding="lisColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest"
                           blockSizeBinding="lisBlockSize@defaultBean@pageContext"
                           valueBinding="lisValue@defaultBean@servletRequest" 
                           minValueBinding="lisMinValue@defaultBean@servletRequest" 
                           maxValueBinding="lisMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:styledText textBinding="text"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:styledText textBinding="name"/>
                     <uix:styledText textBinding="LsnrName"/>
                     <uix:styledText textBinding="OracleHome"/>
                     <uix:styledText textBinding="Port"/>
                     <uix:styledText textBinding="ListenerOraDir"/>
                    </uix:contents>
                   <uix:tableSelection>
                     <uix:multipleSelection selectedBinding="select" shortDescBinding="SELECT@configBundle@servletRequest"/>
                   </uix:tableSelection>
                 </uix:table>          
                 </uix:case>
                 
                 <uix:case name="true">
                 <uix:table  width="100%"
                           name ="listener"
                           summaryBinding="LISTENERS@configBundle@servletRequest"
                           tableDataBinding="lisTableData@defaultBean@pageContext"
                           columnHeaderDataBinding="lisColHeaderData@defaultBean@pageContext"
                           columnFormatsBinding="lisColFormats@defaultBean@pageContext"
                           alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest"
                           blockSizeBinding="lisBlockSize@defaultBean@pageContext"
                           valueBinding="lisValue@defaultBean@servletRequest" 
                           minValueBinding="lisMinValue@defaultBean@servletRequest" 
                           maxValueBinding="lisMaxValue@defaultBean@servletRequest"
                           formSubmitted="true" > 
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:styledText textBinding="text"/>
                   </uix:columnHeaderStamp>
                   
                   <uix:contents>
                     <uix:styledText textBinding="name"/>
                     <uix:styledText textBinding="MachineName"/>
                     <uix:styledText textBinding="LsnrName"/>
                     <uix:styledText textBinding="OracleHome"/>
                     <uix:styledText textBinding="Port"/>
                     <uix:styledText textBinding="ListenerOraDir"/>
                    </uix:contents>
                   <uix:tableSelection>
                     <uix:multipleSelection selectedBinding="select" shortDescBinding="SELECT@configBundle@servletRequest"/>
                   </uix:tableSelection>
                 </uix:table>          
                </uix:case>
                </uix:switcher>                                                  
               </uix:rowLayout>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
             </uix:contents>   
           </uix:tableLayout>
           
          </uix:header>
          
          <uix:header textBinding="RELATED_LINKS@configBundle@servletRequest" renderedBinding="notInCluster@defaultBean@pageContext">
            <uix:link textBinding="ADD_CLUSTER_TARGET@configBundle@servletRequest" destinationBinding="addClusterLink@pageContext"/>
          </uix:header>
      
        <%-------------------------
         -  Page Buttons
         ---------------------------%>
        <uix:pageButtons> 
          <uix:pageButtonBar>         

            <%-- Cancel Button --%>
            <uix:submitButton 
              textBinding="CANCEL@configBundle@servletRequest" 
              name="event" 
              value="cancel" />

            <%-- OK Button --%>
            <uix:submitButton 
              textBinding="OK@configBundle@servletRequest" 
              name="event" 
              value="ok" />
          </uix:pageButtonBar>  
        </uix:pageButtons>
      
      </uix:pageLayout>       
    </db:form>  
  </uix:body> 
</uix:document> 
	     	     
</uix:renderingContext>
