<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:document>   
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>
  <uix:body>      
      <db:form 
        copyParams="target,type,mode,cancelURL"
        name="discoverForm" method="POST" destination="config"> 
      <uix:formValue name="pageName" value="discoveryWarning"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>    
        <oem:messageBox messageType="warning"
                        errorTableBinding="warning@servletRequest"
                        titleTextKey="titleText"/>    

        <uix:pageButtons> 
          <uix:pageButtonBar>         
            <%-- OK Button --%>
            <uix:submitButton 
              textBinding="OK@configBundle@servletRequest" 
              name="event" 
              value="afterShowWarnings" />
          </uix:pageButtonBar>  
        </uix:pageButtons>
      
      </uix:pageLayout>       
    </db:form>  
  </uix:body> 
</uix:document> 
	     	     
</uix:renderingContext>
