<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>   
  <uix:body> 
    <db:form 
      copyParams="target,type,cancelURL"
      name="metricstForm" destination="config">  
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
      <uix:formValue name="target" valueBinding="target@servletRequest"/>  
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:formValue name="returnUrl" valueBinding="returnUrl@servletRequest"/>
     <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        
        <uix:stackLayout>
          <uix:contents>
           <uix:spacer height="5"/>               

            <uix:header textBinding="metricsTHeader@defaultBean@servletRequest">
            <uix:tableLayout cellSpacing="5" width="100%">          
              <uix:rowLayout  hAlign="right"> 
                <uix:pageButtonBar>     
                  <uix:spacer width="10"/>       
                  <uix:submitButton textBinding="OK@configBundle@servletRequest" name="event" value="ok_t" />
                </uix:pageButtonBar>  
              </uix:rowLayout> 
            </uix:tableLayout>                       
            <uix:spacer height="5"/> 
            <uix:styledText styleClass="OraInstructionText" textBinding="metricsDesc@defaultBean@servletRequest" />                     
            <uix:spacer height="10"/> 
               <uix:hGrid id="metrics"
                           width="100%"
                           alternateTextBinding="METRICS_ALT_TEXT@configBundle@servletRequest"                             
                           formSubmitted="true"                     
                           summaryBinding="METRICS_SUMMARY@configBundle@servletRequest"
                           columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest"
                           treeDataBinding="treeData@defaultBean@servletRequest"
                           proxyBinding="proxy@servletRequest">          
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="METRICS@configBundle@servletRequest"/>                        
                      </uix:columnHeader>                     
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>

                  <uix:styledText textBinding="op"/> 
                  <uix:styledText textBinding="warning"/>               
                  <uix:styledText textBinding="critical"/> 
                                                                                                        
                </uix:hGrid>                      
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
      
       <uix:contentFooter>
         <uix:pageButtonBar>     
         <uix:spacer width="10"/>    
          <uix:submitButton 
            textBinding="OK@configBundle@servletRequest" 
            name="event" 
            value="ok_t"
            />         

         </uix:pageButtonBar>  
       </uix:contentFooter>
     </uix:pageLayout>       
    </db:form>  
  </uix:body> 
</uix:document> 
</uix:renderingContext>
