<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiMonPwd.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL main page.
 *
 * MODIFIED
 *    jstone      07/21/05 - Created from multiTarget.jsp
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<jsp:useBean
    id="multiMonPwdBean"
    scope="request"
    type="oracle.sysman.db.conf.monpwd.MultiMonPwdBean"/>

<script>
 function preLoad()
 {
   document.multiMonPwd.hostCommandText.focus();

   var isNav = (navigator.appName.indexOf("Netscape") != -1);
   if(isNav)
   {
     document.captureEvents(Event.KEYPRESS);
     document.multiMonPwd.hostCommandText.onkeypress = getNetscapeKey;
   } 
 }
 function getNetscapeKey(keyStroke)
 {
   key = keyStroke.which;
   if(key == "13")
   {
     submitForm('multiMonPwd', 0, {'event':'execute'});
   }
 }            
 function doExecute(isFocus)
 {
   if(isFocus == "1")  
   { 
     if ((window.event.which == 13) ||  
         (window.event.keyCode == 13))
     {
       submitForm('multiMonPwd', 0, {'event':'execute'});
     }
   }
 }
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="ConfigResourceBundle" class="oracle.sysman.db.rsc.conf.DBConfigMsg"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>
  <uix:bundle name="MultiMonPwdResourceBundle" class="oracle.sysman.db.rsc.conf.DBConfigSyncMsg"/>

  <%
  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
  if (dest != null)
  {
    PartialPageUtils.forceRedirectURL(renderingContext, dest);
    request.getSession().removeAttribute("processingDoneDestination");
  }
  %>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="preLoad();">

      <uix:contents>
        <uix:form name="multiMonPwd" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_PAGE %>"/>

          <uix:pageLayout titleBinding="CHNG_MONITORING_PWD_TITLE@MultiMonPwdResourceBundle">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:messageChoice
                renderedBinding="targetTypeRendered@multiMonPwdBean@servletRequest"
                name="targetTypeSelectedChoice"
                promptBinding="TARGET_TYPE@SDKUIResourceBundle"
                tipBinding="CHANGE_TARGET_TYPE_TIP@MultiTargetResourceBundle"
                selectedValueBinding="targetTypeSelectedValue@multiMonPwdBean@servletRequest"
                onChange="submitForm('multiMonPwd', true, {'event':'changeTargetTypeOK'})"> 
              <uix:contents
                  childDataBinding="targetTypeList@multiMonPwdBean@servletRequest">
                <uix:option
                    textBinding="targetTypeText"
                    valueBinding="targetTypeValue"/>
              </uix:contents>
            </uix:messageChoice>

            <uix:tableLayout width="100%">
              <uix:rowLayout vAlign="top">

                <uix:header
                  textBinding="DBSNMP_PWD@MultiMonPwdResourceBundle">

                  <uix:tableLayout width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                      <%-------------------------
                       -  Instruction Text
                       ---------------------------%>
                      <uix:styledText
                          renderedBinding="sqlControlsRendered@multiMonPwdBean@servletRequest"
                          styleClass="OraInstructionText"
                          textBinding="CHNG_MONITORING_PWD_DESC@MultiMonPwdResourceBundle"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:spacer height="12"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <%-------------------------
                         -  DBSNMP Password
                         ---------------------------%>
                        <uix:labeledFieldLayout labelWidth="38%" >
                          <uix:contents>

                           <uix:messageTextInput 
                             name="newDbsnmpPassword" 
                             promptBinding="NEW_DBSNMP_PASSWD@MultiMonPwdResourceBundle"
                             textBinding="newDbsnmpPassword@multiMonPwdBean@pageContext" 
                             messageBinding="(NEW_DBSNMP_PASSWD@MultiMonPwdResourceBundle)@errors@servletRequest"
                             messageTypeBinding="newDbsnmpPasswordErrorType@multiMonPwdBean@servletRequest" 
                             columns="40"
                             secret="true"           
                             required="uiOnly"
                             />

                           <uix:messageTextInput 
                             name="confirmNewDbsnmpPassword" 
                             promptBinding="CONFIRM_DBSNMP_PASSWD@MultiMonPwdResourceBundle"
                             textBinding="confirmNewDbsnmpPassword@multiMonPwdBean@pageContext" 
                             messageBinding="(CONFIRM_DBSNMP_PASSWD@MultiMonPwdResourceBundle)@errors@servletRequest"
                             messageTypeBinding="confirmNewDbsnmpPasswordErrorType@multiMonPwdBean@servletRequest" 
                             columns="40"
                             secret="true"           
                             required="uiOnly"
                             />

                          </uix:contents>
                        </uix:labeledFieldLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:tableLayout width="100%" 
                    renderedBinding="hostControlsRendered@multiMonPwdBean@servletRequest">
                    <uix:rowLayout>
                      <uix:labeledFieldLayout labelWidth="10%">
                        <uix:messageTextInput
                            id="Command"
                            name="hostCommandText"
                            required="uiOnly"
                            columns="71"
                            onKeyPress="doExecute('1');"
                            textBinding="hostCommandText@multiMonPwdBean@servletRequest"
                            promptBinding="CREATE_JOB_OS_COMMAND@JobsResourceBundle"
                            tipBinding="CREATE_JOB_OS_COMMAND_TIP@JobsResourceBundle"
                            messageBinding="(CREATE_JOB_OS_COMMAND@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(CREATE_JOB_OS_COMMAND@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messagePrompt/>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:pageButtonBar>
                                <uix:submitButton
                                    textBinding="loadButtonText@multiMonPwdBean@servletRequest"
                                    name="event"
                                    value="loadFromFile"/>
                              </uix:pageButtonBar>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                        <uix:messageTextInput
                            name="hostScriptText"
                            columns="73"
                            rows="5"
                            textBinding="hostScriptText@multiMonPwdBean@servletRequest"
                            promptBinding="CREATE_JOB_OS_SCRIPT@JobsResourceBundle"
                            tipBinding="OS_SCRIPT_TIP@MultiTargetResourceBundle"
                            messageBinding="(CREATE_JOB_OS_SCRIPT@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(CREATE_JOB_OS_SCRIPT@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messagePrompt/>
                        <uix:checkBox
                            name="resultsPersistentOption"
                            checkedBinding="resultsPersistentOption@multiMonPwdBean@servletRequest"
                            textBinding="KEEP_HISTORY@MultiTargetResourceBundle"/>
                        <uix:messagePrompt/>
                        <uix:submitButton
                            textBinding="EXECUTE@MultiTargetResourceBundle"
                            name="event"
                            value="execute"/>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>
<%--
  END OF COMMAND/SQL INPUT FIELDS
--%>
<%--
  BEGINNING OF CREDENTIALS INPUT FIELDS
--%>
                <uix:header
                    textBinding="credHeader@multiMonPwdBean@servletRequest">
                  <uix:tableLayout width="100%" cellSpacing="1">
                    <uix:rowLayout>
                      <uix:cellFormat wrappingDisabled="true">
                        <uix:radioButton
                            id="prefCredOptionUsePrefCred"
                            name="prefCredOption"
                            textBinding="USE_PREF_CRED@JobsResourceBundle"
                            selectedValueBinding="prefCredOption@multiMonPwdBean@servletRequest"
                            onClick="submitForm('multiMonPwd', true, {'event':'usePrefCredsClicked'})"
                            value="USE_PREF_CRED"/>
                        <uix:radioButton
                            id="prefCredOptionOverridePrefCred"
                            name="prefCredOption"
                            textBinding="OVERRIDE_PREF_CRED@JobsResourceBundle"
                            selectedValueBinding="prefCredOption@multiMonPwdBean@servletRequest"
                            onClick="submitForm('multiMonPwd', true, {'event':'overridePrefCredsClicked'})"
                            value="OVERRIDE_PREF_CRED"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:labeledFieldLayout labelWidth="30%">
                        <uix:messageChoice
                            name="prefCredType"
                            renderedBinding="renderPrefCredType@multiMonPwdBean@servletRequest"
                            promptBinding="PREF_CRED_TYPE@JobsResourceBundle"
                            selectedValueBinding="prefCredType@multiMonPwdBean@servletRequest">
                          <uix:option
                              value="NORMAL"
                              textBinding="PREF_CRED_LEVEL_NORMAL@JobsResourceBundle"/>
                          <uix:option
                              value="PRIV"
                              textBinding="prefCredPrivText@multiMonPwdBean@servletRequest"/>
                        </uix:messageChoice>
                <%--
                        <uix:messageTextInput
                            name="hostUsername"
                            required="uiOnly"
                            renderedBinding="overrideCredClicked@multiMonPwdBean@servletRequest"
                            columns="20"
                            textBinding="hostUsername@multiMonPwdBean@servletRequest"
                            promptBinding="HOST_USERNAME@JobsResourceBundle"
                            messageBinding="(HOST_USERNAME@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(HOST_USERNAME@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageTextInput
                            name="hostPasswordSecret"
                            required="uiOnly"
                            renderedBinding="overrideCredClicked@multiMonPwdBean@servletRequest"
                            columns="20"
                            secret="true"
                            textBinding="hostPasswordSecret@multiMonPwdBean@servletRequest"
                            promptBinding="HOST_PASSWORD@JobsResourceBundle"
                            messageBinding="(HOST_PASSWORD@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(HOST_PASSWORD@JobsResourceBundle)@messageTypes@servletRequest"/>
                --%>
                        <uix:messageTextInput
                            name="databaseUsername"
                            required="uiOnly"
                            columns="20"
                            renderedBinding="databaseCredsRendered@multiMonPwdBean@servletRequest"
                            textBinding="databaseUsername@multiMonPwdBean@servletRequest"
                            promptBinding="DATABASE_USERNAME@JobsResourceBundle"
                            messageBinding="(DATABASE_USERNAME@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(DATABASE_USERNAME@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageTextInput
                            name="databasePasswordSecret"
                            required="uiOnly"
                            columns="20"
                            secret="true"
                            renderedBinding="databaseCredsRendered@multiMonPwdBean@servletRequest"
                            textBinding="databasePasswordSecret@multiMonPwdBean@servletRequest"
                            promptBinding="DATABASE_PASSWORD@JobsResourceBundle"
                            messageBinding="(DATABASE_PASSWORD@JobsResourceBundle)@messages@servletRequest"
                            messageTypeBinding="(DATABASE_PASSWORD@JobsResourceBundle)@messageTypes@servletRequest"/>
                        <uix:messageChoice
                            name="databaseRole"
                            renderedBinding="databaseCredsRendered@multiMonPwdBean@servletRequest"
                            promptBinding="DATABASE_ROLE@JobsResourceBundle"
                            selectedValueBinding="databaseRole@multiMonPwdBean@servletRequest">
                          <uix:option
                              value="NORMAL"
                              textBinding="PREF_CRED_LEVEL_NORMAL@JobsResourceBundle"/>
                          <uix:option
                              value="PRIV"
                              text="SYSDBA"/>
                        </uix:messageChoice>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>

<%--
  END OF CREDENTIALS INPUT FIELDS
--%>

              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:spacer width="12"/>
                <uix:separator/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer width="12"/>
                <uix:stackLayout>
                  <uix:borderLayout id="Targets_Table">
                    <uix:left>
                      <uix:switcher 
                          childNameBinding="executionResultsAvailable@multiMonPwdBean@servletRequest">
                        <uix:case name="false">
                          <uix:styledText
                              styleClass="OraInstructionText"
                              textBinding="willBeExecutedInfo@multiMonPwdBean@servletRequest"/>
                        </uix:case>
                        <uix:case name="true">
                          <uix:borderLayout>
                            <uix:left>
                              <uix:labeledFieldLayout 
                                  renderedBinding="executionResultsAvailable@multiMonPwdBean@servletRequest"
                                  labelWidth="10%" columns="2">
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="SUCCEEDED@MultiTargetResourceBundle"
                                    textBinding="numSucceeded@multiMonPwdBean@servletRequest"/>
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="FAILED@MultiTargetResourceBundle"
                                    textBinding="numFailed@multiMonPwdBean@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:left>
                            <uix:right>
                              <uix:labeledFieldLayout 
                                  renderedBinding="executionResultsAvailable@multiMonPwdBean@servletRequest"
                                  labelWidth="10%" columns="1">
                                <uix:messageStyledText
                                    contentStyleClass="OraDataText"
                                    promptBinding="EXECUTED@MultiTargetResourceBundle"
                                    textBinding="formattedExecuteDate@multiMonPwdBean@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:right>
                          </uix:borderLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:left>
                    <uix:right>
                      <uix:tableLayout width="100%">
                        <uix:rowLayout hAlign="right">
                          <uix:cellFormat wrappingDisabled="true">
                            <uix:pageButtonBar>
                              <uix:submitButton
                                  renderedBinding="executionResultsAvailable@multiMonPwdBean@servletRequest"
                                  textBinding="SAVE_RESULTS@MultiTargetResourceBundle"
                                  name="event"
                                  value="saveResults"/>
                              <oem:targetSelection
                                  textBinding="ADD@SDKUIResourceBundle"/>
                            </uix:pageButtonBar>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:right>
                  </uix:borderLayout>

                  <uix:dataScope
                      currentDataBinding="multiMonPwdTable@multiMonPwdBean@servletRequest">

                    <uix:table
                        id="Targets"
                        name="multiMonPwdTable" 
                        formSubmitted="true"
                        partialRenderMode="self"
                        minValue="1"
                        showAll="yes"
                        width="100%"
                        summaryBinding="EXECUTION_RESULTS@MultiTargetResourceBundle"
                        allDetailsEnabledBinding="renderShowAllHideAllDetailsLinks"
                        detailDisclosureBinding="detailDisclosureList"
                        tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                        valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                        maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                        blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                        alternateTextBinding="NO_TARGETS_FOUND@MultiTargetResourceBundle">

                      <uix:detail>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="left">
                              <uix:rawText text="<pre>"/>
                                <uix:text
                                    textBinding="results"/>
                              <uix:rawText text="</pre>"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout renderedBinding="renderDetailsColumnShowMore">
                            <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  text=". . ."
                                  shortDescBinding="RESULTS_TRUNCATED@MultiTargetResourceBundle"
                                  styleClass="OraInstructionTextStrong"/>
                              <uix:spacer width="20"/>
                              <uix:link
                                  textBinding="COMPLETE_EXECUTION_RESULTS@MultiTargetResourceBundle"
                                  destinationBinding="detailsColumnShowMoreDestination"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:detail>

                      <%-- Database column - only displayed with Execute SQL --%>
                      <uix:column renderedBinding="renderDatabaseColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="NAME@SDKUIResourceBundle"
                              sortableBinding="databaseColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="databaseColumn"
                            destinationBinding="databaseColumnDestination"
                            messageBinding="databaseColumnMessage"
                            messageTypeBinding="databaseColumnMessageType">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Target Type column - only displayed with Execute SQL --%>
                      <uix:column renderedBinding="renderDatabaseColumn">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="TYPE@MultiTargetResourceBundle"
                              sortableBinding="targetTypeColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="targetTypeColumn">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Host column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="HOST@MultiTargetResourceBundle"
                              sortableBinding="hostColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:messageStyledText
                            textBinding="hostColumn"
                            destinationBinding="hostColumnDestination"
                            messageBinding="hostColumnMessage"
                            messageTypeBinding="hostColumnMessageType">
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- Execution Status column - always displayed
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXECUTION_STATUS@MultiTargetResourceBundle"
                              sortableBinding="executionStatusColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="executionStatusColumn"
                            sourceBinding="executionStatusColumnIcon"
                            destinationBinding="executionStatusColumnDestination"
                            textBinding="NO_EXECUTION_CONDUCTED@MultiTargetResourceBundle"/>
                      </uix:column>
                      --%>

                      <%-- Elapsed Time column - always displayed
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="EXEC_TABLE_RUNNING_TIME_COLUMN@JobsResourceBundle"
                              sortableBinding="elapsedTimeColumnSortable"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:messageStyledText
                            textBinding="elapsedTimeColumn">
                        </uix:messageStyledText>
                      </uix:column>
                      --%>

                      <%-- Remove column - always displayed --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                              textBinding="REMOVE@SDKUIResourceBundle"/>
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image
                            shortDescBinding="REMOVE@SDKUIResourceBundle"
                            sourceBinding="removeColumnIcon"
                            onClickBinding="removeColumnDestination"/>
                      </uix:column>

                    </uix:table>
                  </uix:dataScope>

                  <uix:messageText
                      messageBinding="(TARGETS_TABLE@MultiTargetResourceBundle)@messages@servletRequest"
                      messageTypeBinding="(TARGETS_TABLE@MultiTargetResourceBundle)@messageTypes@servletRequest"/>

                </uix:stackLayout>
              </uix:rowLayout>

              <uix:rowLayout renderedBinding="switchToSimpleRendered@multiMonPwdBean@servletRequest">
                <uix:spacer width="12"/>
                <uix:link
                    textBinding="SWITCH_TO_SIMPLE_LINK@MultiTargetResourceBundle"
                    destinationBinding="switchToSimpleURL@multiMonPwdBean@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="switchToSimpleRendered@multiMonPwdBean@servletRequest">
                <uix:spacer width="12"/>
                <uix:tip>
                  <uix:styledText
                      styleClass="OraTipText"
                      textBinding="SWITCH_TO_SIMPLE_TIP@MultiTargetResourceBundle"/>
                </uix:tip>
              </uix:rowLayout>
            </uix:tableLayout>

            <%-------------------------
             -  Page Buttons
             ---------------------------%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                  name="event"
                  value="cancel"
                  textBinding="CANCEL@ConfigResourceBundle"/>
                <uix:submitButton
                  name="event"
                  value="execute"
                  textBinding="OK@ConfigResourceBundle"/>
              </uix:pageButtonBar>
            </uix:pageButtons>


          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
