<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiMonPwdBean"
    scope="request"
    type="oracle.sysman.db.conf.monpwd.MultiMonPwdBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="multiMonPwdChangeTargetType" method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="target/multiMonPwdChangeTargetType"/>

          <uix:pageLayout titleBinding="title@multiMonPwdBean@servletRequest">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:stackLayout>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:styledText
                      styleClass="OraInstructionText" 
                      textBinding="CHANGE_TARGET_TYPE_TIP@MultiTargetResourceBundle"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:messageChoice
                      name="targetTypeSelectedChoice"
                      promptBinding="TARGET_TYPE@SDKUIResourceBundle"
                      selectedValueBinding="targetTypeSelectedValue@multiMonPwdBean@servletRequest">
                    <uix:contents
                        childDataBinding="targetTypeList@multiMonPwdBean@servletRequest">
                      <uix:option
                          textBinding="targetTypeText"
                          valueBinding="targetTypeValue"/>
                    </uix:contents>
                    <%--
                    <uix:contents> 
                      <uix:option value="Agent" 
                          text="Agent"/>
                      <uix:option value="Beacon" 
                          text="Beacon"/>
                      <uix:option value="Database Instance" 
                          text="Database Instance"/>
                      <uix:option value="Host" 
                          text="Host"/>
                      <uix:option value="HTTP Server" 
                          text="HTTP Server"/>
                      <uix:option value="Listener" 
                          text="Listener"/>
                      <uix:option value="Web Cache" 
                          text="Web Cache"/>
                    </uix:contents>
                    --%>
                  </uix:messageChoice>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="CANCEL@SDKUIResourceBundle"
                    name="event"
                    value="return"/>
                <uix:submitButton
                    textBinding="OK@SDKUIResourceBundle"
                    name="event"
                    value="changeTargetTypeOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
