<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       multiMonPwdLoadFromFile.jsp 
 *
 *      NOTES
 *       Execute Host Command/Execute SQL, Load From File page.
 *
 * MODIFIED
 *    jstone     11/14/05 - 
 *    kmckeen    05/07/05 - Ada fixes 
 *    kmckeen    02/14/05 - Change rfs alert to submitForm 
 *    kmckeen    01/26/05 - Support load from remote file.
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<jsp:useBean
    id="multiMonPwdBean"
    scope="request"
    type="oracle.sysman.db.conf.monpwd.MultiMonPwdBean"/>

<script language="JavaScript">
  <%@ include file="/cabo/jsLibs/TableProxy.js" %>
</script>

<script>
 function myCallBack(lovWindow, event)
 {
   return true;
 }
 function launchRfs()
 {
   var host = document.multiMonPwdLoadFromFile.loadFromFileHost.value;
   host = ";" + trim(host) + ";";
   var hostsArray = document.multiMonPwdLoadFromFile.hostsTable.value;
   var hostInArray = false;

   if (host != ";;")
   {
     if (hostsArray.indexOf(host) != -1)
     {
       hostInArray = true;
     }
   }

   var remoteFileSelectorURL = document.multiMonPwdLoadFromFile.remoteFileSelectorURL.value;
   if (hostInArray == true && remoteFileSelectorURL != "")
   {
     openWindow(window, '../page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
   }
   else
   {
     //alert(document.multiMonPwdLoadFromFile.unknownHostErrorMsg.value);
     submitForm('multiMonPwdLoadFromFile', false, {event:'unknownHostError'});
   }
 }

 function trim(value)
 {
   value = value.replace( /^\s+/g, "" );// trim leading
   return value.replace( /\s+$/g, "" );// trim trailing
 }
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="JobsResourceBundle" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="MntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form 
            name="multiMonPwdLoadFromFile" 
            usesUpload="true"
            method="post">

          <uix:formValue
              name="<%= EmlConstants.PAGE_NAME_PAGE_PROPERTY %>"
              value="<%= PageNames.MULTI_TARGET_LOAD_FROM_FILE_PAGE %>"/>

          <uix:formValue 
              name="remoteFileSelectorURL" 
              valueBinding="remoteFileSelectorURL@multiMonPwdBean@servletRequest"/>

          <uix:formValue 
              name="hostsTable" 
              valueBinding="hostsTable@multiMonPwdBean@servletRequest"/>

          <uix:formValue 
              name="unknownHostErrorMsg" 
              valueBinding="unknownHostErrorMsg@multiMonPwdBean@servletRequest"/>

          <uix:pageLayout titleBinding="loadTitle@multiMonPwdBean@servletRequest">

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <%-- cannot save browser file name --%>
            <uix:radioButton
                name="loadFromFileOption"
                value="LOAD_FROM_BROWSER"
                textBinding="FILE_ON_BROWSER@MultiTargetResourceBundle"
                selectedValueBinding="loadFromFileOption@multiMonPwdBean@servletRequest"
                onClick="submitForm('multiMonPwd', true, {'event':'loadFromBrowserClicked'})"/>
            <uix:labeledFieldLayout labelWidth="10%">
              <uix:messageFileUpload
                  id="fileOnBrowser"
                  name="fileOnBrowser"
                  columns="80"
                  promptBinding="BROWSER_FILE@MultiTargetResourceBundle"
                  messageBinding="(BROWSER_FILE@MultiTargetResourceBundle)@messages@servletRequest"
                  messageTypeBinding="(BROWSER_FILE@MultiTargetResourceBundle)@messageTypes@servletRequest"/>
            </uix:labeledFieldLayout>

            <uix:radioButton
                name="loadFromFileOption"
                value="LOAD_FROM_HOST"
                textBinding="FILE_ON_HOST@MultiTargetResourceBundle"
                disabledBinding="disableLoadFromHostControls@multiMonPwdBean@servletRequest"
                selectedValueBinding="loadFromFileOption@multiMonPwdBean@servletRequest"
                onClick="submitForm('multiMonPwd', true, {'event':'loadFromHostClicked'})"/>
            <uix:labeledFieldLayout labelWidth="10%">
              <uix:messageLovInput
                  id="loadFromFileHost"
                  name="loadFromFileHost"
                  columns="80"
                  searchDescBinding="CLICK_TO_SELECT_HOST@MultiTargetResourceBundle"
                  disabledBinding="disableLoadFromHostControls@multiMonPwdBean@servletRequest"
                  promptBinding="HOST@MultiTargetResourceBundle"
                  textBinding="loadFromFileHost@multiMonPwdBean@servletRequest"
                  destinationBinding="loadFromFileHostLOVDest@multiMonPwdBean@servletRequest"
                  messageBinding="(HOST@MultiTargetResourceBundle)@messages@servletRequest"
                  messageTypeBinding="(HOST@MultiTargetResourceBundle)@messageTypes@servletRequest"/>
              <uix:messageLovField
                  id="fileOnHost"
                  name="fileOnHost"
                  columns="80"
                  onClick="launchRfs();"
                  searchDescBinding="CLICK_TO_SELECT_FILE@MultiTargetResourceBundle"
                  disabledBinding="disableLoadFromHostControls@multiMonPwdBean@servletRequest"
                  promptBinding="HOST_FILE@MultiTargetResourceBundle"
                  textBinding="fileOnHost@multiMonPwdBean@servletRequest"
                  messageBinding="(HOST_FILE@MultiTargetResourceBundle)@messages@servletRequest"
                  messageTypeBinding="(HOST_FILE@MultiTargetResourceBundle)@messageTypes@servletRequest"/>
            </uix:labeledFieldLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="CANCEL@SDKUIResourceBundle"
                    name="event"
                    value="return"/>
                <uix:submitButton
                    textBinding="LOAD@MultiTargetResourceBundle"
                    name="event"
                    value="loadFromFileOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
