<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/oemTitle.jspf" %>
  <uix:styleSheet/>

  <uix:body>
    <db:form 
      copyParams="target,type,cancelURL"
      name="packagesForm" destination="config">

      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/>
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:stackLayout>
          <uix:contents>
          <uix:spacer height="10"/>
           <uix:train selectedIndex="1">
             <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
               <uix:link textBinding="."/>
             </uix:contents>
           </uix:train>
          <uix:header textBinding="packageHeader@defaultBean@servletRequest">

            <uix:stackLayout>

              <uix:rowLayout>
                <uix:switcher childNameBinding="pkgState@defaultBean@servletRequest">
                  <uix:case name="2">
                    <%---------------------------------------------
                     - All packages are currently installed
                     ----------------------------------------------%>
                    <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="COMPLETE_CONFIG@configBundle@servletRequest" />
                  </uix:case>
                  <uix:case name="1">
                    <%---------------------------------------------
                     - Some packages are currently installed
                     ----------------------------------------------%>
                    <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="PACKAGES_DESC@configBundle@servletRequest" />
                  </uix:case>
                  <uix:case name="0">
                    <%---------------------------------------------
                     - No packages are currently installed
                     ----------------------------------------------%>
                    <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="PACKAGES_DESC@configBundle@servletRequest" />
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer width="10" />
              </uix:rowLayout>

              <%@ include file="metrics.jspf" %>
              <uix:spacer height="10"/>

              <uix:rowLayout>
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="PACKAGES_DESC1@configBundle@servletRequest" />
              </uix:rowLayout>

              <uix:tableLayout cellSpacing="1" width="100%">

                <%-----------------------------------------------
                 - RADIO BUTTON: INSTALL (or REINSTALL)
                 - Offers to "Install" when nothing is installed
                 - Offers to "Reinstall" when some portion is installed
                 - Otherwise, (re)installation is not offered
                 ------------------------------------------------%>
                <uix:switcher childNameBinding="pkgState@defaultBean@servletRequest">
                  <uix:case name="0">
                    <%---------------------------------------------
                     - No packages are currently installed
                     - Offer to install
                     ----------------------------------------------%>
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <oem:radioButton
                          name="installPkgs"
                          value="1"
                          selectedValueBinding="installPkgs@defaultBean@pageContext"
                          textBinding="BASIC_INSTALL@configBundle@servletRequest"
                          styleClass="OraInstructionText" />	
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="20"/>
                        </uix:cellFormat>
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:checkBox name="advancedInstall" 
                              checkedBinding="advancedInstall@defaultBean@servletRequest"  
                        textBinding="ADVANCED_INSTALL@configBundle@servletRequest" />
                        </uix:cellFormat>
                      </uix:rowLayout>

                    </uix:stackLayout>
                    
                  </uix:case>
                  <uix:case name="1">
                    <%---------------------------------------------
                     - Some (but not all) packages are currently installed
                     - Offer to reinstall
                     ----------------------------------------------%>
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <oem:radioButton
                          name="installPkgs"
                          value="1"
                          selectedValueBinding="installPkgs@defaultBean@pageContext"
                          textBinding="LONG_REINSTALL_PROMPT@configBundle@servletRequest"
                          styleClass="OraInstructionText"/>	
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:spacer width="20"/>
                        </uix:cellFormat>
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:checkBox name="advancedInstall" 
                              checkedBinding="advancedInstall@defaultBean@servletRequest"  
                        textBinding="ADVANCED_INSTALL@configBundle@servletRequest" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:stackLayout>

                  </uix:case>
                </uix:switcher>

                <%-----------------------------------------------
                 - RADIO BUTTON: SKIP
                 ------------------------------------------------%>
                <uix:switcher childNameBinding="pkgState@defaultBean@servletRequest">
                  <uix:case name="2">
                    <%---------------------------------------------
                     - All packages are currently installed
                     - Offer to skip, leaving the metrics enabled
                     ----------------------------------------------%>
                    <uix:rowLayout>
                      <oem:radioButton
                         name="installPkgs"
                         value="0"
                         selectedValueBinding="installPkgs@defaultBean@pageContext"
                         textBinding="SKIP_COMPLETE@configBundle@servletRequest"
                         styleClass="OraInstructionText" />
                    </uix:rowLayout>
                  </uix:case>
                  <uix:case name="1">
                    <%---------------------------------------------
                     - Some packages are not currently installed
                     - Offer to skip, leaving the metrics disabled
                     ----------------------------------------------%>
                    <uix:rowLayout>
                      <oem:radioButton
                         name="installPkgs"
                         value="0"
                         selectedValueBinding="installPkgs@defaultBean@pageContext"
                         textBinding="SKIP@configBundle@servletRequest"
                         styleClass="OraInstructionText" />
                    </uix:rowLayout>
                  </uix:case>
                  <uix:case name="0">
                    <%---------------------------------------------
                     - No packages are currently installed
                     - Offer to skip, leaving the metrics disabled
                     ----------------------------------------------%>
                    <uix:rowLayout>
                      <oem:radioButton
                         name="installPkgs"
                         value="0"
                         selectedValueBinding="installPkgs@defaultBean@pageContext"
                         textBinding="SKIP@configBundle@servletRequest"
                         styleClass="OraInstructionText" />
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>

                <%-----------------------------------------------
                 - RADIO BUTTON: UNINSTALL
                 - Only offer this button when something is installed
                 ------------------------------------------------%>
                <uix:switcher childNameBinding="pkgState@defaultBean@servletRequest">
                  <uix:case name="2">
                    <%---------------------------------------------
                     - All packages are currently installed
                     - Offer to uninstall
                     ----------------------------------------------%>
                    <uix:stackLayout>
                    <uix:rowLayout>
                      <oem:radioButton
                        name="installPkgs"
                        value="2"
                        selectedValueBinding="installPkgs@defaultBean@pageContext"
                        textBinding="UNINSTALL@configBundle@servletRequest"
                        styleClass="OraInstructionText"
                      />
                    </uix:rowLayout>
                    </uix:stackLayout>
                  </uix:case>
                  <uix:case name="1">
                    <%---------------------------------------------
                     - Not all packages are currently installed
                     - Offer to uninstall
                     ----------------------------------------------%>
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <oem:radioButton
                          name="installPkgs"
                          value="2"
                          selectedValueBinding="installPkgs@defaultBean@pageContext"
                          textBinding="UNINSTALL@configBundle@servletRequest"
                          styleClass="OraInstructionText" />	
                      </uix:rowLayout>
                    </uix:stackLayout>
                  </uix:case>
                </uix:switcher>

              </uix:tableLayout>
            </uix:stackLayout>

          </uix:header>

          </uix:contents>
        </uix:stackLayout>

       <uix:pageButtons> 
         <uix:pageButtonBar>         
           <uix:submitButton 
             textBinding="CANCEL@configBundle@servletRequest" 
             name="event" 
             value="cancel" />

           <uix:spacer width="10"/>
           <uix:navigationBar
             name="step"
             minValue="1"
             maxValue="5"
             value="2"
             formSubmitted="true"
             formName="packagesForm"/>

           <uix:spacer width="10"/>
           <uix:submitButton 
             textBinding="finishLabel@defaultBean@pageContext" 
             name="event" 
             value="finish" />
         </uix:pageButtonBar>  
       </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
	     	
</uix:renderingContext>

<%-------------------------------  End of File  ------------------------------%>
