<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
<db:script src="/database/utils.js"/>
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>     
  <uix:body> 
    <db:form 
      copyParams="target,type,cancelURL"
      name="paramForm" method="post" destination="config">  
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/>  
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>    
        <uix:spacer height="10"/>                                    
	      <uix:train selectedIndex="3">
          <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
            <uix:link textBinding="."/>
          </uix:contents>
        </uix:train>
            
        <uix:stackLayout>
          <uix:contents>
            <uix:header textBinding="paramsHeader@defaultBean@servletRequest">
             
<uix:switcher childNameBinding="installPkgs@defaultBean@servletRequest">
  <uix:case name="1">  

    <%-- <uix:switcher childNameBinding="installMonitorObj@defaultBean@servletRequest">
      <uix:case name="1">                            
        <uix:header textBinding="DB_MONITOR_USER@configBundle@servletRequest">      
        <uix:stackLayout>
         <uix:switcher childNameBinding="installDMO@servletRequest">
           <uix:case name="1">
              <uix:rowLayout>
                <uix:cellFormat wrappingDisabled="true">
                <uix:checkBox name="installDM" checkedBinding="installDM@defaultBean@servletRequest"
                             textBinding="DB_OBJ_EXIST@configBundle@servletRequest" />
                 </uix:cellFormat>
              </uix:rowLayout>
           </uix:case>
         </uix:switcher>   	        
--%>

           <uix:switcher childNameBinding="installDBMUser@defaultBean@servletRequest">
          	 <uix:case name="1">    
          	 <uix:stackLayout>
          	  <uix:rowLayout>
               <uix:styledText  styleClass="OraInstructionText" textBinding="DBSNMP_DESC@configBundle@servletRequest" />   
              </uix:rowLayout>
              
   	          <uix:tableLayout cellSpacing="5">
              <uix:contents>      	 
              <uix:rowLayout> 
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>                           
                      <uix:messagePrompt promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:contents>       
                      <uix:styledText styleClass="OraDataText" text="DBSNMP" />                     
                    </uix:contents>                 
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>          	 
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:contents>   
                      <uix:messagePrompt promptBinding="PASSWORD@configBundle@servletRequest"/> 
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true">
                    <uix:stackLayout>
                    <uix:contents>                      
                      <uix:textInput name="dbmPassword" textBinding="dbmPassword@defaultBean@pageContext" noAutoComplete="true" secret="true" />

                    </uix:contents>
                    </uix:stackLayout>                  
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout> 
            </uix:contents>   
         </uix:tableLayout>         
          </uix:stackLayout>                             
            </uix:case>
            
            <uix:case name="0">    
            <uix:stackLayout>
          	  <uix:rowLayout>
               <uix:styledText styleClass="OraInstructionText" textBinding="DBSNMP_DESC@configBundle@servletRequest" />   
              </uix:rowLayout>
              
   	          <uix:tableLayout cellSpacing="5">
              <uix:contents>      	             
              <uix:rowLayout> 
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>                           
                      <uix:messagePrompt promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:contents>       
                      <uix:styledText styleClass="OraDataText" text="DBSNMP" />                     
                    </uix:contents>                 
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>          	             
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:contents>   
                      <uix:messagePrompt  required="yes" promptBinding="PASSWORD@configBundle@servletRequest"/> 
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true">
                    <uix:stackLayout>
                    <uix:contents>                      
                      <uix:textInput name="dbmPassword" textBinding="dbmPassword@defaultBean@pageContext" noAutoComplete="true" secret="true" />
                      <uix:messageText messageType="error" messageBinding="dbmPassword@errors@servletRequest"/>
                    </uix:contents>
                    </uix:stackLayout>                  
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>                                      
            </uix:contents>   
         </uix:tableLayout>         
             </uix:stackLayout> 
            </uix:case>
          </uix:switcher> 
         
         </uix:case>
         </uix:switcher>
         
   
<uix:switcher childNameBinding="installStatsPack@defaultBean@servletRequest">
  <uix:case name="1">  
  
     <uix:switcher childNameBinding="installSP@servletRequest">
	 <uix:case name="1">
        <uix:header textBinding="STATSPACK_USER@configBundle@servletRequest">      
          <uix:tableLayout cellSpacing="5">
            <uix:contents>
              <uix:rowLayout> 
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>                           
                      <uix:messagePrompt promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:contents>       
                      <uix:styledText styleClass="OraDataText" text="PERFSTAT" />                     
                    </uix:contents>                 
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:contents>      
                      <uix:messagePrompt required="yes" promptBinding="DEFAULT_TABLESPACE@configBundle@servletRequest"/>                                                          
                    </uix:contents>
                  </uix:cellFormat>
                  
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>
                    <uix:contents>  
                      <uix:lovField name="spDefTbsp" textBinding="spDefTbsp@defaultBean@pageContext" 
                        onClickBinding="defTablespaceDest@defaultBean@pageContext" /> 

                      <uix:messageText messageType="error" messageBinding="spDefTbsp@errors@servletRequest"/>                        
                    </uix:contents>
                    </uix:stackLayout>   
                 </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:contents>      
                      <uix:messagePrompt required="yes" promptBinding="TEMP_TABLESPACE@configBundle@servletRequest"/>                                                          
                    </uix:contents>
                  </uix:cellFormat>
                  
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>
                    <uix:contents>  
                      <uix:lovField name="spTmpTbsp" textBinding="spTmpTbsp@defaultBean@pageContext" 
                        onClickBinding="tmpTablespaceDest@defaultBean@pageContext" />
                      <uix:messageText messageType="error" messageBinding="spTmpTbsp@errors@servletRequest"/>  
                    </uix:contents>  
                    </uix:stackLayout> 
                 </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
                                          
            </uix:contents>   
         </uix:tableLayout>
       </uix:header>
      </uix:case>
      <uix:case name="0">
        <uix:switcher childNameBinding="showSP@defaultBean@servletRequest">
      	 <uix:case name="1">
      	 
        <uix:header textBinding="STATSPACK_USER@configBundle@servletRequest"> 
                   <uix:spacer height="5"/>     
                   <uix:styledText  styleClass="OraInstructionText" textBinding="STATSPACK_EXIST@configBundle@servletRequest" />
                   <uix:spacer height="5"/>     
          <uix:tableLayout cellSpacing="5">
            <uix:contents>
              <uix:rowLayout> 
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>                           
                      <uix:messagePrompt promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:contents>       
                      <uix:styledText styleClass="OraDataText" text="PERFSTAT" />                     
                    </uix:contents>                 
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:contents>   
                      <uix:messagePrompt  required="yes" promptBinding="PASSWORD@configBundle@servletRequest"/>                 
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>                                       
                    <uix:contents>                         
                        <uix:textInput name="spPassword" textBinding="spPassword@defaultBean@pageContext" noAutoComplete="true" secret="true" />
                        <uix:messageText messageType="error" messageBinding="spPassword@errors@servletRequest"/>  
                    </uix:contents>    
                    </uix:stackLayout>              
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
                </uix:contents>
             </uix:tableLayout>
                                                     
         </uix:header>
        </uix:case>   
       </uix:switcher>  

     </uix:case>   
    </uix:switcher>  
       
      	 </uix:case>      	 
       </uix:switcher>

 

      <uix:switcher childNameBinding="hostCred@defaultBean@servletRequest">
      	 <uix:case name="true">
        <uix:header textBinding="HOST_CRED@configBundle@servletRequest">   
        <uix:stackLayout>
           	  <uix:rowLayout>
               <uix:styledText styleClass="OraInstructionText" textBinding="HOST_CRED_DESC@configBundle@servletRequest" />   
              </uix:rowLayout>   
          <uix:tableLayout cellSpacing="5">
            <uix:contents>
              <uix:rowLayout> 
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>                           
                      <uix:messagePrompt required="yes" promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>
                    <uix:contents>       
                      <uix:textInput name="hostUserName" textBinding="hostUserName@defaultBean@pageContext" noAutoComplete="true"/>
                      <uix:messageText messageType="error" messageBinding="hostUserName@errors@servletRequest"/> 
                    </uix:contents>                 
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:contents>   
                      <uix:messagePrompt  required="yes" promptBinding="PASSWORD@configBundle@servletRequest"/> 
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>
                    <uix:contents>                      
                      <uix:textInput name="hostPassword" textBinding="hostPassword@defaultBean@pageContext" noAutoComplete="true" secret="true" />
                      <uix:messageText messageType="error" messageBinding="hostPassword@errors@servletRequest"/>                       
                    </uix:contents>                  
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
                            
            </uix:contents>   
         </uix:tableLayout>
          </uix:stackLayout>
       </uix:header>
        </uix:case>

      	 <uix:case name="false">
        <uix:header textBinding="HOST_CRED@configBundle@servletRequest">   
          <uix:stackLayout>
           	  <uix:rowLayout>
               <uix:styledText  styleClass="OraInstructionText" textBinding="HOST_CRED_DESC@configBundle@servletRequest" />   
              </uix:rowLayout>              
          <uix:tableLayout cellSpacing="5">
            <uix:contents>
              <uix:rowLayout> 
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                    <uix:contents>                           
                      <uix:messagePrompt  promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>
                    <uix:contents>       
                      <uix:textInput name="hostUserName" textBinding="hostUserName@defaultBean@pageContext" noAutoComplete="true" />
                      <uix:messageText messageType="error" messageBinding="hostUserName@errors@servletRequest"/> 
                    </uix:contents>                 
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                    <uix:contents>   
                      <uix:messagePrompt promptBinding="PASSWORD@configBundle@servletRequest"/> 
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                    <uix:stackLayout>
                    <uix:contents>                      
                      <uix:textInput name="hostPassword" textBinding="hostPassword@defaultBean@pageContext" noAutoComplete="true" secret="true" />
                      <uix:messageText messageType="error" messageBinding="hostPassword@errors@servletRequest"/>                       
                    </uix:contents>                  
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
                            
            </uix:contents>   
         </uix:tableLayout>
          </uix:stackLayout>
       </uix:header>
        </uix:case>
      </uix:switcher>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
      
       <uix:pageButtons> 
         <uix:pageButtonBar>         
           <uix:submitButton 
             textBinding="CANCEL@configBundle@servletRequest" 
             name="event" 
             value="cancel" />

           <uix:spacer width="10"/>
           <uix:navigationBar
             name="step"
             minValue="1"
             maxValue="5"
             value="4"  
             formSubmitted="true"
             formName="paramForm"/>
         </uix:pageButtonBar>  
       </uix:pageButtons>

      
     </uix:pageLayout>       
    </db:form>  
  </uix:body> 
</uix:document> 
	     	     
</uix:renderingContext>
