<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>  
  <uix:body> 
    <uix:form name="progressForm" destination="config">  
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/> 
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/> 
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
      
        <uix:spacer height="10"/>     
        <uix:stackLayout>
          <uix:contents>
            <uix:header textBinding="progressHeader@defaultBean@servletRequest">
              <uix:stackLayout>
                <uix:contents>
                   <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                   <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>                
                   <uix:spacer height="10"/>     
                   <uix:formattedText textBinding="progress@servletRequest" />
                </uix:contents>
              </uix:stackLayout>                                                           
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
      
       <uix:pageButtons> 
         <uix:pageButtonBar>  
         <uix:switcher childNameBinding="isJob@servletRequest">
       	   <uix:case name="1"> 
             <uix:submitButton 
               textBinding="VIEW_JOB@configBundle@servletRequest" 
               name="event" 
               value="viewJob" />             
           </uix:case>
         </uix:switcher>                 
         <uix:spacer width="10"/>
         <uix:submitButton 
           textBinding="OK@configBundle@servletRequest" 
           shortDescBinding="OK@configBundle@servletRequest"
           name="event" 
           value="cancel" />
         </uix:pageButtonBar>
       </uix:pageButtons>
     </uix:pageLayout>       

    </uix:form>  
  </uix:body> 
</uix:document> 
	     	     
</uix:renderingContext>
