<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBConfigMsg"
	      class="oracle.sysman.db.rsc.conf.DBConfigMsg"/>
  <uix:bundle name="RacDBConfigMsg"
	      class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>   
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>
  <uix:body>      
      <db:form 
        copyParams="target,type,cancelURL"
        name="propForm" method="post" destination="config"> 
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/> 
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>    
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>    

        <%-------------------------
         -  Sync Drilldown button
         ---------------------------%>
        <uix:switcher 
          childNameBinding="syncEnabled@defaultBean@servletRequest">

          <uix:case name="true">
            <uix:tableLayout cellSpacing="10">          
              <uix:rowLayout hAlign="right"> 
                <uix:cellFormat wrappingDisabled="true" hAlign="right" >
                  <uix:submitButton
                    textBinding="CHANGE_DBSNMP_PWD@configSyncBundle@servletRequest"
                    shortDescBinding="CHANGE_DBSNMP_PWD@configSyncBundle@servletRequest" 
                    name="event" 
                    value="syncDrilldown"
                  />
                </uix:cellFormat>
              </uix:rowLayout> 
            </uix:tableLayout>          
          </uix:case>

        </uix:switcher>
        
        <uix:spacer height="10"/>
        <uix:train selectedIndex="0">
          <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
            <uix:link textBinding="."/>
          </uix:contents>
        </uix:train>              
                
        <uix:header textBinding="propsHeader@defaultBean@servletRequest" />    
        <uix:stackLayout>
          <uix:contents>          
            
            <uix:tableLayout cellSpacing="5">
              <uix:contents>     

              <uix:switcher childNameBinding="isEdit@defaultBean@pageContext">
                <uix:case name="0">
                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt required="yes" promptBinding="NAME@configBundle@servletRequest"/> 
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:stackLayout>
                        <uix:contents>       
                          <uix:textInput name="targetName" textBinding="targetName@defaultBean@pageContext" />
                          <uix:messageText messageType="error" messageBinding="Name@errors@servletRequest"/> 
                        </uix:contents>                 
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                </uix:case>

                <uix:case name="1">
                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt promptBinding="NAME@configBundle@servletRequest"/> 
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:stackLayout>
                        <uix:contents>       
                          <uix:styledText styleClass="OraDataText" textBinding="targetName@defaultBean@pageContext" />
                        </uix:contents>                 
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                </uix:case>
              </uix:switcher>

                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt promptBinding="TYPE@configBundle@servletRequest"/>                                             
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:contents>       
                        <uix:styledText styleClass="OraDataText" textBinding="displayType@defaultBean@pageContext" />                     
                      </uix:contents>                 
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>                          
           
                <uix:switcher childNameBinding="targetType@defaultBean@pageContext" 
                        renderedBinding="inCluster@defaultBean@pageContext">
                <uix:case name="oracle_database">
                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt prompt="Host"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:contents>       
                        <oem:choice name="hostName" styleClass="OraDataText" selectedValueBinding="hostName@defaultBean@servletRequest" 
                            optionsBinding="hosts@defaultBean@servletRequest" 
                            readOnlyBinding="hostNameReadOnly@defaultBean@servletRequest"/>
                      </uix:contents>                 
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout> 
                </uix:case>
                </uix:switcher>
                
                <%-- scan info --%>
                <uix:switcher childNameBinding="targetType@defaultBean@pageContext" 
                        renderedBinding="isScanDatabase@defaultBean@pageContext">
                <uix:case name="rac_database">
                <%-- scan name --%>
                <uix:rowLayout > 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt promptBinding="SCAN_NAME@RacDBConfigMsg"/>                                             
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:contents>       
                        <uix:styledText styleClass="OraDataText" textBinding="scanName@scanInfo@defaultBean@pageContext" />                     
                      </uix:contents>                 
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                </uix:case>
                </uix:switcher>
                <%-- scan port --%>
                <uix:switcher childNameBinding="targetType@defaultBean@pageContext" 
                        renderedBinding="isScanDatabase@defaultBean@pageContext">
                <uix:case name="rac_database">
                <uix:rowLayout >
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt promptBinding="SCAN_PORT@RacDBConfigMsg"/>                                             
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:contents>       
                        <uix:styledText styleClass="OraDataText" textBinding="scanPort@scanInfo@defaultBean@pageContext" />                     
                      </uix:contents>                 
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout> 
               </uix:case>
              </uix:switcher> 
              
           
              </uix:contents>   
           </uix:tableLayout>         
           
           <uix:tableLayout width="100%">
             <uix:contents>   
               <uix:rowLayout  hAlign="right">             
                 <uix:contents>       
                   <uix:submitButton textBinding="TEST_CONN@configBundle@servletRequest" shortDescBinding="TEST_CONN@configBundle@servletRequest" name="event" value="testConn" />
                 </uix:contents>
               </uix:rowLayout>   
               <uix:rowLayout>    
                 <uix:spacer height="5"/>             
               </uix:rowLayout> 
               <uix:rowLayout>                       
                 <uix:table  
                   width="100%"
                   summaryBinding="propsHeader@defaultBean@servletRequest"
                   tableDataBinding="propsData@defaultBean@pageContext"
                   columnHeaderDataBinding="propsColHeaderData@defaultBean@pageContext"
                   columnFormatsBinding="propsColFormats@@defaultBean@pageContext"
                   alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest">

                   <uix:tableFormat 
                     tableBanding="rowBanding"/>

                   <uix:columnHeaderStamp>
                     <uix:styledText 
                       textBinding="text"/>
                   </uix:columnHeaderStamp>

                   <uix:contents>
                     <uix:dataScope>
                       <uix:messagePrompt 
                         requiredBinding="isRequired"/>

                     <uix:switcher childNameBinding="propName" >
		       <uix:case name="PreferredConnectString">
                       <uix:stackLayout>
                       <uix:styledText  
                         textBinding="dispName" />
                         <uix:styledText styleClass="OraTipText" textBinding="PREFERRED_CONN_STR_HINT@DBConfigMsg" />
                       </uix:stackLayout>
                       </uix:case>
                       <uix:default>
                       <uix:styledText  
                         textBinding="dispName" />
                       </uix:default>
                     </uix:switcher>
                     </uix:dataScope>

                     <uix:switcher childNameBinding="propName" >
                       <uix:case name="DBVersion">
                         <uix:messageTextInput 
                           name="propTab"  
                           textBinding="propValue" 
                           readOnly="true"
                         />                      
                       </uix:case>  
                       <uix:case name="Role">
                         <uix:choice 
                           name="propTab"
                           selectedValueBinding="propValue" 
                           onChange="submitForm('propForm', true, {event:'changeRole'})"> 
                           <uix:contents childDataBinding="roleList@defaultBean@servletRequest">
                           <uix:option 
                           textBinding="rtext"
                           valueBinding="rval"/>
                         </uix:contents>
                         </uix:choice>      
                       </uix:case>  
		       <uix:case name="PreferredConnectString">
                             <uix:stackLayout>
                               <uix:contents>       
                                 <uix:textInput 
                                   name="propTab"  
                                   textBinding="propValue"  
		                   rows="5"
	                           columns="100"
                                   readOnlyBinding="isReadOnly"/>
                                 <uix:messageText
                                   messageBinding="(dispName)@errors@servletRequest"
                                   messageType="error"/>
                               </uix:contents>       
                             </uix:stackLayout>
                       </uix:case>
                       <uix:default>
                         <uix:switcher 
                           childNameBinding="isSecret">
                           <uix:case name="true">
                             <uix:switcher 
                               childNameBinding="propValue">
                               <uix:case name="">
                                 <uix:stackLayout>
                                   <uix:contents>       
                                     <uix:textInput 
                                       name="propTab"  
                                       text=""  
                                       secretBinding="isSecret"  
                                       noAutoComplete="true"
                                       readOnlyBinding="isReadOnly"/>
                                     <uix:messageText
                                       messageBinding="(MONITOR_PASSWORD@configBundle@servletRequest)@errors@servletRequest"
                                       messageType="error"/>
                                   </uix:contents>       
                                 </uix:stackLayout>
                               </uix:case>  
                               <uix:default>
                                 <uix:messageTextInput 
                                   name="propTab"  
                                   text="******"  
                                   noAutoComplete="true"
                                   secretBinding="isSecret"  
                                   readOnlyBinding="isReadOnly"/>
                               </uix:default>  
                             </uix:switcher>  
                           </uix:case>
                           <uix:default>
                             <uix:stackLayout>
                               <uix:contents>       
                                 <uix:textInput 
                                   name="propTab"  
                                   textBinding="propValue"  
                                   readOnlyBinding="isReadOnly"/>
                                 <uix:messageText
                                   messageBinding="(dispName)@errors@servletRequest"
                                   messageType="error"/>
                               </uix:contents>       
                             </uix:stackLayout>
                           </uix:default>   
                         </uix:switcher>
                       </uix:default>
                     </uix:switcher> 
                   </uix:contents>
                 </uix:table> 
                             
               </uix:rowLayout>
               
             <uix:switcher childNameBinding="dbType@defaultBean@servletRequest">
              <uix:case name="racdb"> 
                 <uix:rowLayout>
                 <uix:stackLayout>
                    <uix:spacer height="2"/>
                    <uix:tip>
                        <uix:styledText textBinding="SERVICE_NAME_DESC@configBundle@servletRequest"/>
                    </uix:tip>
                 </uix:stackLayout>
                 </uix:rowLayout>
              </uix:case>
              </uix:switcher>   
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
             </uix:contents>   
           </uix:tableLayout>
            
            <uix:switcher childNameBinding="dbType@defaultBean@servletRequest">
            <uix:case name="racdb"> 
            <uix:tableLayout width="100%">
             <uix:rowLayout>
                <uix:spacer height="10"/>
             </uix:rowLayout>
             
             <uix:rowLayout>       
             <uix:header textBinding="INSTANCES@configBundle@servletRequest">
               <uix:tableLayout width="100%">
               <uix:rowLayout hAlign="right">
                   <uix:submitButton disabledBinding="isEditDisabled@defaultBean@servletRequest" textBinding="ADD_LBL@configBundle@servletRequest" shortDescBinding="ADD_LBL@configBundle@servletRequest" 
                             name="event" value="addRacInst"/>
                </uix:rowLayout>
               
                <uix:rowLayout>
                   <oem:table name="RacInstDS" beanKey="defaultBean" dataSourceProp="clickableComponentDS" 
                            summaryBinding="INSTANCES@configBundle@servletRequest"
                            alternateTextBinding="NO_ITEM_FOUND@configBundle@servletRequest"
                            blockSizeBinding="rowCount@componentDS@defaultBean@servletRequest"
                            formSubmitted="true"
                            width="100%">
                            <uix:tableSelection>
                             <uix:singleSelection selectedIndexBinding="selectedIndexForUI@defaultBean@servletRequest">
                                        <uix:submitButton textBinding="EDIT_LBL@configBundle@servletRequest" shortDescBinding="EDIT_LBL@configBundle@servletRequest" disabledBinding="isEditDisabled@defaultBean@servletRequest"
                                                 name="event" value="editRacInst"/>
                                        <uix:submitButton textBinding="DELETE_LBL@configBundle@servletRequest" shortDescBinding="DELETE_LBL@configBundle@servletRequest" disabledBinding="isEditDisabled@defaultBean@servletRequest" 
                                                 name="event" value="deleteRacInst"/>
                                        <uix:submitButton textBinding="REMOVE_ALL@RacDBConfigMsg" shortDescBinding="REMOVE_ALL@RacDBConfigMsg" disabledBinding="isEditDisabled@defaultBean@servletRequest" 
                                                 name="event" value="deleteAllRacInst"/>
                                         <uix:submitButton textBinding="AUTO_ADD_INST@RacDBConfigMsg" shortDescBinding="AUTO_ADD_INST@RacDBConfigMsg" disabledBinding="isEditDisabled@defaultBean@servletRequest" 
                                                 name="event" value="syncRacInsts"/>           
                                        <uix:submitButton textBinding="TEST_CONN@configBundle@servletRequest" shortDescBinding="TEST_CONN@configBundle@servletRequest" disabledBinding="isEditDisabled@defaultBean@servletRequest"
                                                 name="event" value="tstCnnRacInst"/>
                             </uix:singleSelection>        
                            </uix:tableSelection> 
                  </oem:table>
                </uix:rowLayout>
                </uix:tableLayout>
            </uix:header>
            </uix:rowLayout>
            </uix:tableLayout>
            </uix:case>
            </uix:switcher>
                                                                                                                                                                                                                                                                                                                                                                                  
            
          </uix:contents>
        </uix:stackLayout>
      

       <uix:pageButtons> 
         <uix:pageButtonBar>         
         <uix:submitButton textBinding="CANCEL@configBundle@servletRequest" shortDescBinding="CANCEL@configBundle@servletRequest" name="event" value="cancel" />
         <uix:spacer width="10"/>
         <uix:navigationBar
                  name="step"
                  minValue="1"
                  maxValue="5"
                  value="1"  
                  formSubmitted="true"
                  formName="propForm"/>       
         </uix:pageButtonBar>  
       </uix:pageButtons>
     </uix:pageLayout>    
     
    <uix:formParameter name="selectedRacInstanceIndex"/>
    </db:form>  
  </uix:body> 
</uix:document> 

</uix:renderingContext>	     	     

