
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBConfigMsg"
	      class="oracle.sysman.db.rsc.conf.DBConfigMsg"/>
 <uix:bundle name="RacDBConfigMsg"
	      class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>	      
  <oem:setURLEncoder id="renderingContext"/>
<uix:document>   
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>
  <uix:body>      
      <uix:form name="propForm" method="post" destination="config"> 
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/> 
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>    
        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>    
        <uix:spacer height="10"/> 
        <uix:train selectedIndex="0">
          <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
            <uix:link textBinding="." disabled="true"/>
          </uix:contents>
        </uix:train>              
                                           
        <uix:header textBinding="propsHeader@defaultBean@servletRequest" />    
        <uix:stackLayout>
          <uix:contents>          
            <uix:tableLayout cellSpacing="5">
              <uix:contents>     

              <uix:switcher childNameBinding="isEdit@defaultBean@pageContext">
                <uix:case name="0">
                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt required="yes" promptBinding="NAME@configBundle@servletRequest" labeledNodeId="targetName"/> 
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:stackLayout>
                        <uix:contents>       
                          <uix:textInput name="targetName" textBinding="targetName@defaultBean@pageContext" id="targetName"/>
                          <uix:messageText messageType="error" messageBinding="Name@errors@servletRequest"/> 
                        </uix:contents>                 
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                </uix:case>

                <uix:case name="1">
                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt required="yes" promptBinding="NAME@configBundle@servletRequest"/> 
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:stackLayout>
                        <uix:contents>       
                          <uix:styledText styleClass="OraDataText" textBinding="targetName@defaultBean@pageContext" />
                        </uix:contents>                 
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                </uix:case>
              </uix:switcher>

                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:messagePrompt promptBinding="TYPE@configBundle@servletRequest"/>                                             
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:contents>       
                        <uix:styledText styleClass="OraDataText" textBinding="displayType@defaultBean@pageContext" />                     
                      </uix:contents>                 
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout> 

                <uix:rowLayout> 
                  <uix:contents>
                    <uix:cellFormat wrappingDisabled="true" hAlign="right">
                      <uix:contents>                           
                        <uix:switcher childNameBinding="hostNameReadOnly@defaultBean@servletRequest">
                            <uix:case name="false">
                                <uix:messagePrompt promptBinding="HOST_COL@configBundle@servletRequest" labeledNodeId="hostName"/>
                            </uix:case>
                            <uix:default>
                                <uix:messagePrompt promptBinding="HOST_COL@configBundle@servletRequest"/>
                            </uix:default>
                        </uix:switcher>    
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat wrappingDisabled="true" hAlign="left">
                      <uix:contents>       
                        <oem:choice name="hostName" styleClass="OraDataText" selectedValueBinding="hostName@defaultBean@servletRequest" 
                            optionsBinding="hosts@defaultBean@servletRequest" 
                            onChange="submitForm('propForm', true, {event:'changeRacHost'})"
                            readOnlyBinding="hostNameReadOnly@defaultBean@servletRequest"
	                    id="hostName"/>
                      </uix:contents>                 
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout> 
                                         
              </uix:contents>   
           </uix:tableLayout>         
           
           <uix:tableLayout width="100%">
             <uix:contents>   
               <uix:rowLayout  hAlign="right"> 
                   <uix:contents>            
                   <uix:submitButton textBinding="TEST_CONN@configBundle@servletRequest" shortDescBinding="TEST_CONN@configBundle@servletRequest" name="event" value="testConn" />
                   </uix:contents>
               </uix:rowLayout>   
               <uix:rowLayout>    
                 <uix:spacer height="5"/>             
               </uix:rowLayout> 
               <uix:rowLayout>                       
                 <uix:table  width="100%"
                             summaryBinding="propsHeader@defaultBean@servletRequest"
                             tableDataBinding="propsData@defaultBean@pageContext"
                             columnHeaderDataBinding="propsColHeaderData@defaultBean@pageContext"
                             columnFormatsBinding="propsColFormats@@defaultBean@pageContext"
                             alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest">
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:styledText textBinding="text"/>
                   </uix:columnHeaderStamp>
                   <uix:contents>
                    <uix:dataScope>
                     <uix:messagePrompt requiredBinding="isRequired"/>
                     <uix:switcher childNameBinding="propName" >
		       <uix:case name="PreferredConnectString">
                       <uix:stackLayout>
                       <uix:styledText  
                         textBinding="dispName" />
                         <uix:styledText styleClass="OraTipText" textBinding="PREFERRED_CONN_STR_HINT@DBConfigMsg" />
                       </uix:stackLayout>
                       </uix:case>
                       <uix:default>
                       <uix:styledText  
                         textBinding="dispName" />
                       </uix:default>
                     </uix:switcher>
                    </uix:dataScope>

                    <uix:switcher childNameBinding="propName" >
                    <uix:case name="Role">
                      <uix:choice name="propTab" shortDescBinding="dispName"
                                  selectedValueBinding="propValue" 
                                  onChange="submitForm('propForm', true, {event:'changeRole'})"
                                  readOnlyBinding="isReadOnly"> 
                                 <uix:contents childDataBinding="roleList@defaultBean@servletRequest">
                                    <uix:option textBinding="rtext"
                                                valueBinding="rval"/>
                                 </uix:contents>
                      </uix:choice>      
                    </uix:case>  
		       <uix:case name="PreferredConnectString">
                             <uix:stackLayout>
                               <uix:contents>       
                                 <uix:textInput 
                                   name="propTab"  
                                   textBinding="propValue"  
		                           rows="5"
                                columns="100"
                                   noAutoComplete="true"
                                   readOnlyBinding="isReadOnly"/>
                                 <uix:messageText
                                   messageBinding="(dispName)@errors@servletRequest"
                                   messageType="error"/>
                               </uix:contents>       
                             </uix:stackLayout>
                       </uix:case>
                    <uix:default>
                    <uix:switcher childNameBinding="isSecret">
                      <uix:case name="true">
                        <uix:switcher childNameBinding="propValue">
                          <uix:case name="">
                            <uix:textInput name="propTab"  text=""  secretBinding="isSecret"  readOnlyBinding="isReadOnly"
                                noAutoComplete="true"
                                shortDescBinding="dispName"/>
                          </uix:case>  
                          <uix:default>
                           <uix:textInput name="propTab"  text="******" readOnlyBinding="isReadOnly" 
                                noAutoComplete="true"
                                shortDescBinding="dispName"/>
                          </uix:default>  
                        </uix:switcher>  
                      </uix:case>
                      <uix:default>
                         <uix:textInput name="propTab"  textBinding="propValue" secretBinding="isSecret" readOnlyBinding="isReadOnly"
                            noAutoComplete="true"
                            shortDescBinding="dispName"/>                      
                      </uix:default>   
                    </uix:switcher> 
                    </uix:default>
                    </uix:switcher> 
                   </uix:contents>
                 </uix:table> 
                             
               </uix:rowLayout>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
             </uix:contents>   
           </uix:tableLayout>
            
          </uix:contents>
        </uix:stackLayout>
      
      
       <uix:pageButtons> 
         <uix:pageButtonBar>         
             <uix:submitButton textBinding="CANCEL@configBundle@servletRequest" shortDescBinding="CANCEL@configBundle@servletRequest" name="event" value="cancelRacInst" />
             <uix:switcher childNameBinding="isEdit@defaultBean@pageContext">
              <uix:case name='0'> 
               <uix:submitButton textBinding="APPLY_NEW@RacDBConfigMsg" shortDescBinding="APPLY_NEW@RacDBConfigMsg" name="event" value="applyRacInst" />
              </uix:case >
             </uix:switcher>        
             <uix:submitButton textBinding="OK@configBundle@servletRequest" shortDescBinding="APPLY_NEW@RacDBConfigMsg" name="event" value="finishRacInst" />
         </uix:pageButtonBar>  
       </uix:pageButtons>
     </uix:pageLayout>       
    </uix:form>  
  </uix:body> 
</uix:document> 

</uix:renderingContext>            


