<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- ---------------------------------------------------------------------- --%>
<%-- Progress meter during target discovery                                 --%>
<%-- ---------------------------------------------------------------------- --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer> 
      <uix:head 
        titleBinding="header@defaultBean@pageContext"
        />
    </uix:metaContainer>

    <uix:body>

      <db:form 
        name="savingProgress" 
        method="post" 
        destination="config" 
        >

        <%-------------------------
         -  Header
         ---------------------------%>
        <uix:pageLayout 
          titleBinding="header@defaultBean@pageContext"
          messageType="processing"
          >

          <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
          <uix:formValue name="target" valueBinding="target@servletRequest"/> 
          <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
          <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
          <uix:formValue name="returnUrl" valueBinding="returnUrl@servletRequest"/>

          <%@ include file="/oemGlobal.jspf" %>

          <%-------------------------
           -  Progress description
           ---------------------------%>
          <uix:pageStatus>
            <uix:stackLayout>
              <uix:styledText 
                styleClass="OraInstructionTextStrong" 
                textBinding="SAVING_PROGRESS_DESCRIPTION_SHORT@configBundle@servletRequest"
                />
            </uix:stackLayout>
          </uix:pageStatus>

          <uix:stackLayout>
            <uix:spacer height="5" />

            <%-------------------------
             -  May take several minutes
             ---------------------------%>
            <uix:styledText styleClass="OraInstructionText"
              textBinding="MAY_TAKE_SEVERAL_MIN@configBundle@servletRequest"
              />

            <uix:spacer height="20" /> 

            <%-------------------------
             -  Progress meter
             ---------------------------%>
            <uix:processing 
              timeInterval="<%=processingPageInterval%>">
              <uix:contents>
                <uix:styledText 
                  styleClass="OraProcessingStatusFixed" 
                  textBinding="SAVING_PROGRESS_DESCRIPTION_LONG@configBundle@servletRequest"
                  />
              </uix:contents>
            </uix:processing>

            <uix:spacer width="10"/>

            <%-------------------------
             -  Operation cannot be cancelled
             ---------------------------%>
            <uix:tip>
              <uix:styledText 
                textBinding="OPERATION_CANNOT_BE_CANCELLED@configBundle@servletRequest" 
                styleClass="OraInstructionText"
                />
            </uix:tip>

          </uix:stackLayout>
        </uix:pageLayout> 
      </db:form>  
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

<%-- --------------------------  End of File  ----------------------------- --%>
