<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

 <uix:styleSheet/>
  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/> 
  <script>
    function lovSelect(lovField)
    {
      var proxy = new TableProxy('tablespaceUI');
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement = proxy.getFormElement('Tablespace', selectedIndex);
        lovField.value =  selectedElement.value;       
      }
       window.close();
    }
  </script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="SELECT_TBSP@configBundle@servletRequest"/>
</uix:metaContainer>

<uix:body>
<%-- HTML Form --%>
<db:form 
  copyParams="target,type,cancelURL"
  name="selectTablespaceForm" method="post" destination="config">
<uix:formValue name="pageName" valueBinding="pageName@servletRequest" />
<uix:formValue name="target" valueBinding="target@servletRequest"/> 
<uix:formValue name="mode" valueBinding="mode@servletRequest"/>
<uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>

<uix:pageLayout titleBinding="SELECT_TBSP@configBundle@servletRequest">

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


  <%-- START: TAB CONTENTS starts here --%>
  <uix:stackLayout>
    <uix:contents>      
     <uix:header textBinding="TABLESPACE@configBundle@servletRequest">   
       <oem:table name="tablespaceUI"
             summaryBinding="TABLESPACE@configBundle@servletRequest"
             alternateTextBinding="NO_ITEM_FOUND@configBundle@servletRequest" 
             beanKey="defaultBean"
             formSubmitted="true"
             destination="config" 
             dataSourceProp="tablespaceUI"
             width="100%" >                    

        <uix:tableSelection> 
          <uix:singleSelection selectedIndexBinding="selectedIndex@defaultBean@servletRequest"/>
        </uix:tableSelection>
      </oem:table>
     </uix:header>
    </uix:contents>
  </uix:stackLayout>
    <%-- END: TAB CONTENTS ends here --%>   


  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:button textBinding="CANCEL@configBundle@servletRequest"
                destination="javascript:self.close()"/>
    <uix:button textBinding="SELECT@configBundle@servletRequest" 
                destinationBinding="tablespace@servletRequest" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




