<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:document> 
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>   
  <uix:body> 
    <db:form 
      copyParams="target,type,cancelURL"
      name="summaryForm" destination="config">  
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/> 
      <uix:formValue name="target" valueBinding="target@servletRequest"/>   
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <uix:spacer height="10"/>  
        <uix:train selectedIndex="4">
          <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
            <uix:link textBinding="."/>
          </uix:contents>
        </uix:train>
            
        <uix:stackLayout>

          <uix:header textBinding="summaryHeader@defaultBean@servletRequest">

            <%---------------------------------------------
             - Review Instruction Text
             ----------------------------------------------%>
            <uix:spacer height="5"/>
            <uix:styledText 
              styleClass="OraInstructionText" 
              textBinding="reviewLabel@defaultBean@pageContext" />
            <uix:spacer height="10"/>

            <%---------------------------------------------
             - Target Name
             ----------------------------------------------%>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat 
                  wrappingDisabled="true" hAlign="right">
                  <uix:messagePrompt 
                    promptBinding="NAME@configBundle@servletRequest"/>
                </uix:cellFormat>

                <uix:cellFormat 
                  wrappingDisabled="true" hAlign="left">
                  <uix:stackLayout>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="targetName@defaultBean@pageContext" />
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <%---------------------------------------------
             - Properties Table Section
             ----------------------------------------------%>
            <uix:header 
              textBinding="PROPERTIES@configBundle@servletRequest">
              <uix:spacer height="5"/>
              <uix:tableLayout width="80%">

              <%---------------------------------------------
               - Properties Table
               ----------------------------------------------%>
              <uix:rowLayout>    
                <uix:cellFormat>  
                  <uix:spacer width="10"/>
                </uix:cellFormat>                   

                <uix:table  width="100%"
                  summaryBinding="PROPERTIES@configBundle@servletRequest"
                  tableDataBinding="propsData@defaultBean@pageContext"
                  columnHeaderDataBinding="propsColHeaderData@defaultBean@pageContext"
                  columnFormatsBinding="propsColFormats@@defaultBean@pageContext"
                  alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:columnHeaderStamp>
                    <uix:styledText textBinding="text"/>
                  </uix:columnHeaderStamp>
                  <uix:styledText  textBinding="dispName" />
                  <uix:switcher childNameBinding="isSecret">
                    <uix:case name="true">
                      <uix:textInput name="propTab"  text="******" readOnly="true"/>
                    </uix:case>
                    <uix:default>
                      <uix:textInput name="propTab"  
                        textBinding="propValue" 
                        secretBinding="isSecret" readOnly="true"/>                      
                    </uix:default>   
                   </uix:switcher> 
                 </uix:table> 
               </uix:rowLayout>      

               <%---------------------------------------------
                - Spacing for Add Mode Tip
                ----------------------------------------------%>
               <uix:switcher childNameBinding="mode@servletRequest">
                 <uix:case name="add"> 
                   <uix:rowLayout>
                     <uix:cellFormat>  
                       <uix:spacer width="10"/>
                     </uix:cellFormat>                   
                     <uix:spacer height="5"/>
                   </uix:rowLayout>
                 </uix:case>
               </uix:switcher>   	        

               <%---------------------------------------------
                - Tip for Add Mode
                ----------------------------------------------%>
               <uix:switcher childNameBinding="mode@servletRequest">
                 <uix:case name="add"> 
                   <uix:rowLayout>
                     <uix:cellFormat>  
                       <uix:spacer width="10"/>
                     </uix:cellFormat>                   
                     <uix:tip
                       textBinding="CONFIGURE_DB_TIP@configBundle@servletRequest" 
                       />
                   </uix:rowLayout>
                 </uix:case>
               </uix:switcher>   	        

             </uix:tableLayout>               
            </uix:header>               
           
            <%---------------------------------------------
             - RACDB Components
             ----------------------------------------------%>
            <uix:switcher childNameBinding="dbType@defaultBean@servletRequest">
              <uix:case name="racdb">
                <uix:header textBinding="INSTANCES@configBundle@servletRequest">
                  <uix:spacer height="5"/>
                  <uix:tableLayout width="80%">
                    <uix:rowLayout hAlign="right">
                      <uix:cellFormat>
                        <uix:spacer width="10"/>
                      </uix:cellFormat>

                      <oem:table 
                        name="RacInstDS" 
                        beanKey="defaultBean" 
                        summaryBinding="INSTANCES@configBundle@servletRequest"
                        dataSourceProp="unclickableComponentDS"
                        alternateTextBinding="NO_ITEM_FOUND@configBundle@servletRequest"
                        blockSizeBinding="rowCount@componentDS@defaultBean@servletRequest"
                        formSubmitted="true"
                        width="100%"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>
              </uix:case>
            </uix:switcher>

            <%---------------------------------------------
             - Install Packages
             ----------------------------------------------%>
            <uix:switcher  childNameBinding="installPkgs@defaultBean@servletRequest">
              <%---------------------------------------------
               - CASE: Install
               ----------------------------------------------%>
              <uix:case name="1">
                     <uix:header textBinding="PACKAGES@configBundle@servletRequest">
                       <uix:tableLayout cellSpacing="5" width="100%">
                         <uix:rowLayout>
                           <uix:cellFormat>
                             <uix:spacer width="10"/>
                           </uix:cellFormat>
                           <uix:cellFormat wrappingDisabled="true" hAlign="left">
                             <uix:stackLayout>
                               <uix:styledText styleClass="OraInstructionText" textBinding="installPkgsDesc@defaultBean@pageContext" />
                              </uix:stackLayout>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                             <uix:spacer width="10"/>
                            </uix:cellFormat>
                            <%@ include file="metrics.jspf" %>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:header>
                    </uix:case>

              <%---------------------------------------------
               - CASE: Uninstall
               ----------------------------------------------%>
              <uix:case name="2">
                <uix:header textBinding="PACKAGES@configBundle@servletRequest">
                 <uix:tableLayout cellSpacing="5" width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:spacer width="10"/>
                      </uix:cellFormat>
                      <uix:cellFormat wrappingDisabled="true" hAlign="left">
                        <uix:stackLayout>
                          <uix:styledText 
                            styleClass="OraInstructionText" 
                            textBinding="UNINSTALL@configBundle@servletRequest" />
                        </uix:stackLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:spacer width="10"/>
                      </uix:cellFormat>
                      <%@ include file="metrics.jspf" %>
                    </uix:rowLayout>
                 </uix:tableLayout>
                </uix:header>
              </uix:case>
            </uix:switcher> <%-- switcher for installPkgs --%>

            <%---------------------------------------------
             - Parameters
             ----------------------------------------------%>
            <uix:switcher childNameBinding="installStatsPack@defaultBean@pageContext">
          	  <uix:case name="1">            
                <uix:header textBinding="PARAMETERS@configBundle@servletRequest"> 

                  <%---------------------------------------------
                   - Changed Parameters
                   ----------------------------------------------%>
                  <uix:switcher childNameBinding="paramsChange@defaultBean@pageContext">
                    <uix:case name="true">
                      <uix:tableLayout  width="80%">
                        <uix:rowLayout>
                         <uix:cellFormat>
                                 <uix:spacer width="10"/>
                         </uix:cellFormat>
                         <uix:table  width="100%"
                           summaryBinding="PARAMETERS@configBundle@servletRequest"
                           tableDataBinding="paramChangeList@defaultBean@pageContext"
                           columnFormatsBinding="paramChangeListColFormats@@defaultBean@pageContext"
                           columnHeaderDataBinding="paramChangeListColHeaderData@defaultBean@pageContext"
                           alternateTextBinding = "NO_ITEM_FOUND@configBundle@servletRequest">

                           <uix:columnHeaderStamp>
                             <uix:styledText textBinding="text"/>
                           </uix:columnHeaderStamp>
                           <uix:styledText  textBinding="ctext" />
                           <uix:styledText  textBinding="cval" />
                         </uix:table>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:header>
              </uix:case>
                  </uix:switcher>

                  <%---------------------------------------------
                   - DBSNMP
                   ----------------------------------------------%>

                    <%-- install/reinstall text --%>
                    <uix:switcher 
                          childNameBinding="installPkgs@defaultBean@servletRequest">
                      <uix:case name="0">
                        <uix:header textBinding="DB_MONITOR_USER@configBundle@servletRequest">
                          <uix:spacer width="10"/>
                          <uix:styledText styleClass="OraInstructionText" textBinding="SKIP@configBundle@servletRequest" />
                        </uix:header>
                      </uix:case>
                      <uix:case name="1">
                        <uix:header textBinding="DB_MONITOR_USER@configBundle@servletRequest">
                          <uix:spacer width="10"/>
                          <uix:styledText styleClass="OraInstructionText" textBinding="BASIC_INSTALL@configBundle@servletRequest" />
                        </uix:header>
                      </uix:case>
                    </uix:switcher>

                    <uix:switcher childNameBinding="installDBMUser@defaultBean@servletRequest">
                      <uix:case name="1">
                        <%@ include file="dbsnmp_creds.jspf" %>
                      </uix:case>
                      <uix:case name="0">
                        <%@ include file="dbsnmp_creds.jspf" %>
                      </uix:case>
                    </uix:switcher>  
                    </uix:header>
                    
                        </uix:stackLayout> 
                        
                    
                  <%-- statpack --%> 
                  <uix:switcher childNameBinding="installStatsPack@servletRequest">
                    <uix:case name="1">
                      <uix:header textBinding="STATSPACK_USER@configBundle@servletRequest">      
                        <uix:tableLayout cellSpacing="5">

                          <uix:rowLayout> 
                            <uix:cellFormat>  
                              <uix:spacer width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat wrappingDisabled="true" hAlign="right">
                              <uix:messagePrompt 
                                promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                            </uix:cellFormat>
                            <uix:cellFormat wrappingDisabled="true" hAlign="left">
                              <uix:styledText styleClass="OraDataText" text="PERFSTAT" />                     
                            </uix:cellFormat>
                          </uix:rowLayout>

                          <uix:switcher childNameBinding="installStatsPack@servletRequest">
                            <uix:case name="0"> 
                            <uix:rowLayout>
                              <uix:cellFormat>  
                                <uix:spacer width="10"/>
                              </uix:cellFormat>
                              <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                                <uix:messagePrompt  promptBinding="PASSWORD@configBundle@servletRequest"/>                 
                              </uix:cellFormat>
                              <uix:cellFormat wrappingDisabled="true" hAlign="left">
                                <uix:switcher childNameBinding="spPassword@defaultBean@pageContext">
                                  <uix:case name="">
                                    <uix:styledText styleClass="OraDataText" text=" " />
                                  </uix:case>  
                                  <uix:default>
                                    <uix:styledText styleClass="OraDataText" text="**********" />
                                  </uix:default>  
                                </uix:switcher>                                
                              </uix:cellFormat>
                            </uix:rowLayout>
                            </uix:case>
                          </uix:switcher>               
                        
                          <uix:rowLayout>
                            <uix:cellFormat>  
                              <uix:spacer width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                              <uix:messagePrompt  promptBinding="DEFAULT_TABLESPACE@configBundle@servletRequest"/>                                                          
                            </uix:cellFormat>
                            
                            <uix:cellFormat wrappingDisabled="true" hAlign="left">
                              <uix:stackLayout>
                                <uix:styledText styleClass="OraDataText" textBinding="spDefTbsp@defaultBean@pageContext" />
                              </uix:stackLayout>   
                            </uix:cellFormat>
                          </uix:rowLayout>

                          <uix:rowLayout>
                            <uix:cellFormat>  
                              <uix:spacer width="10"/>
                            </uix:cellFormat>
                            <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                              <uix:messagePrompt  promptBinding="TEMP_TABLESPACE@configBundle@servletRequest"/>                                                          
                            </uix:cellFormat>

                            <uix:cellFormat wrappingDisabled="true" hAlign="left">
                              <uix:stackLayout>
                                <uix:styledText styleClass="OraDataText" textBinding="spTmpTbsp@defaultBean@pageContext" />
                              </uix:stackLayout> 
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:header>
                    </uix:case>
                    <uix:case name="0">
                      <uix:switcher childNameBinding="showSP@defaultBean@servletRequest">
                        <uix:case name="1">
                          <uix:header textBinding="STATSPACK_USER@configBundle@servletRequest">      
                            <uix:stackLayout>        
                              <uix:spacer height="5"/>     
                              <uix:styledText styleClass="OraInstructionText" textBinding="STATSPACK_EXIST@configBundle@servletRequest" />
                              <uix:spacer height="5"/>     
                              <uix:tableLayout cellSpacing="5">
                                <uix:rowLayout> 
                                  <uix:cellFormat>  
                                  <uix:spacer width="10"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat wrappingDisabled="true" hAlign="right">
                                  <uix:messagePrompt promptBinding="USER_NAME@configBundle@servletRequest"/>                                             
                                  </uix:cellFormat>
                                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                                  <uix:styledText styleClass="OraDataText" text="PERFSTAT" />                     
                                  </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:cellFormat>  
                                    <uix:spacer width="10"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat  wrappingDisabled="true" hAlign="right">
                                    <uix:messagePrompt  promptBinding="PASSWORD@configBundle@servletRequest"/>                 
                                  </uix:cellFormat>
                                  <uix:cellFormat wrappingDisabled="true" hAlign="left">
                                    <uix:stackLayout>                                       
                                      <uix:switcher childNameBinding="spPassword@defaultBean@pageContext">
                                        <uix:case name="">
                                          <uix:styledText styleClass="OraDataText" text=" " />
                                        </uix:case>  
                                        <uix:default>
                                          <uix:styledText styleClass="OraDataText" text="**********" />
                                        </uix:default>  
                                      </uix:switcher>  
                                    </uix:stackLayout>   
                                  </uix:cellFormat>
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:stackLayout>                                                           
                          </uix:header>
                        </uix:case>   
                      </uix:switcher>          
                  <%-- End statpak --%>
                </uix:case>   

                  <%@ include file="host_creds.jspf" %>

              <uix:case name="2">            
                <uix:header textBinding="PARAMETERS@configBundle@servletRequest"> 
                  <%@ include file="host_creds.jspf" %>
                </uix:header>
              </uix:case>
            </uix:switcher>  
            
         
      
       <uix:pageButtons> 
         <uix:pageButtonBar>         
           <uix:submitButton 
             textBinding="CANCEL@configBundle@servletRequest" 
             shortDescBinding="CANCEL@configBundle@servletRequest"
             name="event" 
             value="cancel" />

           <uix:spacer width="10"/>
           <uix:navigationBar
             name="step"
             minValue="1"
             maxValue="5"
             value="5"  
             formSubmitted="true"
             formName="summaryForm"/>       

           <uix:spacer width="10"/>
           <uix:submitButton 
             disabledBinding="isEditDisabled@defaultBean@servletRequest"
             textBinding="finishLabel@defaultBean@pageContext" 
             shortDescBinding="finishLabel@defaultBean@pageContext"
             name="event" 
             value="finish" />
         </uix:pageButtonBar>  
       </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>	     	

<%--                             End of File                                --%>
