<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>   

    <%@ include file="/oemTitle.jspf" %>

    <head>
      <script>
          var isNav = ( -1 != navigator.appName.indexOf("Netscape") );
          if ( isNav ) {
             document.captureEvents( Event.KEYPRESS );
          }
          document.onkeypress = getKey;
          function getKey( keyStroke )
          {
             key = (isNav) ? keyStroke.which : event.keyCode;
             if ( "13" == key ) {
               submitForm( 'syncForm', true, {'event':'ok'} );
             }
          }
          function doOnLoad()
          {
              document.syncForm.userName.focus();
              document.syncForm.userName.select();
          }
      </script>
    </head>

    <uix:body onLoad="doOnLoad();">
      <db:form 
        copyParams="target,type,cancelURL"
        name="syncForm" 
        method="post" 
        destination="config"> 

        <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
        <uix:formValue name="target" valueBinding="target@servletRequest"/> 
        <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
        <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>

        <uix:pageLayout>

          <%@ include file="/database/global.jspf" %>    

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>    
          
          <%-------------------------
           -  Train
           ---------------------------%>
          <uix:spacer height="10"/>
          <uix:train selectedIndex="0">
            <uix:contents 
              childDataBinding="trainLinks@defaultBean@servletRequest"
              >
              <uix:link 
                textBinding="."
                disabled="true"
                />
            </uix:contents>
          </uix:train>              
                  
          <%-------------------------
           -  Separator
           ---------------------------%>
          <uix:separator/>

          <%-------------------------
           -  Header
           ---------------------------%>
          <uix:header
            textBinding="syncHeader@defaultBean@servletRequest"
            >

            <%-------------------------
             -  Instruction text
             ---------------------------%>
            <uix:spacer height="5"/>
            <uix:rowLayout> 
              <uix:cellFormat hAlign="left">
                <uix:switcher 
                  childNameBinding="isEdit@defaultBean@pageContext">
                  <uix:case name="0">
                    <uix:styledText 
                      styleClass="OraInstructionText" 
                      textBinding="SYNC_DRILLDOWN_EDIT_INSTR@configSyncBundle@servletRequest" />
                  </uix:case>
                  <uix:case name="1">
                    <uix:styledText 
                      styleClass="OraInstructionText" 
                      textBinding="SYNC_DRILLDOWN_ADD_INSTR@configSyncBundle@servletRequest" />
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
            </uix:rowLayout> 
            <uix:spacer height="20"/>

            <%@ include file="/credentials.jspf" %>

            <%-------------------------
             -  Connection Failure Msg
             ---------------------------%>
            <uix:labeledFieldLayout labelWidth="38%" >
              <uix:contents>
                <uix:styledText text=" "/>
                <uix:messageText
                  messageBinding="(CONNECTION_FAILURE@configSyncBundle@servletRequest)@errors@servletRequest"
                  messageType="error"/>
              </uix:contents>
            </uix:labeledFieldLayout>

            <uix:spacer height="10"/>

            <%-------------------------
             -  DBSNMP Password
             ---------------------------%>
            <uix:labeledFieldLayout labelWidth="38%" >
              <uix:contents>

               <uix:messageTextInput 
                 name="syncDbmPassword" 
                 promptBinding="NEW_DBSNMP_PASSWD@configSyncBundle@servletRequest"
                 textBinding="syncDbmPassword@defaultBean@pageContext" 
                 messageBinding="(NEW_DBSNMP_PASSWD@configSyncBundle@servletRequest)@errors@servletRequest" 
                 noAutoComplete="true"
                 messageTypeBinding="syncDbmPasswordErrorType@defaultBean@servletRequest" 
                 columns="40"
                 secret="true"           
                 required="uiOnly"
                 />

               <uix:messageTextInput 
                 name="confirmDbmPassword" 
                 promptBinding="CONFIRM_DBSNMP_PASSWD@configSyncBundle@servletRequest"
                 textBinding="confirmDbmPassword@defaultBean@pageContext" 
                 messageBinding="(CONFIRM_DBSNMP_PASSWD@configSyncBundle@servletRequest)@errors@servletRequest"
                 messageTypeBinding="confirmDbmPasswordErrorType@defaultBean@servletRequest" 
                 noAutoComplete="true"
                 columns="40"
                 secret="true"           
                 required="uiOnly"
                 />

              </uix:contents>
            </uix:labeledFieldLayout>
                                                                                                                                                                                                                                                                                                                                                                                     
          </uix:header>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton
                name="event"
                value="cancel"
                textBinding="CANCEL@configBundle@servletRequest"/>
              <uix:submitButton
                name="event"
                value="ok"
                textBinding="OK@configBundle@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>    
        <uix:formParameter name="selectedRacInstanceIndex"/>

      </db:form>  
    </uix:body> 
  </uix:document> 

</uix:renderingContext>	     	     

<%------------------------------  End of File  -------------------------------%>
