<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@uixDBObjectBundle@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="confirmForm"
             method="post"
             destination="/console/database/databaseObjectsSearch"
             copyParams="target,type,cancelURL,sname,oname,otype,objectType">
      <uix:formValue name="pageName" value="/database/confirmationWithOptions"/>
      <uix:formValue name="objectType" valueBinding="objectType@servletRequest"/>
      <uix:formValue name="backURL" valueBinding="backURL@servletRequest"/>
      <uix:formValue name="msgText" valueBinding="msgText@msgTable@servletRequest"/>

      <uix:contents>
        <uix:pageLayout titleBinding="DELETE_WITH_OPTIONS@dbMsgs">

          <% if (request.getAttribute("em2goApp") != null) {%>
                <%@ include file="/em2go/em2goGlobal.jspf" %>
          <% } else {%>   
                <%@ include file="/database/globalPopup.jspf" %>
          <%} %>
          
         <% if (request.getAttribute("em2goApp") != null) {%>
         <%@ include file="/em2go/em2goFooter.jspf" %>
         <%}%>  

            <uix:stackLayout>
              <oem:radioButton name="deleteOption"
                               textBinding="DROP_OPTION@tblMsgs"
                               value="<%= TableConst.OPTION_DROP %>" 
                               selectedValueBinding="deleteOption@objectBean@servletRequest"/>
              <uix:rowLayout>
                <uix:spacer width="20"/>
                <uix:styledText textBinding="DROP_OPTION_TIP@tblMsgs"
                                styleClass="OraInlineInfoText"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer width="20"/>
                <uix:checkBox name="deleteCascade" textBinding="DROP_OPTION_CASCADE@tblMsgs" 
                              checkedBinding="deleteCascade@objectBean@servletRequest"/>
              </uix:rowLayout>
            </uix:stackLayout>

            <uix:spacer height="12"/>

            <uix:stackLayout>
              <uix:rowLayout>
                <oem:radioButton name="deleteOption"
                                 textBinding="DELETE_OPTION@tblMsgs"
                                 value="<%= TableConst.OPTION_DELETE %>" 
                                 selectedValueBinding="deleteOption@objectBean@servletRequest"/>
              </uix:rowLayout>
            </uix:stackLayout>

            <uix:spacer height="12"/>

            <uix:stackLayout>
              <oem:radioButton name="deleteOption"
                               textBinding="TRUNCATE_OPTION@tblMsgs"
                               value="<%= TableConst.OPTION_TRUNCATE %>" 
                               selectedValueBinding="deleteOption@objectBean@servletRequest"/>
              <uix:rowLayout>
                <uix:spacer width="20"/>
                <uix:styledText textBinding="TRUNCATE_OPTION_TIP@tblMsgs"
                                styleClass="OraInlineInfoText"/>
              </uix:rowLayout>
            </uix:stackLayout>

            <uix:spacer height="20"/>

            <uix:stackLayout>
              <uix:rowLayout>
                <uix:spacer width="20"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="msgText@msgTable@servletRequest"/>
              </uix:rowLayout>
            </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                                name="event" 
                                value="showSql"/>
              <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                           destinationBinding="backURL@servletRequest"/>
              <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="YES@uixDBObjectBundle@servletRequest"
                                name="event" 
                                value="doDelete"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
            
      </uix:contents>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
