<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="customizeDestAsmPageTitle@convertBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="convertForm" destinationBinding="formDestination@convertBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/convert/convert_AdvDestOptions"/>
        
        <uix:pageLayout titleBinding="CUSTOMIZE_DESTINATION_OPTION_HEADER_ASM@convertBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@convertBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@convertBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/convert/errors.jspf" %>

          <uix:pageStatus>
            <uix:labeledFieldLayout columns="2" labelWidth="20%">
              <uix:messagePrompt
                promptBinding="DATABASE@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="targetDbName@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="asmInstance@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="LOGGED_IN_AS@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="srcDBUsrname@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="HOST_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="hostName@convertBean@servletRequest"/>
            </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:separator/>

          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:styledText 	styleClass="OraInstructionText"
                textBinding="CUSTOMIZE_INSTRUCTION_ASM@convertBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:tableLayout>

          <%--...... Start of included section .............--%>
          <%@ include file="/database/convert/advDestOptions.jspf" %>
          <%--...... End of included section ...............--%>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL_BUTTON_TEXT@convertBundle@servletRequest" 
                name="event" value="cancelCustomizeConvert"/>
              <uix:submitButton textBinding="OK_BUTTON_TEXT@convertBundle@servletRequest" 
                name="event" value="applyCustomizeConvert"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
