<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>
 
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="reviewPageTitle@convertBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
      <db:form name="convertForm" destinationBinding="formDestination@convertBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
       <uix:formValue name="pageName" value="/database/convert/convert_Review"/>
        
        <uix:pageLayout titleBinding="REVIEW_HEADER@convertBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@convertBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@convertBean@servletRequest">
              <uix:link textBinding="."/>
            </uix:contents>
          </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/convert/errors.jspf" %>

          <uix:pageStatus>
            <uix:labeledFieldLayout columns="2" labelWidth="20%">
              <uix:messagePrompt
                promptBinding="DATABASE@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="targetDbName@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="asmInstance@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="LOGGED_IN_AS@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="srcDBUsrname@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="HOST_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="hostName@convertBean@servletRequest"/>
            </uix:labeledFieldLayout>
          </uix:pageStatus>
          
          <uix:separator/>

          <%-- Job name and scheduling --%>
          <uix:labeledFieldLayout labelWidth="40%">
            <uix:messagePrompt promptBinding="JOB_NAME@convertBundle@servletRequest"/>
            <uix:styledText styleClass="OraInstructionTextStrong" 
              textBinding="jobName@convertBean@servletRequest"/>
            <uix:messagePrompt promptBinding="JOB_SCHEDULE@convertBundle@servletRequest"/>
            <uix:styledText styleClass="OraInstructionTextStrong" 
              textBinding="jobSchedule@convertBean@servletRequest"/>
            <uix:messageStyledText promptBinding="EMAIL_NOTIFY@convertBundle@servletRequest"
              styleClass="OraInstructionTextStrong" textBinding="toEmailIds@convertBean@servletRequest"
              renderedBinding="toEmailIdsSet@convertBean@servletRequest"/>
            
            <uix:messageStyledText promptBinding="MIGRATION_TYPE@convertBundle@servletRequest"
              styleClass="OraInstructionTextStrong" textBinding="migrationTypeForReview@convertBean@servletRequest"/>
            <uix:messageStyledText promptBinding="SUSPEND_SWITCH_DATABASE@convertBundle@servletRequest"
              styleClass="OraInstructionTextStrong" textBinding="suspendSwitchForReview@convertBean@servletRequest"
              renderedBinding="showSuspendSwitch@convertBean@servletRequest"/>
          </uix:labeledFieldLayout>

          <%-- Database configuration --%>
          <uix:header textBinding="DATABASE_CONFIGURATION_HEADER@convertBundle@servletRequest">
            <uix:contents>
              <uix:labeledFieldLayout labelWidth="40%">
                <uix:messagePrompt promptBinding="GLOBAL_DB_NAME_PROMPT@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="dbName@convertBean@servletRequest"/>
                <uix:messagePrompt promptBinding="SID_PROMPT@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="oracleSid@convertBean@servletRequest"/>
                <uix:messagePrompt promptBinding="DB_VERSION_PROMPT@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="dbVersion@convertBean@servletRequest"/>
                <uix:messagePrompt promptBinding="ARCHIVING_MODE@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="archiveLogMode@convertBean@servletRequest"/>
                <uix:messagePrompt promptBinding="BLOCK_CHANGE_TRACKING@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="changeTrackingForReview@convertBean@servletRequest"/>
                <uix:messagePrompt promptBinding="FLASHBACK_DATABASE@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="flashbackFlagForReview@convertBean@servletRequest"/>
                <uix:messagePrompt promptBinding="ORACLE_HOME_PROMPT@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="oracleHome@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="SPFILE@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="spfile@convertBean@servletRequest"
                  renderedBinding="spfileUsed@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="INIT_ORA_PATH@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="pfile@convertBean@servletRequest"
                  renderedBinding="pfileUsed@convertBean@servletRequest"/>
              </uix:labeledFieldLayout>
            </uix:contents>	
          </uix:header>
          
          <%-- Migration specification --%>
          <uix:header textBinding="MIGRATION_SPECIFICATION_HEADER@convertBundle@servletRequest">
            <uix:contents>
              <uix:labeledFieldLayout labelWidth="40%">
                <uix:messagePrompt promptBinding="HOST_USERNAME@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionTextStrong" 
                  textBinding="hostUserName@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="TEMP_LOG_LOCATION@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="uniqueSrcSubDir@convertBean@servletRequest"
                  renderedBinding="convertDatabaseFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="PARALLELIZE_FILE_COPY@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="parallelizeFileCopyForReview@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="DATABASE_FILE_LOC@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="diskGroupForDF@convertBean@servletRequest"
                  renderedBinding="convertDatabaseFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="TABLESPACE_STORAGE@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="customizLocsStatus@convertBean@servletRequest"
                  renderedBinding="convertDatabaseFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="REDOLOG_CONTROLFILE_LOCATION@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="multiplexLocsStatus@convertBean@servletRequest"
                  renderedBinding="convertDatabaseFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="convertSpfileLabel@convertBean@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="convertSpfileForReview@convertBean@servletRequest"
                  renderedBinding="convertDatabaseFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="UNIQUE_SPFILE_NAME@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="uniqueSpfileName@convertBean@servletRequest"
                  renderedBinding="showUniqueSpfile@convertBean@servletRequest"/>
                <%--
                <uix:messageStyledText promptBinding="DELETE_DATABASE_FILES@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="deleteDatabaseForReview@convertBean@servletRequest"
                  renderedBinding="convertDatabaseFiles@convertBean@servletRequest"/>
                --%>
                <uix:messageStyledText promptBinding="RECOVERY_AREA_FILE_LOC@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="diskGroupForRF@convertBean@servletRequest"
                  renderedBinding="convertRecoveryAreaFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="RECOVERY_AREA_SIZE@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="recoveryAreaSize@convertBean@servletRequest"
                  renderedBinding="convertRecoveryAreaFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="MIGRATE_RECOVERY_FILES@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="migrateRecoveryFilesForReview@convertBean@servletRequest"
                  renderedBinding="convertRecoveryAreaFiles@convertBean@servletRequest"/>
                <uix:messageStyledText promptBinding="MIGRATE_ARCHIVED_LOGS@convertBundle@servletRequest"
                  styleClass="OraInstructionTextStrong" textBinding="migrateArchivedLogToRecoveryArea@convertBean@servletRequest"
                  renderedBinding="isMigrateRecoveryFilesForReview@convertBean@servletRequest"/>
              </uix:labeledFieldLayout>
              
              <uix:hideShowHeader disclosedBinding="showDatabaseFiles@convertBean@servletRequest"
                formSubmitted="true" id="hideShow"
                textBinding="DETAILS_HEADER@convertBundle@servletRequest">
                <uix:contents>
        
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:header textBinding="DATAFILES_HEADER@convertBundle@servletRequest"
                        renderedBinding="convertDatabaseFiles@convertBean@servletRequest">
                        <uix:contents>
                          <oem:table width="80%"
                            blockSize="10"
                            alternateTextBinding="NO_ITEMS_FOUND@convertBundle@servletRequest"
                            name="reviewDatafileListTableConvert"
			    summaryBinding="DATAFILES_HEADER@convertBundle@servletRequest"
                            beanKey="convertBean"
                            formSubmitted="true"
                            dataSourceProp="reviewDatafileListTableConvert"
                            copyParams="target,type,cancelURL,oname"/>  
                        </uix:contents>
                      </uix:header>
                      <%--
                      <uix:header textBinding="TEMPFILES_HEADER@convertBundle@servletRequest"
                        renderedBinding="convertDatabaseFiles@convertBean@servletRequest">
                        <uix:contents>
                          <oem:table width="80%"
                            blockSize="10"
                            alternateTextBinding="NO_ITEMS_FOUND@convertBundle@servletRequest"
                            name="reviewTempfileListTableConvert"
			    summaryBinding="TEMPFILES_HEADER@convertBundle@servletRequest"
                            beanKey="convertBean"
                            formSubmitted="true"
                            dataSourceProp="reviewTempfileListTableConvert"
                            copyParams="target,type,cancelURL,oname"/>  
                        </uix:contents>
                      </uix:header>
                      --%>
                      <uix:header textBinding="LOGFILES_HEADER@convertBundle@servletRequest"
                        renderedBinding="convertDatabaseFiles@convertBean@servletRequest">
                        <uix:contents>
                          <oem:table width="80%"
                            blockSize="10"
                            alternateTextBinding="NO_ITEMS_FOUND@convertBundle@servletRequest"
                            name="reviewLogfileListTableConvert"
			    summaryBinding="LOGFILES_HEADER@convertBundle@servletRequest"
                            beanKey="convertBean"
                            formSubmitted="true"
                            dataSourceProp="reviewLogfileListTableConvert"
                            copyParams="target,type,cancelURL,oname"/>  
                        </uix:contents>
                      </uix:header>
                      <uix:header textBinding="CONTROLFILES_HEADER@convertBundle@servletRequest"
                        renderedBinding="convertDatabaseFiles@convertBean@servletRequest">
                        <uix:contents>
                          <oem:table width="80%"
                            blockSize="10"
                            alternateTextBinding="NO_ITEMS_FOUND@convertBundle@servletRequest"
                            name="reviewControlfileListTableConvert"
			    summaryBinding="CONTROLFILES_HEADER@convertBundle@servletRequest"
                            beanKey="convertBean"
                            formSubmitted="true"
                            dataSourceProp="reviewControlfileListTableConvert"
                            copyParams="target,type,cancelURL,oname"/>  
                        </uix:contents>
                      </uix:header>
                      <uix:header textBinding="RECOVERY_FILES@convertBundle@servletRequest"
                        renderedBinding="isMigrateRecoveryFilesForReview@convertBean@servletRequest">
                        <uix:contents>
                          <oem:table width="80%" blockSize="10"
                            alternateTextBinding="NO_ITEMS_FOUND@convertBundle@servletRequest"
                            name="reviewRecoveryfileListTable"
			    summaryBinding="RECOVERY_FILES@convertBundle@servletRequest"
                            beanKey="convertBean"
                            formSubmitted="true"
                            dataSourceProp="reviewRecoveryfileListTable"
                            copyParams="target,type,cancelURL,oname"/>
                        </uix:contents>
                      </uix:header>
                    </uix:contents>
                  </uix:stackLayout>
    
                </uix:contents>
              </uix:hideShowHeader>

            </uix:contents>	
          </uix:header>

          <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@convertBundle@servletRequest" 
                destinationBinding="cancelURL@convertBean@servletRequest"/>
              <uix:navigationBar name="convertNavBar"
                blockSize="-1"
                formSubmitted="true"
                maxValueBinding="maxNavValue@convertBean@servletRequest"
                minValue="1"
                valueBinding="navValue@convertBean@servletRequest"/>
              <uix:submitButton name ="event" 
                value="submitJob"
                textBinding="SUBMIT_BUTTON_TEXT@convertBundle@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
