<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="schedulePageTitle@convertBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
       
      <db:form name="convertForm" destinationBinding="formDestination@convertBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/convert/convert_Schedule"/>
        
        <uix:pageLayout titleBinding="SCHEDULE_HEADER@convertBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train --%>
          <uix:location>
            <uix:train selectedIndexBinding="trainIndex@convertBean@servletRequest">
              <uix:contents childDataBinding="trainLegend@convertBean@servletRequest">
                <uix:link textBinding="."/>
              </uix:contents>
            </uix:train>
          </uix:location>

          <%-- Error message --%>
          <%@ include file="/database/convert/errors.jspf" %>

          <%-- context info --%>
          <uix:pageStatus>
            <uix:labeledFieldLayout columns="2" labelWidth="20%">
              <uix:messagePrompt
                promptBinding="DATABASE@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="targetDbName@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="asmInstance@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="LOGGED_IN_AS@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="srcDBUsrname@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="HOST_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="hostName@convertBean@servletRequest"/>
            </uix:labeledFieldLayout>
          </uix:pageStatus>
          <%-- end context info --%>

          <uix:separator/>

          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:styledText 	styleClass="OraInstructionText"
                textBinding="SCHEDULE_INSTRUCTION@convertBundle@servletRequest"/>
              </uix:rowLayout>
          </uix:tableLayout>

          <%--.................. job ...................--%>	
          <uix:header textBinding="JOB_HEADER@convertBundle@servletRequest">
            <uix:contents>

              <uix:labeledFieldLayout labelWidth="15%">
                <uix:contents>
                  <uix:messageTextInput id="jobName"
                    name="jobName"
                    promptBinding="JOB_NAME_PROMPT@convertBundle@servletRequest"
                    textBinding="jobName@convertBean@servletRequest"
                    columns="60" 
                    messageBinding="(JOB_NAME_PROMPT@convertBundle@servletRequest)@messages@servletRequest"
                    messageTypeBinding="(JOB_NAME_PROMPT@convertBundle@servletRequest)@messageTypes@servletRequest"
                    required="uiOnly"/>
                  <uix:messagePrompt labeledNodeId="jobDescription" promptBinding="DESCRIPTION_PROMPT@convertBundle@servletRequest"/>
                  <uix:textInput id="jobDescription" name="jobDescription"
                    textBinding="jobDescription@convertBean@servletRequest"
                    columns="60" />
                </uix:contents>
              </uix:labeledFieldLayout>

            </uix:contents>
          </uix:header>
             
          <%--...................... schedule .......................--%>
          <%@ include file="/sdk/schedule/start.jspf"%>

          <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@convertBundle@servletRequest" 
                destinationBinding="cancelURL@convertBean@servletRequest"/>
              <uix:navigationBar 
                name="convertNavBar"
                blockSize="-1"
                formSubmitted="true"
                formName="convertForm"
                maxValueBinding="maxNavValue@convertBean@servletRequest"
                minValue="1"
                valueBinding="navValue@convertBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
