<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

  <uix:metaContainer> 
    <uix:head titleBinding="sourceOptionsPageTitle@convertBean@servletRequest"/>
  </uix:metaContainer>

    <uix:body>
      <uix:contents>

      <db:form name="convertForm" destinationBinding="formDestination@convertBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/convert/convert_SourceOptions"/>

        <uix:pageLayout titleBinding="SOURCE_OPTIONS_HEADER@convertBundle@servletRequest" >
          <%@ include file="/database/global.jspf" %>

            <%-- Wizard train --%>
            <uix:location>
              <uix:train selectedIndexBinding="trainIndex@convertBean@servletRequest">
                <uix:contents childDataBinding="trainLegend@convertBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <%-- Error message --%>
            <%@ include file="/database/convert/errors.jspf" %>

            <%-- context info --%>
          <uix:pageStatus>
            <uix:labeledFieldLayout columns="2" labelWidth="20%">
              <uix:messagePrompt
                promptBinding="DATABASE@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="targetDbName@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="asmInstance@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="LOGGED_IN_AS@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="srcDBUsrname@convertBean@servletRequest"/>
              <uix:messagePrompt
                promptBinding="HOST_PROMPT@convertBundle@servletRequest"/>
              <uix:styledText styleClass="OraDataText"
                textBinding="hostName@convertBean@servletRequest"/>
            </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:separator/>
          <%-- 
          <uix:switcher childNameBinding="isASMTargetExist@convertBean@servletRequest">
            <uix:case name="true">
              <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:borderLayout>
                        <uix:right>
                          <uix:contentContainer textBinding="OVERVIEW_TITLE@convertBundle@servletRequest" width="400">
                            <uix:contents>
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P1@convertBundle@servletRequest"/>
                                  <uix:spacer height="10"/>
                                  <uix:formattedText styleClass="OraInstructionText"
                                    textBinding="overviewP2ForUI@convertBean@servletRequest"/>
                                  <uix:spacer height="10"/>
                                  <uix:link textBinding="OVERVIEW_P2_0@convertBundle@servletRequest"
                                    destination="javascript:(new Function('a', 'b', 'c', 'd', 'openWindow(a, b, c, d)'))(top, '/em/console/help/?topic=oemdba_consens_database_maintenance_page','helpWindow', {width:650, height:450, menubar:0, location:0, status:0, directories:0});"/>
                                  <uix:spacer height="10"/>
                                  <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P3@convertBundle@servletRequest"/>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:contentContainer>
                        </uix:right>
                        <uix:contents>
                          <uix:stackLayout>
                            <uix:contents>
                              <%@ include file="/database/convert/sourceOptions.jspf" %>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:borderLayout>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="false">
              <uix:stackLayout>
                <uix:contents>
                  <%@ include file="/database/convert/sourceOptions.jspf" %>
                </uix:contents>
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>
          --%>
             
          <uix:stackLayout>
            <uix:contents>
              <%@ include file="/database/convert/sourceOptions.jspf" %>
            </uix:contents>
          </uix:stackLayout>
          
          <%--.......... Navigation Bar ..........--%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL_BUTTON_TEXT@convertBundle@servletRequest" 
                destinationBinding="cancelURL@convertBean@servletRequest"/>
              <uix:navigationBar name="convertNavBar"
                blockSize="-1"
                formSubmitted="true"
                formName="convertForm"
                maxValueBinding="maxNavValue@convertBean@servletRequest"
                minValue="1"
                valueBinding="navValue@convertBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
             
        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
