<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="asmConfMsgs" class="oracle.sysman.db.rsc.config.ASMConfigMsg"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="startingPageTitle@convertBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="convertForm" destinationBinding="formDestination@convertBean@servletRequest" method="post" copyParams="target,type,cancelURL,oname">
          <uix:formValue name="pageName" value="/database/convert/convert_StartingPage"/>

          <uix:pageLayout titleBinding="STARTING_PAGE_HEADER@convertBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Error message --%>
            <%@ include file="/database/convert/errors.jspf" %>
            
            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2" labelWidth="20%">
                <uix:messagePrompt
                  promptBinding="DATABASE@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraDataText"
                  textBinding="targetDbName@convertBean@servletRequest"/>
                <uix:messagePrompt
                  promptBinding="HOST_PROMPT@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraDataText"
                  textBinding="hostName@convertBean@servletRequest"/>
                <uix:messagePrompt
                  promptBinding="LOGGED_IN_AS@convertBundle@servletRequest"/>
                <uix:styledText styleClass="OraDataText"
                  textBinding="srcDBUsrname@convertBean@servletRequest"/>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                textBinding="startingPageInstruction@convertBean@servletRequest"/>
            </uix:contents>
            <uix:spacer height="10" width="10"/>
            <uix:link renderedBinding="isASMTgtNotEstInstEst@convertBean@servletRequest" textBinding="CREATE_ASM@asmConfMsgs" shortDescBinding="CREATE_ASM@asmConfMsgs" destinationBinding="createAsmURL@servletRequest"/>
            <uix:tableLayout width="100%">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:borderLayout>
                      <%-- Right side of borderLayout --%>
                      <uix:right>
                        <uix:contentContainer textBinding="OVERVIEW_TITLE@convertBundle@servletRequest" width="500">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P1@convertBundle@servletRequest"/>
                                  <uix:spacer height="10"/>
                                  <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P1_1@convertBundle@servletRequest"/>
                                  <uix:spacer height="10"/>
                                  <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P1_2@convertBundle@servletRequest"/>
                                  <uix:spacer height="5"/>
                                  <uix:styledList listStyle="circle">
                                  <uix:styledItem>
                                    <uix:contents>
                                     <uix:formattedText styleClass="OraInstructionText"
                                        textBinding="OVERVIEW_P1_3@convertBundle@servletRequest"/>
                                     </uix:contents>
                                     </uix:styledItem>
                                     <uix:separator>
                                        <uix:spacer height="5"/>
                                     </uix:separator>
                                     <uix:styledItem>
                                     <uix:contents>
                                     <uix:formattedText styleClass="OraInstructionText"
                                        textBinding="OVERVIEW_P1_4@convertBundle@servletRequest"/>
                                     </uix:contents>
                                     </uix:styledItem>
                                  </uix:styledList>
                                  <uix:spacer height="10"/>
                                  <uix:formattedText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P1_5@convertBundle@servletRequest"/>
                                  <uix:spacer height="10"/>
                                  <uix:formattedText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P1_6@convertBundle@servletRequest"/>
                                  <uix:spacer height="10"/>
                                  <uix:link textBinding="OVERVIEW_P2_0@convertBundle@servletRequest"
                                    destinationBinding="overviewP2Destination@convertBean@servletRequest"/>
                                <%--
                                  <uix:spacer height="10"/>
                                  <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_P3@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_SOURCE@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_SOURCE1@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_SOURCE2@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_SOURCE3@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_OPERATION@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_OPERATION1@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_OPERATION2@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_OPERATION3@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_OPERATION4@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraInstructionText"
                                  textBinding="OVERVIEW_OPERATION5@convertBundle@servletRequest"/>
                                --%>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:contentContainer>
                      </uix:right>
                      <%-- Contents of borderLayout --%>
                      <uix:contents>
                        <uix:stackLayout>
                          <uix:contents>
                            <%@ include file="/database/convert/startingPage.jspf" %>
                            <%--........... Host Credential Fields ...........--%>
                            <%--
                            <uix:header textBinding="SOURCE_HOST_CREDENTIAL_HEADER@convertBundle@servletRequest"
                              renderedBinding="isASMInstanceNotExist@convertBean@servletRequest">
                            --%>
                            <uix:header textBinding="SOURCE_HOST_CREDENTIAL_HEADER@convertBundle@servletRequest">
                              <uix:contents>
                                <uix:tableLayout width="100%">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:styledText styleClass="OraInstructionText"
                                        textBinding="SOURCE_HOST_CREDENTIAL_INSTRUCTION@convertBundle@servletRequest"/>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                                <%@ include file="/credentials.jspf" %>
                              </uix:contents>
                            </uix:header>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:borderLayout>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL_BUTTON_TEXT@convertBundle@servletRequest" 
                  destinationBinding="cancelURL@convertBean@servletRequest"/>
                <uix:submitButton name ="event" formName="convertForm" 
                  textBinding="CONTINUE_BUTTON@convertBundle@servletRequest"
                  value="continueEvent"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
            
        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
