<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="optionsPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="exportForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/exportAdvanced"/>

          <uix:pageLayout titleBinding="optionsPageHeader@exportBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@exportBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="ADVANCED@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>
                  <%-- <uix:header textBinding="GENERAL@exportBundle@servletRequest" size="1"> --%>
                    <uix:stackLayout>
                      <uix:contents>

                        <uix:labeledFieldLayout labelWidth="20%"> 
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="STATISTICS_TYPE@exportBundle@servletRequest"/>
                            <oem:radioButton
                                          name="statisticsType"
                                          selectedValueBinding="statisticsType@exportBean@servletRequest"
                                          textBinding="STATISTICS_TYPE_NONE@exportBundle@servletRequest"
                                          value="NONE"/>
                            <uix:styledText styleClass="OraInstructionText" text=""/>
                            <uix:stackLayout>
                              <uix:contents>
                                <oem:radioButton
                                              name="statisticsType"
                                              selectedValueBinding="statisticsType@exportBean@servletRequest"
                                              textBinding="STATISTICS_TYPE_ESTIMATE@exportBundle@servletRequest"
                                              value="ESTIMATE"/>
                                <oem:radioButton
                                              name="statisticsType"
                                              selectedValueBinding="statisticsType@exportBean@servletRequest"
                                              textBinding="STATISTICS_TYPE_COMPUTE@exportBundle@servletRequest"
                                              value="COMPUTE"/>

                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:labeledFieldLayout>  

                        <uix:checkBox textBinding="DIRECT_PATH@exportBundle@servletRequest" name="direct" checkedBinding="direct@exportBean@servletRequest"/>
                        <uix:messageText messageType="error" messageBinding="Query@errors@servletRequest"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="DIRECT_PATH_IMPROVES@exportBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>

                        <uix:checkBox textBinding="FAIL_JOBS_ON_ERRORS@exportBundle@servletRequest" name="SMPIgnore" checkedBinding="SMPIgnore@exportBean@servletRequest"/>

                      </uix:contents>
                    </uix:stackLayout>

                    <uix:header textBinding="OPTIONAL_FILES@exportBundle@servletRequest" size="1">
                      <uix:tableLayout cellSpacing="5">
                        <uix:contents>
                          <uix:stackLayout>
                            <uix:rowLayout>
                              <uix:cellFormat>
                                <uix:checkBox name="generateLogFile" checkedBinding="generateLogFile@exportBean@servletRequest" textBinding="GENERATE_LOG_FILE@exportBundle@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/> 
                                <uix:stackLayout>
                                  <uix:labeledFieldLayout labelWidth="20%">
                                    <uix:contents>
                                      <uix:messageLovField
                                          id="logFileName"
                                          name="logFileName"
                                          promptBinding="LOG_FILE_COLON@exportBundle@servletRequest"
                                          textBinding="logFileName@exportBean@servletRequest"
                                          columns="60"
                                          searchDescBinding="CLICK_TO_SELECT_LOG_FILE@exportBundle@servletRequest"
                                          onClick="startFileBrowser('logFileName')"/>
                                    </uix:contents>
                                  </uix:labeledFieldLayout>
                                  <uix:messageText messageType="error" messageBinding="LogFile@errors@servletRequest"/>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:tableLayout>
                    </uix:header>

                    <uix:hideShow disclosedBinding="showAdvancedOptions@exportBean@servletRequest"
                                formSubmitted="true" id="hideShow"
                                disclosedTextBinding="HIDE_ADVANCED_OPTIONS@exportBundle@servletRequest"
                                undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@exportBundle@servletRequest">
                      <uix:contents>
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:header textBinding="ASSOCIATED_OBJECTS@exportBundle@servletRequest" size="1">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText" textBinding="ASSOCIATED_OBJECT_TYPES@exportBundle@servletRequest"/>
                                  <uix:checkBox textBinding="ASSOCIATED_OBJECTS_GRANTS@exportBundle@servletRequest" name="grants" checkedBinding="grants@exportBean@servletRequest"/>
                                  <uix:checkBox textBinding="ASSOCIATED_OBJECTS_INDEXES@exportBundle@servletRequest" name="indexes" checkedBinding="indexes@exportBean@servletRequest"/>
                                  <uix:checkBox textBinding="ASSOCIATED_OBJECTS_ROWS@exportBundle@servletRequest" name="rows" checkedBinding="rows@exportBean@servletRequest"/>
                                  <uix:checkBox textBinding="ASSOCIATED_OBJECTS_CONSTRAINTS@exportBundle@servletRequest" name="constraints" checkedBinding="constraints@exportBean@servletRequest"/>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:header>

                            <uix:header textBinding="TUNING@exportBundle@servletRequest" size="1">
                              <uix:stackLayout>
                                <uix:contents>
                          
                                  <uix:checkBox textBinding="EXPORT_READ_CONSISTENT_VIEW@exportBundle@servletRequest" name="readConsistent" checkedBinding="readConsistent@exportBean@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="9.0.1">
                                        <uix:case name="true">
                                          <uix:spacer width="20"/>
                                        </uix:case>
                                      </db:switcher>
                                      <uix:stackLayout>
                                        <uix:contents>
                                          <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="9.2">
                                            <uix:case name="true">
                                              <uix:stackLayout>
                                                <uix:contents>
                                                  <oem:radioButton
                                                        name="exportConsistentType"
                                                        selectedValueBinding="exportConsistentType@exportBean@servletRequest"
                                                        textBinding="ONE_READ_ONLY_TRANS@exportBundle@servletRequest"
                                                        value="CONSISTENT"/>
                                                  <oem:radioButton
                                                        name="exportConsistentType"
                                                        selectedValueBinding="exportConsistentType@exportBean@servletRequest"
                                                        textBinding="OBJECT_READ_ONLY_TRANS@exportBundle@servletRequest"
                                                        value="OBJECT_CONSISTENT"/>
                                                </uix:contents> 
                                              </uix:stackLayout>
                                    
                                            </uix:case>
                                          </db:switcher>
                                
                                          <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="9.0.1">
                                
                                            <uix:case name="true">
                                            <!-- 9.0.1 and 9.2 Database Database -->
                                              <uix:stackLayout>
                                                <uix:contents>       
                                                  <oem:radioButton
                                                              name="exportConsistentType"
                                                              selectedValueBinding="exportConsistentType@exportBean@servletRequest"
                                                              textBinding="AS_SPECIFIED_SCN@exportBundle@servletRequest"
                                                              value="FLASHBACK_SCN"/>
                                                  <uix:labeledFieldLayout labelWidth="30%"> 
                                                    <uix:contents>
                                                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="flashbackScn" 
                                                          textBinding="SYSTEM_CHANGE_NUMBER@exportBundle@servletRequest"/>
                                                      <uix:stackLayout>
                                                        <uix:textInput name="flashbackScn"  id="flashbackScn" 
                                                            textBinding="flashbackScn@exportBean@servletRequest" columns="60"/>
                                                        <uix:messageText messageType="error" messageBinding="FlashbackScn@errors@servletRequest"/>
                                                      </uix:stackLayout>
                                                    </uix:contents>
                                                  </uix:labeledFieldLayout>  
                                                  <oem:radioButton
                                                              name="exportConsistentType"
                                                              selectedValueBinding="exportConsistentType@exportBean@servletRequest"
                                                              textBinding="AS_SCN_MATCHING_TIME@exportBundle@servletRequest"
                                                              value="FLASHBACK_TIME"/>
                                                  <uix:labeledFieldLayout labelWidth="180" fieldWidth="180" columns="1">
                                                    <uix:contents>
                                                      <uix:styledText labeledNodeId="flashbackTimeDate" styleClass="OraInstructionText" textBinding="DATE@exportBundle@servletRequest"/>
                                                      <uix:dateField name="flashbackTimeDate" id="flashbackTimeDate" columns="16" valueBinding="flashbackTimeDate@exportBean@servletRequest">
                                                        <uix:onSubmitValidater>
                                                          <uix:date dateStyle="long"/>
                                                        </uix:onSubmitValidater>
                                                      </uix:dateField>
                                                      <uix:styledText styleClass="OraInstructionText" textBinding="TIME@exportBundle@servletRequest"/>
                                                      <uix:rowLayout>
                                                        <uix:choice
                                                          name="flashbackTimeHour"
                                                          shortDescBinding="timeHour@exportBean@servletRequest"
                                                          selectedValueBinding="flashbackTimeHour@exportBean@servletRequest">
                                                          <uix:option text="01" value="01"/>
                                                          <uix:option text="02" value="02"/>
                                                          <uix:option text="03" value="03"/>
                                                          <uix:option text="04" value="04"/>
                                                          <uix:option text="05" value="05"/>
                                                          <uix:option text="06" value="06"/>
                                                          <uix:option text="07" value="07"/>
                                                          <uix:option text="08" value="08"/>
                                                          <uix:option text="09" value="09"/>
                                                          <uix:option text="10" value="10"/>
                                                          <uix:option text="11" value="11"/>
                                                          <uix:option text="12" value="00"/>
                                                        </uix:choice>
                                                        <uix:choice
                                                          name="flashbackTimeMinute"
                                                          shortDescBinding="timeMinute@exportBean@servletRequest"
                                                          selectedValueBinding="flashbackTimeMinute@exportBean@servletRequest">
                                                          <uix:option text="00" value="00"/>
                                                          <uix:option text="05" value="05"/>
                                                          <uix:option text="10" value="10"/>
                                                          <uix:option text="15" value="15"/>
                                                          <uix:option text="20" value="20"/>
                                                          <uix:option text="25" value="25"/>
                                                          <uix:option text="30" value="30"/>
                                                          <uix:option text="35" value="35"/>
                                                          <uix:option text="40" value="40"/>
                                                          <uix:option text="45" value="45"/>
                                                          <uix:option text="50" value="50"/>
                                                          <uix:option text="55" value="55"/>
                                                        </uix:choice>
                                                        <oem:radioButton
                                                          name="flashbackTimeAmPm"
                                                          selectedValueBinding="flashbackTimeAmPm@exportBean@servletRequest"
                                                          text="AM"
                                                          value="AM"/>
                                                        <oem:radioButton
                                                          name="flashbackTimeAmPm"
                                                          selectedValueBinding="flashbackTimeAmPm@exportBean@servletRequest"
                                                          text="PM"
                                                          value="PM"/>
                                                      </uix:rowLayout>
                                                    </uix:contents>
                                                  </uix:labeledFieldLayout>
                                                </uix:contents>
                                              </uix:stackLayout>
                                            </uix:case>
                                          </db:switcher> 
                                        </uix:contents>
                                      </uix:stackLayout>
                                    </uix:contents>
                                  </uix:rowLayout>

                                  <uix:checkBox textBinding="COMPRESS_MERGE@exportBundle@servletRequest" name="compress" checkedBinding="compress@exportBean@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:spacer width="20"/>
                                      <uix:styledText styleClass="OraInlineInfoText" textBinding="COMPRESS_HINT@exportBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:rowLayout>

                                  <uix:checkBox textBinding="OVERWRITE_DEFAULT_RECORD_LENGTH@exportBundle@servletRequest" name="record" checkedBinding="record@exportBean@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:spacer width="20"/> 
                                      <uix:stackLayout>
                                        <uix:contents>
                                          <uix:rowLayout>
                                            <uix:contents>
                                              <uix:labeledFieldLayout labelWidth="180" fieldWidth="380" columns="1">
                                                <uix:contents>
                                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="recordLength" 
                                                      textBinding="RECORD_LENGTH@exportBundle@servletRequest"/>
                                                  <uix:stackLayout>
                                                    <uix:rowLayout>
                                                      <uix:contents>
                                                        <uix:textInput name="recordLength" id="recordLength" 
                                                            textBinding="recordLength@exportBean@servletRequest" columns="8"/>
                                                      </uix:contents>
                                                    </uix:rowLayout>
                                                    <uix:messageText messageType="error" messageBinding="RecordLength@errors@servletRequest"/>
                                                  </uix:stackLayout>
                                                  <uix:styledText styleClass="OraInstructionText" text=""/>
                                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="RECORD_LENGTH_IS_USED@exportBundle@servletRequest"/>
                                                </uix:contents>
                                              </uix:labeledFieldLayout>
                                            </uix:contents>
                                          </uix:rowLayout>
                                        </uix:contents>
                                      </uix:stackLayout>
                                    </uix:contents>
                                  </uix:rowLayout>

                                  <uix:checkBox textBinding="OVERWRITE_DEFAULT_BUFFER_SIZE@exportBundle@servletRequest" name="buffer" checkedBinding="buffer@exportBean@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:spacer width="20"/> 
                                      <uix:stackLayout>
                                        <uix:contents>
                                          <uix:rowLayout>
                                            <uix:contents>
                                              <uix:labeledFieldLayout labelWidth="180" fieldWidth="380" columns="1">
                                                <uix:contents>
                                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="bufferSize" 
                                                      textBinding="BUFFER_SIZE@exportBundle@servletRequest"/>
                                                  <uix:stackLayout>
                                                    <uix:textInput name="bufferSize" id="bufferSize" 
                                                        textBinding="bufferSize@exportBean@servletRequest" columns="8"/>
                                                    <uix:messageText messageType="error" messageBinding="BufferSize@errors@servletRequest"/>
                                                  </uix:stackLayout>
                                                  <uix:styledText styleClass="OraInstructionText" text=""/>
                                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="BUFFER_SIZE_IS@exportBundle@servletRequest"/>
                                                </uix:contents>
                                              </uix:labeledFieldLayout>
                                            </uix:contents>
                                          </uix:rowLayout>
                                        </uix:contents>
                                      </uix:stackLayout>
                                    </uix:contents>
                                  </uix:rowLayout>

                                </uix:contents>
                              </uix:stackLayout>
                            </uix:header>

                            <uix:switcher childNameBinding="disableQuery@exportBean@servletRequest">
                              <uix:case name="true">
                              </uix:case>
                              <uix:case name="false">
                                <uix:header textBinding="QUERY@exportBundle@servletRequest" size="1">
                                  <uix:stackLayout>
                                    <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText" textBinding="THIS_OPTION_ALLOWS@exportBundle@servletRequest"/>
                                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="query" 
                                          textBinding="SPECIFY_WHERE_CLAUSE@exportBundle@servletRequest"/>
                                      <uix:textInput rows="5" wrap="soft" name="query" id="query" 
                                          textBinding="query@exportBean@servletRequest" columns="80"/>
                                      <uix:messageText messageType="error" messageBinding="Query@errors@servletRequest"/>
                                    </uix:contents>
                                  </uix:stackLayout>
                                </uix:header>
                              </uix:case>
                            </uix:switcher>

                            <uix:header textBinding="OTHER@exportBundle@servletRequest" size="1">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText" textBinding="IF_PARAMETERS@exportBundle@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:spacer width="20"/>
                                      <uix:labeledFieldLayout labelWidth="20%"> 
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="otherParams" 
                                              textBinding="PARAMETERS@exportBundle@servletRequest"/>
                                          <uix:textInput name="otherParams" id="otherParams" 
                                              textBinding="otherParams@exportBean@servletRequest" columns="80"/>
                                          <uix:styledText styleClass="OraInstructionText" text=""/>
                                          <uix:styledText styleClass="OraInlineInfoText" textBinding="OTHER_EXAMPLE@exportBundle@servletRequest"/>
                                        </uix:contents>
                                      </uix:labeledFieldLayout>  
                                    </uix:contents>
                                  </uix:rowLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:header>

                          </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:hideShow>

                  </uix:contents>
                </uix:stackLayout>
              <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" shortDescBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton formName="exportForm" textBinding="FINISH@exportBundle@servletRequest" shortDescBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="exportForm"
                    maxValueBinding="navMaxValue@exportBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@exportBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
