<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:bundle name="lmMsg" class="oracle.sysman.db.rsc.lm.LogMinerMsg"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="optionsPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="exportForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/exportAdvanced10i"/>

          <uix:pageLayout titleBinding="optionsPageHeader@exportBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@exportBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="ADVANCED@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>

                  <uix:labeledFieldLayout labelWidth="40%"> 
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="parallelism" 
                          textBinding="PARALLELISM_LABEL@exportBundle@servletRequest"/>
                      <uix:textInput name="parallelism" id="parallelism" 
                          readOnlyBinding="notEnterpriseEdition@exportBean@servletRequest"
                          textBinding="parallelism@exportBean@servletRequest" columns="3">
                        <uix:onSubmitValidater>
                          <uix:decimal maxScale="0"/>
                        </uix:onSubmitValidater>
                      </uix:textInput>
                      <uix:styledText styleClass="OraInstructionText" text=""/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="PARALLELISM_TEXT@exportBundle@servletRequest"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>  

<%-- remove Keep Master per server team review
                  <uix:checkBox textBinding="KEEP_MASTER@exportBundle@servletRequest" name="keepMaster" 
                                checkedBinding="keepMaster@exportBean@servletRequest"/>
--%>

                  <uix:header textBinding="ESTIMATE_DISK_SPACE@exportBundle@servletRequest" size="1">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" textBinding="ESTIMATE_DISK_SPACE_TEXT@exportBundle@servletRequest"/>
                        <oem:radioButton
                                  name="estimateType"
                                  selectedValueBinding="estimateType@exportBean@servletRequest"
                                  textBinding="ESTIMATE_BLOCKS@exportBundle@servletRequest"
                                  value="BLOCKS"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_BLOCKS_TEXT@exportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>
                        <oem:radioButton
                                  name="estimateType"
                                  selectedValueBinding="estimateType@exportBean@servletRequest"
                                  textBinding="ESTIMATE_STATISTICS@exportBundle@servletRequest"
                                  value="STATISTICS"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_STATS_TEXT@exportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>
<%-- remove Sampling per server team review
                        <oem:radioButton
                                  name="estimateType"
                                  selectedValueBinding="estimateType@exportBean@servletRequest"
                                  textBinding="ESTIMATE_SAMPLING@exportBundle@servletRequest"
                                  value="SAMPLING"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_SAMPLING_TEXT@exportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>
--%>

                        <uix:submitButton formName="exportForm" shortDescBinding="ESTIMATE_NOW_BUTTON@exportBundle@servletRequest" textBinding="ESTIMATE_NOW_BUTTON@exportBundle@servletRequest" name="event" value="estimateNow"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_NOW_TEXT@exportBundle@servletRequest"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>

                      </uix:contents>
                    </uix:stackLayout>
                  </uix:header>

                  <uix:header textBinding="OPTIONAL_FILES@exportBundle@servletRequest" size="1">
                    <uix:tableLayout cellSpacing="5">
                      <uix:contents>

                        <uix:stackLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:checkBox 
                                name="generateLogFile" 
                                checkedBinding="generateLogFile@exportBean@servletRequest" 
                                textBinding="GENERATE_LOG_FILE@exportBundle@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/> 
                              <uix:stackLayout>

                                <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                                  <uix:case name="true">
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:labeledFieldLayout labelWidth="20%">
                                          <uix:contents>
                                            <uix:styledText styleClass="OraInstructionText" labeledNodeId="logDirectoryObject" textBinding="FILE_DIRECTORY@exportBundle@servletRequest"/>
                                            <uix:stackLayout>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:choice
                                                          name="logDirectoryObject"
                                                          id="logDirectoryObject" 
                                                          selectedValueBinding="logDirectoryObject@exportBean@servletRequest">
                                                    <uix:contents childDataBinding="allDirectoryObjects@exportBean@servletRequest">
                                                      <uix:option textBinding="."/>
                                                    </uix:contents>
                                                  </uix:choice>
                                                  <uix:spacer width="5"/>
                                                  <uix:submitButton shortDescBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest" textBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest" formName="exportForm" name="event" value="createDirObject"/>
                                                </uix:contents>
                                              </uix:rowLayout>
                                              <uix:messageText messageType="error" messageBinding="DirectoryObject@errors@servletRequest"/>
                                            </uix:stackLayout>
                                            <uix:styledText styleClass="OraInstructionText" labeledNodeId="logFileName" 
                                                textBinding="LOG_FILE@exportBundle@servletRequest"/>
                                            <uix:stackLayout>
                                              <uix:textInput name="logFileName" id="logFileName" 
                                                  textBinding="logFileName@exportBean@servletRequest" columns="60"/>
                                              <uix:messageText messageType="error" messageBinding="LogFile@errors@servletRequest"/>
                                            </uix:stackLayout>
                                          </uix:contents>
                                        </uix:labeledFieldLayout>  
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:case>
                                  <uix:case name="false">
                                    <uix:labeledFieldLayout labelWidth="20%">
                                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="logFileName2" 
                                          textBinding="LOG_FILE_NAME@exportBundle@servletRequest"/>
                                      <uix:stackLayout>
                                        <uix:textInput name="logFileName" id="logFileName2" 
                                            textBinding="logFileName@exportBean@servletRequest" columns="60"/>
                                        <uix:messageText messageType="error" messageBinding="LogFile@errors@servletRequest"/>
                                      </uix:stackLayout>
                                    </uix:labeledFieldLayout>
                                  </uix:case>
                                </uix:switcher>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:rowLayout>
                        </uix:stackLayout>

                      </uix:contents>
                    </uix:tableLayout>
                  </uix:header>
<%-- Adding Encryption Key for Encrypted Columns --%>

<uix:switcher childNameBinding="encryptionOption@exportBean@servletRequest">
                           <uix:case name="false">
                           </uix:case>
                           <uix:case name="true">
                             
                           
                             
                                 <uix:header textBinding="EXPORT_FORMAT@exportBundle@servletRequest">
			                               <uix:contents>
			                                 <uix:tableLayout>
			                                   <uix:contents>
			                                     <uix:rowLayout>
			                                       <uix:contents>
			                                         <uix:cellFormat width="50%">
			                                           <uix:contents>
			                                             <uix:rowLayout>
			                                               <uix:contents>
			                                                 <uix:styledText textBinding="EXPORT_ENCRYPTION_INFO@exportBundle@servletRequest" styleClass="OraInstructionText"/>
			                                               </uix:contents>
			                                             </uix:rowLayout>
			                                             <uix:spacer width="10" height="10"/>
			                                             <uix:rowLayout>
			                                               <uix:contents>
			                                               
			                                                     <uix:stackLayout>
									     									    <uix:radioButton textBinding="PLAIN_TEXT@exportBundle@servletRequest"
name="encryptionType" selectedValueBinding="encryptionType@exportBean@servletRequest" value="PLAINTEXT" styleClass="OraInstructionText"/>
									     										  <uix:spacer height="10" width="10"/>
									     										<uix:radioButton textBinding="ENCRYPTED@exportBundle@servletRequest" 
name="encryptionType" selectedValueBinding="encryptionType@exportBean@servletRequest" value="ENCRYPTED" styleClass="OraInstructionText"/>
									     										  
									     										
                                                                            </uix:stackLayout>
			                                                   </uix:contents>
			                                                
			                                               
			                                             </uix:rowLayout>
			                                             <uix:rowLayout>
			                                               <uix:contents>
			                                                 <uix:labeledFieldLayout>
			                                                   <uix:contents>
			                                                     <uix:messageTextInput secret="true" promptBinding="KEY@exportBundle@servletRequest"
																
name="encryptionKey" textBinding="encryptionKey@exportBean@servletRequest" vAlign="middle"/>
			                                                     <uix:spacer width="10" height="10"/>
			                                                     <uix:messageTextInput  secret="true"
																 promptBinding="CONFIRM_KEY@exportBundle@servletRequest"
																 name="encryptionConfirmKey" textBinding="encryptionConfirmKey@exportBean@servletRequest" vAlign="middle"/>
			                                                   </uix:contents>
			                                                 </uix:labeledFieldLayout>
			                                               </uix:contents>
			                                             </uix:rowLayout>
			                                           </uix:contents>
			                                         </uix:cellFormat>
			                                         <uix:cellFormat>
			                                           <uix:contents>
			                                             <uix:contentContainer width="70%">
			                                               <uix:contents>
			                                                 <uix:styledText textBinding="ENCRYPTED_CONTAINER@exportBundle@servletRequest" styleClass="OraInstructionText"/>
			                                               </uix:contents>
			                                             </uix:contentContainer>
			                                           </uix:contents>
			                                         </uix:cellFormat>
			                                       </uix:contents>
			                                     </uix:rowLayout>
			                                   </uix:contents>
			                                 </uix:tableLayout>
			                               </uix:contents>
                                                   </uix:header>
                            </uix:case>
                          </uix:switcher>
<%-- Adding Encryption Key for Encrypted Columns --%>

                  <uix:hideShow disclosedBinding="showAdvancedOptions@exportBean@servletRequest"
                                formSubmitted="true" id="hideShow"
                                disclosedTextBinding="HIDE_ADVANCED_OPTIONS@exportBundle@servletRequest"
                                undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@exportBundle@servletRequest">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>

<%-- don't allow the user to turn off estimate; per server group
                          <uix:checkBox textBinding="ESTIMATE_NONE@exportBundle@servletRequest" name="dontEstimateDiskSpace" 
                                        checkedBinding="dontEstimateDiskSpace@exportBean@servletRequest"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/> 
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_NONE_TEXT@exportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
--%>

                          <uix:header textBinding="CONTENT@exportBundle@servletRequest" size="1">
                            <uix:stackLayout>
                              <uix:contents>

                                <uix:tableLayout>
                                  <uix:rowLayout>
                                    <uix:styledText styleClass="OraInstructionText" textBinding="CONTENT_TEXT@exportBundle@servletRequest"/>
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <oem:radioButton
                                                  name="contentType"
                                                  selectedValueBinding="contentType@exportBean@servletRequest"
                                                  textBinding="ALL@exportBundle@servletRequest"
                                                  value="ALL"/>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="ALL_TEXT@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <oem:radioButton
                                                  name="contentType"
                                                  selectedValueBinding="contentType@exportBean@servletRequest"
                                                  textBinding="DATA_ONLY@exportBundle@servletRequest"
                                                  value="DATA_ONLY"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="DATA_ONLY_TEXT@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>

                                        <oem:radioButton
                                                  name="contentType"
                                                  selectedValueBinding="contentType@exportBean@servletRequest"
                                                  textBinding="METADATA_ONLY@exportBundle@servletRequest"
                                                  value="METADATA_ONLY"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="METADATA_ONLY_TEXT@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:rowLayout>
                                </uix:tableLayout>

                                <uix:labeledFieldLayout labelWidth="15%"> 
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText" textBinding="ASSOCIATED_OBJECTS_LABEL@exportBundle@servletRequest"/>
                                    <oem:radioButton
                                              name="associatedObjectsType"
                                              selectedValueBinding="associatedObjectsType@exportBean@servletRequest"
                                              textBinding="ASSOCIATED_OBJECTS_ALL@exportBundle@servletRequest"
                                              value="ALL"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <oem:radioButton
                                              name="associatedObjectsType"
                                              selectedValueBinding="associatedObjectsType@exportBean@servletRequest"
                                              textBinding="INCLUDE@exportBundle@servletRequest"
                                              value="INCLUDE"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <oem:radioButton
                                              name="associatedObjectsType"
                                              selectedValueBinding="associatedObjectsType@exportBean@servletRequest"
                                              textBinding="EXCLUDE@exportBundle@servletRequest"
                                              value="EXCLUDE"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <uix:tableLayout>
                                      <uix:rowLayout>
                                        <oem:table name="associatedObjectsTableUI"
                                                 beanKey="exportBean"
                                                 textBinding="ASSOCIATED_OBJECTS_TABLE_HEADER@exportBundle@servletRequest"
                                                 summaryBinding="ASSOCIATED_OBJECTS_TABLE_HEADER@exportBundle@servletRequest"
                                                 destination="/console/database/data/export"
                                                 formSubmitted="true"
                                                 dataSourceProp="associatedObjectsTableUI"
                                                 alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
                                          <uix:tableSelection>
                                            <uix:singleSelection 
                                                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                                selectedIndexBinding="selectedIndex@associatedObjectsTableDS@exportBean@servletRequest">
                                              <uix:submitButton shortDescBinding="REMOVE@exportBundle@servletRequest" textBinding="REMOVE@exportBundle@servletRequest" name="event" 
                                                  value="deleteAssociatedObject" disabledBinding="disableMultipleFilesMode@exportBean@servletRequest"/>
                                            </uix:singleSelection>
                                          </uix:tableSelection>
                                          <uix:footer>
                                            <uix:submitButton shortDescBinding="ADD_FILE@exportBundle@servletRequest" textBinding="ADD_FILE@exportBundle@servletRequest" name="event" 
                                                value="addAssociatedObject" disabledBinding="disableMultipleFilesMode@exportBean@servletRequest"/>
                                          </uix:footer>
                                        </oem:table>
                                      </uix:rowLayout>
                                      <uix:rowLayout>
                                        <uix:styledText styleClass="OraInlineInfoText" textBinding="OBJECT_NAME_HINT@exportBundle@servletRequest"/>
                                      </uix:rowLayout>
                                      <uix:rowLayout>
                                        <uix:messageText messageType="error" messageBinding="AssociatedObjects@errors@servletRequest"/>
                                      </uix:rowLayout>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:labeledFieldLayout>  

                              </uix:contents>
                            </uix:stackLayout>
                          </uix:header>

                          <uix:header textBinding="FLASHBACK_HEADER@exportBundle@servletRequest" size="1">
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:checkBox
                                  textBinding="EXPORT_READ_CONSISTENT_VIEW@exportBundle@servletRequest"
                                  name="readConsistent"
                                  checkedBinding="readConsistent@exportBean@servletRequest"/>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer width="20"/> 
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <oem:radioButton
                                                    name="exportConsistentType"
                                                    selectedValueBinding="exportConsistentType@exportBean@servletRequest"
                                                    textBinding="AS_SPECIFIED_SCN@exportBundle@servletRequest"
                                                    value="FLASHBACK_SCN"/>
                                        <uix:labeledFieldLayout labelWidth="30%"> 
                                          <uix:contents>
                                            <uix:styledText styleClass="OraInstructionText" labeledNodeId="flashbackScn" 
                                                textBinding="SYSTEM_CHANGE_NUMBER@exportBundle@servletRequest"/>
                                            <uix:stackLayout>
                                              <uix:textInput name="flashbackScn" id="flashbackScn" 
                                                  textBinding="flashbackScn@exportBean@servletRequest" columns="20"/>
                                              <uix:messageText messageType="error" messageBinding="FlashbackScn@errors@servletRequest"/>
                                            </uix:stackLayout>
                                          </uix:contents>
                                        </uix:labeledFieldLayout>  
                                        <oem:radioButton
                                                    name="exportConsistentType"
                                                    selectedValueBinding="exportConsistentType@exportBean@servletRequest"
                                                    textBinding="AS_SCN_MATCHING_TIME@exportBundle@servletRequest"
                                                    value="FLASHBACK_TIME"/>
                                        <uix:labeledFieldLayout labelWidth="30%">
                                          <uix:contents>
                                            <uix:styledText labeledNodeId="flashbackTimeDate" styleClass="OraInstructionText" textBinding="DATE@exportBundle@servletRequest"/>
                                            <uix:dateField name="flashbackTimeDate" id="flashbackTimeDate" columns="16" valueBinding="flashbackTimeDate@exportBean@servletRequest">
                                              <uix:onSubmitValidater>
                                                <uix:date dateStyle="long"/>
                                              </uix:onSubmitValidater>
                                            </uix:dateField>
                                            <uix:styledText styleClass="OraInstructionText" textBinding="TIME@exportBundle@servletRequest"/>
                                            <uix:rowLayout>
<%--
                                              <uix:choice
                                                name="flashbackTimeHour"
                                                shortDescBinding="timeHour@exportBean@servletRequest"
                                                selectedValueBinding="flashbackTimeHour@exportBean@servletRequest">
                                                <uix:option text="01" value="01"/>
                                                <uix:option text="02" value="02"/>
                                                <uix:option text="03" value="03"/>
                                                <uix:option text="04" value="04"/>
                                                <uix:option text="05" value="05"/>
                                                <uix:option text="06" value="06"/>
                                                <uix:option text="07" value="07"/>
                                                <uix:option text="08" value="08"/>
                                                <uix:option text="09" value="09"/>
                                                <uix:option text="10" value="10"/>
                                                <uix:option text="11" value="11"/>
                                                <uix:option text="12" value="00"/>
                                              </uix:choice>
 --%>
                            <oem:choice
                                 name="flashbackTimeHour"
                                 id="flashbackTimeHour" 
                                 selectedValueBinding="flashbackTimeHour@exportBean@servletRequest"
                                 optionsBinding="hourBasedOnLocale@exportBean@servletRequest"/>
                            <oem:choice
                                 name="flashbackTimeMinute"
                                 id="flashbackTimeMinute"
                                 shortDescBinding="timeMinute@exportBean@servletRequest"
                                 selectedValueBinding="flashbackTimeMinute@exportBean@servletRequest"
                                 optionsBinding="minuteBasedOnLocale@exportBean@servletRequest" />
<%--
                                                <uix:option text="00" value="00"/>
                                                <uix:option text="05" value="05"/>
                                                <uix:option text="10" value="10"/>
                                                <uix:option text="15" value="15"/>
                                                <uix:option text="20" value="20"/>
                                                <uix:option text="25" value="25"/>
                                                <uix:option text="30" value="30"/>
                                                <uix:option text="35" value="35"/>
                                                <uix:option text="40" value="40"/>
                                                <uix:option text="45" value="45"/>
                                                <uix:option text="50" value="50"/>
                                                <uix:option text="55" value="55"/>
                                              </uix:choice>a
--%>
<%--
                                              <oem:radioButton
                                                name="flashbackTimeAmPm"
                                                selectedValueBinding="flashbackTimeAmPm@exportBean@servletRequest"
                                                text="AM"
                                                value="AM"/>
                                              <oem:radioButton
                                                name="flashbackTimeAmPm"
                                                selectedValueBinding="flashbackTimeAmPm@exportBean@servletRequest"
                                                text="PM"
                                                value="PM"/>
--%>
                                              <uix:switcher childNameBinding="showAMPM@exportBean@servletRequest" defaultCase="false">
                                                <uix:case name="true">
                                                  <uix:tableLayout>
                                                    <uix:rowLayout>
                                                       <uix:radioButton textBinding="AM_LABEL@lmMsg" name="flashbackTimeAmPm" selectedValueBinding="flashbackTimeAmPm@exportBean@servletRequest" value="AM"/>
                                                       <uix:radioButton textBinding="PM_LABEL@lmMsg" name="flashbackTimeAmPm" selectedValueBinding="flashbackTimeAmPm@exportBean@servletRequest" value="PM"/>
                                                    </uix:rowLayout>
                                                  </uix:tableLayout>
                                                </uix:case>
                                              </uix:switcher>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:labeledFieldLayout>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:contents>
                                </uix:rowLayout>

<%--
per server team comments, remove access method
                                <uix:tableLayout>
                                  <uix:rowLayout>
                                    <uix:styledText styleClass="OraInstructionText" textBinding="ACCESS_METHOD_TEXT@exportBundle@servletRequest"/>
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <oem:radioButton
                                                  name="accessMethodType"
                                                  selectedValueBinding="accessMethodType@exportBean@servletRequest"
                                                  textBinding="AUTOMATIC@exportBundle@servletRequest"
                                                  value="AUTOMATIC"/>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="AUTOMATIC_TEXT@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>

                                        <oem:radioButton
                                                  name="accessMethodType"
                                                  selectedValueBinding="accessMethodType@exportBean@servletRequest"
                                                  textBinding="DIRECT_PATH@exportBundle@servletRequest"
                                                  value="DIRECT_PATH"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="DIRECT_PATH_TEXT@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>

                                        <oem:radioButton
                                                  name="accessMethodType"
                                                  selectedValueBinding="accessMethodType@exportBean@servletRequest"
                                                  textBinding="EXTERNAL_TABLE@exportBundle@servletRequest"
                                                  value="EXTERNAL_TABLE"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="EXTERNAL_TABLE_TEXT@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:rowLayout>
                                </uix:tableLayout>
per server team comments, remove access method
--%>

                              </uix:contents>
                            </uix:stackLayout>
                          </uix:header>

                          <uix:switcher childNameBinding="disableQuery@exportBean@servletRequest">
                           <uix:case name="true">
                           </uix:case>
                           <uix:case name="false">
                             <uix:header textBinding="QUERY@exportBundle@servletRequest" size="1">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="FILTER_TEXT@exportBundle@servletRequest"/>
                                  <uix:tableLayout>
                                    <uix:rowLayout>
                                      <oem:table name="filterDataTableUI"
                                               beanKey="exportBean"
                                               destination="/console/database/data/export"
                                               formSubmitted="true"
                                               dataSourceProp="filterDataTableUI"
                                               summaryBinding="QUERY@exportBundle@servletRequest" 
                                               alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
                                        <uix:tableSelection>
                                          <uix:singleSelection 
                                              shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                              selectedIndexBinding="selectedIndex@filterDataTableDS@exportBean@servletRequest">
                                            <uix:submitButton shortDescBinding="REMOVE@exportBundle@servletRequest" textBinding="REMOVE@exportBundle@servletRequest" name="event" 
                                                value="deleteFilterData"/>
                                            <uix:submitButton shortDescBinding="EDIT@DBObjectBundle@servletRequest" textBinding="EDIT@DBObjectBundle@servletRequest" name="event" 
                                                value="editFilterData"/>
                                          </uix:singleSelection>
                                        </uix:tableSelection>
                                        <uix:footer>
                                          <uix:submitButton shortDescBinding="ADD@DBObjectBundle@servletRequest" textBinding="ADD@DBObjectBundle@servletRequest" name="event" 
                                              value="addFilterData"/>
                                        </uix:footer>
                                      </oem:table>
                                    </uix:rowLayout>
                                  </uix:tableLayout>
                                </uix:contents>
                              </uix:stackLayout>
                             </uix:header>
                            </uix:case>
                          </uix:switcher>

                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:hideShow>

                </uix:contents>
              </uix:stackLayout>
            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" shortDescBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton formName="exportForm" textBinding="FINISH@exportBundle@servletRequest" shortDescBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/> 
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="exportForm"
                    maxValueBinding="navMaxValue@exportBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@exportBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
