<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="availableTablesPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="selectTableForm" method="post" copyParams="target,type,cancelURL"
      destination="/console/database/data/export">
      
      <uix:formValue 
          name="pageName" 
          value="/database/data/exportAvailableTables"/>
      <uix:pageLayout
        titleBinding="TITLE_AVAILABLE_TABLES@exportBundle@servletRequest"
        >

        <%@ include file="/database/global.jspf" %>

        <%-- Train must be within pageLayout location child to display above title --%>
        <uix:location>
          <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
            <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
        </uix:location>

<uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

        <%-- Use the pageStatus tag to provide page context (target name) --%>
        <uix:pageStatus>
          <uix:labeledFieldLayout labelWidth="10%">
            <uix:contents>
              <uix:messagePrompt
                  promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
              <uix:styledText
                 styleClass="OraDataText"
                 textBinding="targetDBName@exportBean@servletRequest"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:pageStatus>

        <uix:separator/>

        <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
          <uix:case name="true">
            <uix:styledText styleClass="OraInstructionText" 
                textBinding="tablesSearchHelpText@exportBean@servletRequest"/>
          </uix:case>
        </uix:switcher>

        <%-------------------------
         -  Search Filter
         ---------------------------%>
        <uix:header
          textBinding="SEARCH@DBObjectBundle@servletRequest">
          <uix:stackLayout>

            <%-- Use different text for different types of objects --%>
            <uix:rowLayout>
              <uix:contents>
                <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                  <uix:case name="true">
                    <uix:switcher childNameBinding="areTablesSelected@exportBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraInstructionText"
                          textBinding="ENTER_OBJECT_NAME@DBObjectBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:styledText styleClass="OraPromptText" 
                          textBinding="SEARCH_CRITERIA_TABLE_FROM_ONE_SCHEMA@exportBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="ENTER_OBJECT_NAME@DBObjectBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
                <uix:cellFormat>
                  <uix:contents>
                    <uix:spacer width="5"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:contents>
            </uix:rowLayout>

            <uix:labeledFieldLayout labelWidth="20%"> 
              <uix:contents>

                <%-- Display the object name --%>
                <uix:styledText styleClass="OraPromptText" labeledNodeId="userSearchFilter"
                  textBinding="SCHEMA@DBObjectBundle@servletRequest"/>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:rowLayout>  
                      <uix:contents>
                        <uix:switcher childNameBinding="privilegedUser@exportBean@servletRequest">
                          <uix:case name="true">
                            <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                              <uix:case name="true">
                                <uix:switcher childNameBinding="areTablesSelected@exportBean@servletRequest">
                                  <uix:case name="false">
                                    <uix:stackLayout>
                                      <uix:lovInput
                                        name="userSearchFilter"
                                        id="userSearchFilter"
                                        columns="30"
                                        textBinding="userSearchFilter@exportAvailTablesTableBean@servletRequest"
                                        searchDescBinding="SCHEMA@DBObjectBundle@servletRequest"
                                        destinationBinding="userSearchFilterDest@servletRequest"/>
                                      <uix:messageText messageType="error" messageBinding="userSearchFilter@errors@servletRequest"/>
                                    </uix:stackLayout>
                                  </uix:case>
                                  <uix:case name="true">
                                    <uix:styledText styleClass="OraDataText"
                                      textBinding="userSearchFilter@exportAvailTablesTableBean@servletRequest"/>
                                  </uix:case>
                                </uix:switcher>
                              </uix:case>
                              <uix:case name="false">
                                <uix:textInput name="userSearchFilter" id="userSearchFilter"
                                  textBinding="userSearchFilter@exportAvailTablesTableBean@servletRequest"/>
                              </uix:case>
                            </uix:switcher>
                          </uix:case>
                          <uix:case name="false"> <%-- isPrivilegedUser --%>
                            <uix:styledText styleClass="OraDataText"
                                      textBinding="userSearchFilter@exportAvailTablesTableBean@servletRequest"/>
                          </uix:case>
                        </uix:switcher>
                      </uix:contents>
                    </uix:rowLayout> 

                    <%-- Hint text for schema field --%>
                    <uix:switcher childNameBinding="privilegedUser@exportBean@servletRequest">
                      <uix:case name="true">
                        <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                          <uix:case name="true">
                            <uix:switcher childNameBinding="areTablesSelected@exportBean@servletRequest">
                              <uix:case name="false">
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="EXACT_SCHEMA_MATCH_HINT@exportBundle@servletRequest"/>
                              </uix:case>
                            </uix:switcher>
                          </uix:case>
                        </uix:switcher>
                      </uix:case>
                    </uix:switcher>
                  </uix:contents>
                </uix:stackLayout>

                <uix:styledText styleClass="OraPromptText" labeledNodeId="tableSearchFilter"
                  textBinding="TABLE@DBObjectBundle@servletRequest"/>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:textInput name="tableSearchFilter" id="tableSearchFilter"
                      textBinding="tableSearchFilter@exportAvailTablesTableBean@servletRequest"/>                      

                    <%-- Hint text for table field --%>
                    <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="PARTIAL_TABLE_MATCH_HINT@exportBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:contents>
                </uix:stackLayout>

                <uix:styledText styleClass="OraPromptText" 
                  textBinding="SEARCH_FOR@exportBundle@servletRequest"/>
                <uix:rowLayout>  
                  <uix:contents>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <oem:radioButton
                                  name="objectType"
                                  selectedValueBinding="objectType@exportAvailTablesTableBean@servletRequest"
                                  textBinding="TABLES@DBObjectBundle@servletRequest"
                                  value="TABLE"/>
                        <oem:radioButton
                                  name="objectType"
                                  selectedValueBinding="objectType@exportAvailTablesTableBean@servletRequest"
                                  textBinding="PARTITIONS@exportBundle@servletRequest"
                                  value="PARTITION"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout> 

                <uix:styledText styleClass="OraInlineInfoText" text=""/>
                <uix:submitButton 
                    shortDescBinding="GO@DBObjectBundle@servletRequest"
                    textBinding="GO@DBObjectBundle@servletRequest"
                    onFocus="true"
                    selected="true" name="event" value="search"/>

              </uix:contents>
            </uix:labeledFieldLayout>  

          </uix:stackLayout>
        </uix:header>

        <%-------------------------
         -  Available Tables Table
         ---------------------------%>

        <uix:header 
          textBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
          >
          <oem:table 
            width="80%" 
            blockSize="10"
            summaryBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
            formSubmitted="true"
            name="availTableTable" 
            beanKey="exportAvailTablesTableBean"
            dataSourceProp="availTableTable"
            alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest"
            >
            <uix:tableSelection>
              <uix:multipleSelection
                selectionBinding="selection@exportAvailTablesTableBean@servletRequest"
                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                selectedBinding="selected"/>
            </uix:tableSelection>
          </oem:table>
        </uix:header>

        <%-------------------------
         -  PageButtons
         ---------------------------%>
        <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event" 
              shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
              textBinding="CANCEL@DBObjectBundle@servletRequest"
              value="cancelSelect"/>

            <uix:submitButton
              name="event" 
              shortDescBinding="SELECT@DBObjectBundle@servletRequest"
              textBinding="SELECT@DBObjectBundle@servletRequest"
              value="selectItems"/>

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
  </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
