<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="AVAILABLE_TABLESPACES@exportBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <uix:listOfValues titleBinding="AVAILABLE_TABLESPACES@exportBundle@servletRequest">

          <uix:formValue 
              name="pageName" 
              value="/database/data/exportAvailableTablespace"/>

          <uix:searchInstructions>
            <uix:styledText styleClass="OraInstructionText"
                textBinding="ENTER_OBJECT_NAME@DBObjectBundle@servletRequest"/>
          </uix:searchInstructions>

          <uix:contents>
            <oem:table
                beanKey="exportAvailTablespacesTableBean"
                alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest"
                name="availTablespaceTable"
                summaryBinding="AVAILABLE_TABLESPACES@exportBundle@servletRequest"
                dataSourceProp="availTablespaceTable"
                width="100%"
                blockSize="10"
                formSubmitted="true"
                proxied="true">
              <uix:tableSelection>
                <uix:singleSelection 
                    shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                    selectedIndex="0"/>
              </uix:tableSelection>
            </oem:table>
          </uix:contents>
        </uix:listOfValues>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

