<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="estimateResultsProgressPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="processingForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/exportEstimateResultsProgress"/>

          <uix:pageLayout titleBinding="estimateResultsProgressPageHeader@exportBean@servletRequest" messageType="processing">

            <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
            
            <uix:pageStatus>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="ESTIMATE_PROGRESS_DESCRIPTION@exportBundle@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
            </uix:pageStatus>

            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:spacer height="5" />
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="MAY_TAKE_SEVERAL_MIN@exportBundle@servletRequest"/>
                  <uix:spacer height="20" /> 
                 <%-- id="estimateResultsProgress"  --%>
                  <uix:processing 
                           timeInterval="<%=processingPageInterval%>">
                    <uix:contents>
                      <uix:styledText styleClass="OraProcessingStatusFixed" textBinding="ESTIMATE_PROGRESS_DESCRIPTION@exportBundle@servletRequest"/>
                    </uix:contents>
                  </uix:processing>
                  <uix:spacer width="10"/>
                  <uix:tip>
                    <uix:styledText textBinding="OPERATION_CANNOT_BE_CANCELLED@exportBundle@servletRequest" styleClass="OraInstructionText"/>
                  </uix:tip>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:pageLayout> 
        </db:form>  
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
