<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="filesPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="exportForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
        <uix:formValue name="pageName" value="/database/data/exportFiles"/>

          <uix:pageLayout titleBinding="filesPageHeader@exportBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@exportBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="EXPORT_FILES@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                  <uix:case name="true">

                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" width="80%">
                          <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_EXPORT_FILES_10I@exportBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat hAlign="right" width="20%">
                          <uix:submitButton shortDescBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest" textBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest" formName="exportForm" name="event" value="createDirObject"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>

                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_EXPORT_FILES@exportBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>

                <uix:tableLayout width="100%">
                  <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                    <uix:case name="false">
                      <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="8.1.3">
                        <uix:case name="true">
                          <uix:rowLayout hAlign="right">
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:submitButton shortDescBinding="REORDER@exportBundle@servletRequest" textBinding="REORDER@exportBundle@servletRequest" name="event" value="reorderFiles"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:case>
                      </db:switcher>
                    </uix:case>
                  </uix:switcher>
                  <oem:table name="filesTableUI"
                           beanKey="exportBean"
                           destination="/console/database/data/export"
                           formSubmitted="true"
                           dataSourceProp="filesTableUI"
                           summaryBinding="EXPORT_FILES@exportBundle@servletRequest"
                           width="100%">
                    <uix:tableSelection>
                      <oem:singleSelection 
                          shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                          selectedIndexBinding="selectedIndex@filesTableDS@exportBean@servletRequest">

                        <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="8.1.3">
                          <uix:case name="true">
                            <uix:submitButton shortDescBinding="REMOVE@exportBundle@servletRequest" textBinding="REMOVE@exportBundle@servletRequest" name="event" 
                                value="deleteExportFile"/>
                          </uix:case>
                        </db:switcher>
                      
                      </oem:singleSelection>
                    </uix:tableSelection>
                    <uix:footer>
                      <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="8.1.3">
                        <uix:case name="true">
                          <uix:submitButton
                                shortDescBinding="ADD_FILE@exportBundle@servletRequest"
                                textBinding="ADD_FILE@exportBundle@servletRequest"
                                name="event" 
                                value="addExportFile"/>
                                </uix:case>
                      </db:switcher>
                    </uix:footer>
                  </oem:table>
                  <uix:messageText messageType="error" messageBinding="ExportFile@errors@servletRequest"/>
                </uix:tableLayout>
              <%--  <oem:messageText errorTableKey="errors" errorKey="datafilesTable" messageType="error"/>  --%>
              </uix:stackLayout>
            <%-- </uix:header> --%>

            <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:contents>
                    <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_MAX_EXPORT_FILE_SIZE@exportBundle@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:styledText styleClass="OraInstructionText" textBinding="MAX_DATA_EXPORTED_IS@exportBundle@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <uix:labeledFieldLayout labelWidth="30%">
                  <uix:contents>
                    <uix:styledText styleClass="OraPromptText" labeledNodeId="dumpFileSize" textBinding="MAX_FILE_SIZE@exportBundle@servletRequest"/>
                    <uix:stackLayout>
                      <uix:textInput name="dumpFileSize" id="dumpFileSize" textBinding="dumpFileSize@exportBean@servletRequest"
                                     columns="20"/>
                      <uix:messageText messageType="error" messageBinding="DumpFileSize@errors@servletRequest"/>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraInlineInfoText" textBinding="FILE_TABLE_DATE_HINT@exportBundle@servletRequest"/>
              </uix:case>
            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="exportForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="exportForm"
                    maxValueBinding="navMaxValue@exportBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@exportBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>
      
          </uix:pageLayout>       
        </db:form>
      
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
