<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="optionsFilterPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="exportForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/exportFilterEdit"/>

          <uix:pageLayout titleBinding="optionsFilterPageHeader@exportBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                               errorTableBinding="errors@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@exportBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:header textBinding="FILTER_NAME@exportBundle@servletRequest" size="1">
              <uix:stackLayout>
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="10%">
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="filterTable"
                          textBinding="FILTER_NAME@exportBundle@servletRequest"/>
                      <uix:lovField
                        name="filterTable"
                        id="filterTable"
                        textBinding="filterTable@exportBean@servletRequest"
                        searchDescBinding="FILTER_NAME@exportBundle@servletRequest"
                        onClickBinding="filterTableDest@servletRequest"/>
                      <uix:styledText styleClass="OraInstructionText" text=""/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="FILTER_NAME_HINT@exportBundle@servletRequest"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>  
                </uix:contents>
              </uix:stackLayout>
            </uix:header>

            <uix:header textBinding="FILTER_QUERY@exportBundle@servletRequest" size="1">
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="filterQuery" textBinding="FILTER_TEXT_HINT@exportBundle@servletRequest"/>
                  <uix:textInput rows="5" wrap="soft" name="filterQuery" id="filterQuery"
                      textBinding="filterQuery@exportBean@servletRequest" columns="80"/>
                  <uix:messageText messageType="error" messageBinding="FilterQuery@errors@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton shortDescBinding="CANCEL@DBObjectBundle@servletRequest" formName="exportForm" textBinding="CANCEL@DBObjectBundle@servletRequest" name="event" value="gotoAdvanced"/>
                <uix:submitButton shortDescBinding="OK@DBObjectBundle@servletRequest" formName="exportForm" textBinding="OK@DBObjectBundle@servletRequest" name="event" value="filterEditOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
