<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="reorderFilesPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="selectTableForm" method="post" copyParams="target,type,cancelURL"
      destination="/console/database/data/export">
      
      <uix:formValue 
          name="pageName" 
          value="/database/data/exportReorderFiles"/>
      <uix:pageLayout
        titleBinding="TITLE_REORDER_FILES@exportBundle@servletRequest"
        >

        <%@ include file="/database/global.jspf" %>

        

<uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

        <%-------------------------
         -  Reorder control
         ---------------------------%>

          <uix:stackLayout>
            <uix:shuttle name="reorderFiles" leadingHeader="Files" size="5" reorderable="true" >
              <uix:leading>
                <oem:list name="dumpFileNamesArray">
                  <uix:contents childDataBinding="dumpFileNamesArray@exportBean@servletRequest">
                    <uix:option textBinding="."/>
                  </uix:contents>
                </oem:list>
              </uix:leading>
            </uix:shuttle> 
          </uix:stackLayout>

            

        <%-------------------------
         -  PageButtons
         ---------------------------%>
        <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event" 
              shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
              textBinding="CANCEL@DBObjectBundle@servletRequest"
              value="cancelReorder"/>

            <uix:submitButton
              name="event" 
              shortDescBinding="APPLY@DBObjectBundle@servletRequest"
              textBinding="APPLY@DBObjectBundle@servletRequest"
              value="okReorder"/>

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
  </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

