<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="summaryPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="exportForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/exportReview"/>

          <uix:pageLayout titleBinding="summaryPageHeader@exportBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@exportBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="REVIEW@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>
                  <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                    <uix:case name="true">
                      <uix:labeledFieldLayout labelWidth="40%">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="EXPORT_TYPE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryExportType@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="STATISTICS_TYPE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryStatisticsType@exportBean@servletRequest"/>
<%-- no direct path for 10i
                          <uix:messagePrompt promptBinding="DIRECT_PATH@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryDirectPath@exportBean@servletRequest"/>
--%>
                          <uix:messagePrompt promptBinding="PARALLELISM@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="parallelism@exportBean@servletRequest"/>
<%-- remove KEEP MASTER per server group commenmts
                          <uix:messagePrompt promptBinding="KEEP_MASTER@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryKeepMaster@exportBean@servletRequest"/>
--%>
                          <uix:messagePrompt promptBinding="EXPORT_FILES@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryExportFiles@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="LOG_FILE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryLogFile@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="JOB_SCHEDULE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryScheduleType@exportBean@servletRequest"/>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:labeledFieldLayout labelWidth="40%">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="EXPORT_TYPE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryExportType@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="STATISTICS_TYPE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryStatisticsType@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="DIRECT_PATH@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryDirectPath@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="FAIL_JOBS_ON_ERRORS@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryFailJobs@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="EXPORT_FILES@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryExportFiles@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="MAX_FILE_SIZE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryMaxFileSize@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="LOG_FILE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryLogFile@exportBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="JOB_SCHEDULE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryScheduleType@exportBean@servletRequest"/>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                    <uix:case name="true">
                      <uix:hideShow disclosedBinding="showParameters@exportBean@servletRequest"
                                    formSubmitted="true" id="hideShow"
                                    disclosedTextBinding="HIDE_PLSQL@exportBundle@servletRequest"
                                    undisclosedTextBinding="SHOW_PLSQL@exportBundle@servletRequest">
                        <uix:contents>
                          <uix:messagePrompt labeledNodeId="parameterCommand" promptBinding="SUMMARY_PL_SQL@exportBundle@servletRequest"/>
                          <uix:textInput name="parameterCommand" id="parameterCommand" rows="10" 
                              textBinding="parameterCommand@exportBean@servletRequest" columns="100"
                              readOnly="true"/>
                        </uix:contents>
                      </uix:hideShow>
                    </uix:case>
                    <uix:case name="false">
                      <uix:hideShow disclosedBinding="showParameters@exportBean@servletRequest"
                                    formSubmitted="true" id="hideShow"
                                    disclosedTextBinding="HIDE_PARAMETERS@exportBundle@servletRequest"
                                    undisclosedTextBinding="SHOW_PARAMETERS@exportBundle@servletRequest">
                        <uix:contents>
                          <uix:messagePrompt labeledNodeId="parameterCommand" promptBinding="SUMMARY_PARAMETERS@exportBundle@servletRequest"/>
                          <uix:textInput name="parameterCommand" id="parameterCommand" rows="10" 
                              textBinding="parameterCommand@exportBean@servletRequest" columns="100"
                              readOnly="true"/>
                        </uix:contents>
                      </uix:hideShow>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:stackLayout>

            <%-- </uix:header> --%>

            <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                  <uix:contents>
                    <uix:navigationBar
                      name="ctNav"
                      blockSize="-1"
                      formSubmitted="true"
                      formName="exportForm"
                      maxValueBinding="navMaxValue@exportBean@servletRequest"
                      minValue="1"
                      valueBinding="navValue@exportBean@servletRequest"/>
                  </uix:contents>
                  <uix:submitButton shortDescBinding="SUBMIT_JOB@exportBundle@servletRequest" formName="exportForm" textBinding="SUBMIT_JOB@exportBundle@servletRequest" name="event" value="submit"/>
                </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
