<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="selectUsersPageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="exportForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/exportSelectUsers"/>

          <uix:pageLayout titleBinding="selectUsersPageHeader@exportBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@exportBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@exportBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@exportBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="SELECT_USERS@exportBundle@servletRequest"> --%>

              <%---  Add Button  ---%>
              <uix:switcher childNameBinding="privilegedUser@exportBean@servletRequest">
                <uix:case name="true">
                  <uix:tableLayout width="80%"> 
                    <uix:rowLayout hAlign="right"> 
                      <uix:cellFormat> 
                        <uix:contents> 
                          <uix:submitButton 
                            shortDescBinding="ADD@DBObjectBundle@servletRequest"
                            textBinding="ADD@DBObjectBundle@servletRequest"
                            name="event"
                            value="addItems" 
                            formName="exportForm"
                          />
                        </uix:contents> 
                      </uix:cellFormat> 
                    </uix:rowLayout> 
                  </uix:tableLayout> 
                </uix:case>
              </uix:switcher>

              <%--- User Table ---%>
              <oem:table 
                width="80%" 
                blockSize="10"
                summaryBinding="SELECT_USERS@exportBundle@servletRequest"
                formSubmitted="true"
                name="userTable" 
                dataSourceProp="userTable"
                beanKey="exportSelUsersTableBean"
                alternateTextBinding="NO_SCHEMAS_SELECTED@exportBundle@servletRequest"
                >
                <uix:tableSelection>
                  <oem:singleSelection
                    shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                    selectedIndexBinding="selectedIndex@exportSelUsersTableBean@servletRequest">
                    <uix:switcher childNameBinding="privilegedUser@exportBean@servletRequest">
                      <uix:case name="true">
                        <uix:submitButton
                          shortDescBinding="REMOVE@exportBundle@servletRequest"
                          textBinding="REMOVE@exportBundle@servletRequest"
                          name="event"
                          value="deleteItems"
                          formName="exportForm"
                        />
                      </uix:case>
                    </uix:switcher>
                  </oem:singleSelection>
                </uix:tableSelection>
              </oem:table>

            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="exportForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="exportForm"
                    maxValueBinding="navMaxValue@exportBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@exportBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
