<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="typePageTitle@exportBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="exportForm" destination="/console/database/data/export" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/exportType"/>    

          <uix:pageLayout titleBinding="typePageHeader@exportBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@exportBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="EXPORT_TYPE@exportBundle@servletRequest"> --%>
              <uix:switcher childNameBinding="nonPrivilegedUser@exportBean@servletRequest">
                <uix:case name="true">
                  <uix:tableLayout cellSpacing="5">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents> 
                          <oem:radioButton
                                    name="exportType"
                                    selectedValueBinding="exportType@exportBean@servletRequest"
                                    selected="false"
                                    textBinding="USER@exportBundle@servletRequest"
                                    value="USER"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_USER_NOPRIVS@exportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                          <oem:radioButton
                                    name="exportType"
                                    selectedValueBinding="exportType@exportBean@servletRequest"
                                    selected="false"
                                    textBinding="TABLE@exportBundle@servletRequest"
                                    value="TABLE"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_TABLE_NOPRIVS@exportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                         </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:tableLayout>
                </uix:case>
                <uix:case name="false">
                  <uix:tableLayout cellSpacing="5">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents> 
                          <uix:rowLayout>
                            <uix:contents>
                             <oem:radioButton
                                        name="exportType"
                                        selectedValueBinding="exportType@exportBean@servletRequest"
                                        selected="true"
                                        textBinding="DATABASE@exportBundle@servletRequest"
                                        value="DATABASE"/>
                            </uix:contents>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_DATABASE@exportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                          <oem:radioButton
                                    name="exportType"
                                    selectedValueBinding="exportType@exportBean@servletRequest"
                                    selected="false"
                                    textBinding="USER@exportBundle@servletRequest"
                                    value="USER"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_USER@exportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                          <oem:radioButton
                                    name="exportType"
                                    selectedValueBinding="exportType@exportBean@servletRequest"
                                    selected="false"
                                    textBinding="TABLE@exportBundle@servletRequest"
                                    value="TABLE"/>

                          <uix:switcher childNameBinding="DB10orHigher@exportBean@servletRequest">
                            <uix:case name="true">
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:spacer width="20"/>
                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_TABLE_10I@exportBundle@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                            </uix:case>
                            <uix:case name="false">
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:spacer width="20"/>
                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_TABLE@exportBundle@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                            </uix:case>
                          </uix:switcher>
                          <oem:radioButton
                                    name="exportType"
                                    selectedValueBinding="exportType@exportBean@servletRequest"
                                    selected="true"
                                    textBinding="TABLESPACE@exportBundle@servletRequest"
                                    value="TABLESPACES"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_TABLESPACE@exportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
    <%--
                          <oem:radioButton
                                    name="exportType"
                                    selectedValueBinding="exportType@exportBean@servletRequest"
                                    selected="true"
                                    textBinding="TRANSPORT_TABLESPACE@exportBundle@servletRequest"
                                    value="TRANSPORT_TABLESPACE"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="EXPORT_TRANSPORT_TABLESPACE@exportBundle@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
    --%>
                         </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:tableLayout>
                </uix:case>
              </uix:switcher>

            <%-- </uix:header> --%>

            <uix:header textBinding="HOST_CREDENTIALS@exportBundle@servletRequest">
              <uix:contents>
                <%@ include file="/credentials.jspf"%>
              </uix:contents>
            </uix:header>


            <uix:pageButtons> 
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" shortDescBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton textBinding="CONTINUE@DBObjectBundle@servletRequest" shortDescBinding="CONTINUE@DBObjectBundle@servletRequest" formName="exportForm" name="event" value="continue"/>
                <uix:contents>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons> 

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
