<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="optionsPageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importAdvanced"/>

          <uix:pageLayout titleBinding="optionsPageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="ADVANCED@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>

                  <%-- <uix:header textBinding="GENERAL@exportBundle@servletRequest" size="1"> --%>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:switcher childNameBinding="typeFull@importBean@servletRequest">
                          <uix:case name="true">
                            <uix:checkBox textBinding="OVERWRITE_DATA_FILES@importBundle@servletRequest" 
                                 name="destroy" checkedBinding="destroy@importBean@servletRequest"/>                        
                          </uix:case>
                        </uix:switcher>
                        <uix:checkBox textBinding="NO_REPORT_OBJECT_CREATION_ERROR@importBundle@servletRequest" 
                             name="ignore" checkedBinding="ignore@importBean@servletRequest"/>
                        <uix:checkBox textBinding="SKIP_UNUSABLE_INDEXES@importBundle@servletRequest" 
                             name="skipUnusableIndexes" checkedBinding="skipUnusableIndexes@importBean@servletRequest"/>     
                        <uix:checkBox textBinding="WRITE_INDEX_CREATION_COMMANDS@importBundle@servletRequest" 
                             name="writeIndexFile" checkedBinding="writeIndexFile@importBean@servletRequest"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:labeledFieldLayout  labelWidth="20%">
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText" labeledNodeId="indexFile"
                                    textBinding="INDEX_FILE_COLON@importBundle@servletRequest"/>
                                <uix:textInput name="indexFile" id="indexFile" 
                                    textBinding="indexFile@importBean@servletRequest" columns="50"/>
                                <uix:styledText styleClass="OraInstructionText" text=""/>
                                <uix:messageText messageType="error" messageBinding="IndexFile@errors@servletRequest"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:checkBox textBinding="FAIL_JOBS_ON_ERRORS@exportBundle@servletRequest" 
                             name="SMPIgnore" checkedBinding="SMPIgnore@importBean@servletRequest"/>
                        <uix:checkBox textBinding="PERFORM_TOID_VALIDATION@importBundle@servletRequest" 
                             name="performValidation" checkedBinding="performValidation@importBean@servletRequest"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:styledText styleClass="OraInlineInfoText" labeledNodeId="TOIDNoValidate" 
                                textBinding="SPECIFY_EXCLUDE_TOID@importBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:textInput rows="5" wrap="soft" name="TOIDNoValidate" id="TOIDNoValidate" 
                                 textBinding="TOIDNoValidate@importBean@servletRequest" columns="80"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:stackLayout>

                    <uix:header textBinding="OPTIONAL_FILES@exportBundle@servletRequest" size="1">
                      <uix:tableLayout cellSpacing="5">
                        <uix:contents>
                          <uix:stackLayout>
                            <uix:rowLayout>
                              <uix:cellFormat>
                                <uix:checkBox name="generateLogFile" checkedBinding="generateLogFile@importBean@servletRequest" textBinding="GENERATE_LOG_FILE@exportBundle@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/> 
                                <uix:stackLayout>
                                  <uix:labeledFieldLayout labelWidth="20%">
                                    <uix:contents>
                                      <uix:messageLovField
                                          id="logFileName"
                                          name="logFileName"
                                          promptBinding="LOG_FILE_COLON@exportBundle@servletRequest"
                                          textBinding="logFileName@importBean@servletRequest"
                                          columns="60"
                                          searchDescBinding="CLICK_TO_SELECT_LOG_FILE@exportBundle@servletRequest"
                                          onClick="startFileBrowser('logFileName')"/>
                                    </uix:contents>
                                  </uix:labeledFieldLayout>
                                  <uix:messageText messageType="error" messageBinding="LogFile@errors@servletRequest"/>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:tableLayout>
                    </uix:header>
                  <%-- </uix:header> --%>

                  <uix:hideShow disclosedBinding="showAdvancedOptions@importBean@servletRequest"
                                formSubmitted="true" id="hideShow"
                                disclosedTextBinding="HIDE_ADVANCED_OPTIONS@exportBundle@servletRequest"
                                undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@exportBundle@servletRequest">
                    <uix:contents>
                      <uix:stackLayout>
                      <uix:contents>
                      <uix:header textBinding="ASSOCIATED_OBJECTS@exportBundle@servletRequest" size="1">
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="ASSOCIATED_OBJECT_TYPES@importBundle@servletRequest"/>
                            <uix:checkBox textBinding="ASSOCIATED_OBJECTS_GRANTS@exportBundle@servletRequest" name="grants" checkedBinding="grants@importBean@servletRequest"/>
                            <uix:checkBox textBinding="ASSOCIATED_OBJECTS_INDEXES@exportBundle@servletRequest" name="indexes" checkedBinding="indexes@importBean@servletRequest"/>
                            <uix:checkBox textBinding="ASSOCIATED_OBJECTS_ROWS@exportBundle@servletRequest" name="rows" checkedBinding="rows@importBean@servletRequest"/>
                            <uix:checkBox textBinding="ASSOCIATED_OBJECTS_CONSTRAINTS@exportBundle@servletRequest" name="constraints" checkedBinding="constraints@importBean@servletRequest"/>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:header>

                      <uix:header textBinding="TUNING@exportBundle@servletRequest" size="1">
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:checkBox textBinding="COMMIT_EACH_INSERT@importBundle@servletRequest" 
                                name="commit" checkedBinding="commit@importBean@servletRequest"/>

                            <uix:checkBox textBinding="OVERWRITE_DEFAULT_RECORD_LENGTH@exportBundle@servletRequest" 
                                name="overwriteDefaultRecordLength" checkedBinding="overwriteDefaultRecordLength@importBean@servletRequest"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/> 
                                <uix:stackLayout>
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:labeledFieldLayout labelWidth="180" fieldWidth="380" columns="1">
                                          <uix:contents>
                                            <uix:styledText styleClass="OraInstructionText" labeledNodeId="recordLength" 
                                                textBinding="RECORD_LENGTH@exportBundle@servletRequest"/>
                                            <uix:textInput name="recordLength" id="recordLength" 
                                                textBinding="recordLength@importBean@servletRequest" columns="8"/>
                                            <uix:styledText styleClass="OraInstructionText" text=""/>
                                            <uix:styledText styleClass="OraInlineInfoText" textBinding="RECORD_LENGTH_IS_USED@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:labeledFieldLayout>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:checkBox textBinding="OVERWRITE_DEFAULT_BUFFER_SIZE@exportBundle@servletRequest" 
                                name="overwriteDefaultBufferSize" checkedBinding="overwriteDefaultBufferSize@importBean@servletRequest"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/> 
                                <uix:stackLayout>
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:labeledFieldLayout labelWidth="180" fieldWidth="380" columns="1">
                                          <uix:contents>
                                            <uix:styledText styleClass="OraInstructionText" labeledNodeId="bufferSize" 
                                                textBinding="BUFFER_SIZE@exportBundle@servletRequest"/>                                            
                                            <uix:textInput name="bufferSize" id="bufferSize" 
                                                textBinding="bufferSize@importBean@servletRequest" columns="8"/>
                                            <uix:styledText styleClass="OraInstructionText" text=""/>
                                            <uix:styledText styleClass="OraInlineInfoText" textBinding="BUFFER_SIZE_IS@exportBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:labeledFieldLayout>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:rowLayout>

                          </uix:contents>
                        </uix:stackLayout>
                      </uix:header>

                      <uix:header textBinding="STATISTICS@importBundle@servletRequest" size="1">
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:checkBox textBinding="EXECUTE_ANALYZE@importBundle@servletRequest" 
                                name="analyze" checkedBinding="analyze@importBean@servletRequest"/>
                                
                            <uix:checkBox textBinding="RECALCULATE_STATISTICS@importBundle@servletRequest" 
                                name="recalculateStatistics" checkedBinding="recalculateStatistics@importBean@servletRequest"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/> 
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="YOU_CAN_RECALCULATE_STATISTICS@importBundle@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:header>

                      <uix:header textBinding="OTHER@exportBundle@servletRequest" size="1">
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="IF_PARAMETERS@exportBundle@servletRequest"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:spacer width="20"/>
                                <uix:labeledFieldLayout labelWidth="20%"> 
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText" labeledNodeId="otherParams" 
                                        textBinding="PARAMETERS@exportBundle@servletRequest"/>
                                    <uix:textInput name="otherParams" id="otherParams" 
                                        textBinding="otherParams@importBean@servletRequest" columns="80"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <uix:styledText styleClass="OraInlineInfoText" textBinding="OTHER_EXAMPLE@exportBundle@servletRequest"/>
                                  </uix:contents>
                                </uix:labeledFieldLayout>  
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:header>

                      </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:hideShow>

                </uix:contents>
              </uix:stackLayout>
            

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="importForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="importForm"
                    maxValueBinding="navMaxValue@importBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@importBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
