<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="optionsPageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importAdvanced10i"/>

          <uix:pageLayout titleBinding="optionsPageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="ADVANCED@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>

                  <uix:labeledFieldLayout labelWidth="40%"> 
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="parallelism"
                          textBinding="PARALLELISM_LABEL@importBundle@servletRequest"/>
                      <uix:textInput name="parallelism" id="parallelism" 
                          readOnlyBinding="notEnterpriseEdition@importBean@servletRequest"
                          textBinding="parallelism@importBean@servletRequest" columns="3">
                         <uix:onSubmitValidater>
                          <uix:decimal maxScale="0"/>
                        </uix:onSubmitValidater>
                      </uix:textInput>
                     <uix:styledText styleClass="OraInstructionText" text=""/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="PARALLELISM_TEXT@exportBundle@servletRequest"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>  

<%-- remove Keep Master per server team review
                  <uix:checkBox textBinding="KEEP_MASTER@importBundle@servletRequest" name="keepMaster" 
                                checkedBinding="keepMaster@importBean@servletRequest"/>
--%>

                  <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:header textBinding="ESTIMATE_DISK_SPACE@exportBundle@servletRequest" size="1">
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText" textBinding="ESTIMATE_DISK_SPACE_TEXT@importBundle@servletRequest"/>
                                <oem:radioButton
                                          name="estimateType"
                                          selectedValueBinding="estimateType@importBean@servletRequest"
                                          textBinding="ESTIMATE_BLOCKS@exportBundle@servletRequest"
                                          value="BLOCKS"/>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer width="20"/> 
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_BLOCKS_TEXT@exportBundle@servletRequest"/>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:contents>
                                </uix:rowLayout>
                                <oem:radioButton
                                          name="estimateType"
                                          selectedValueBinding="estimateType@importBean@servletRequest"
                                          textBinding="ESTIMATE_STATISTICS@exportBundle@servletRequest"
                                          value="STATISTICS"/>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer width="20"/> 
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_STATS_TEXT@exportBundle@servletRequest"/>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:contents>
                                </uix:rowLayout>
<%-- remove Sampling per server team review
                                <oem:radioButton
                                          name="estimateType"
                                          selectedValueBinding="estimateType@importBean@servletRequest"
                                          textBinding="ESTIMATE_SAMPLING@exportBundle@servletRequest"
                                          value="SAMPLING"/>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer width="20"/> 
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_SAMPLING_TEXT@exportBundle@servletRequest"/>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:contents>
                                </uix:rowLayout>
--%>

<%-- server team says Estimate Now for Network mode is postpopned until v-next
                                <uix:submitButton
                                    formName="importForm"
                                    shortDescBinding="ESTIMATE_NOW_BUTTON@exportBundle@servletRequest"
                                    textBinding="ESTIMATE_NOW_BUTTON@exportBundle@servletRequest"
                                    name="event"
                                    value="estimateNow"/>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer width="20"/> 
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_NOW_TEXT@importBundle@servletRequest"/>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:contents>
                                </uix:rowLayout>
--%>

                              </uix:contents>
                            </uix:stackLayout>
                          </uix:header>
                        </uix:contents>
                      </uix:stackLayout>

                    </uix:case>
                   </uix:switcher>

                  <%-- start Optional Files section --%>
                  <jsp:include page="/database/data/importAdvancedFiles10i.jsp" />
                  <uix:ref refID="importAdvancedFiles10i" />
                  <%-- End Optional Files section --%>

 <%-- start Encryption Option  section --%>

 <uix:switcher childNameBinding="encryptionOption@importBean@servletRequest">
                            <uix:case name="false">
                            </uix:case>
                           <uix:case name="true">

 <uix:header textBinding ="ENCRYPTION_KEY_NAME@importBundle@servletRequest">
                           <uix:contents>
                             <uix:tableLayout>
                               <uix:contents>
                                 <uix:rowLayout>
                                   <uix:contents>
                                     <uix:cellFormat width="50%">
                                       <uix:contents>
                                         <uix:rowLayout>
                                           <uix:contents>
												<uix:switcher 				childNameBinding="db11017orhigher@importBean@servletRequest">
													<uix:case name="true">
													<uix:styledText
														textBinding="IMPORT_ENCRYPTION_INFO@importBundle@servletRequest"
												 styleClass="OraInstructionText"/>
													</uix:case>
												   <uix:case name="false">
													  <uix:styledText
													 textBinding="IMPORT_ENCRYPTION_PWD_PROMPT_INFO@importBundle@servletRequest"
													 styleClass="OraInstructionText"/>
													  </uix:case>
												</uix:switcher>
                                           </uix:contents>
                                         </uix:rowLayout>
                                         <uix:spacer width="10" height="10"/>
                                         <uix:rowLayout>
                                           <uix:contents>
                                             <uix:labeledFieldLayout>
                                               <uix:contents>
                                                 <uix:messageTextInput secret="true" promptBinding="KEY@importBundle@servletRequest"
																
name="encryptionKey" textBinding="encryptionKey@importBean@servletRequest" vAlign="middle"/>
                                                 <uix:spacer width="10" height="10"/>
                                               </uix:contents>
                                             </uix:labeledFieldLayout>
                                           </uix:contents>
                                         </uix:rowLayout>
                                       </uix:contents>
                                     </uix:cellFormat>
                                   </uix:contents>
                                 </uix:rowLayout>
                               </uix:contents>
                             </uix:tableLayout>
                           </uix:contents>
                        </uix:header>

  </uix:case>
                          </uix:switcher>

 <%-- end Encryption Option  section --%>
 
 
                  <uix:hideShow disclosedBinding="showAdvancedOptions@importBean@servletRequest"
                                formSubmitted="true" id="hideShow"
                                disclosedTextBinding="HIDE_ADVANCED_OPTIONS@exportBundle@servletRequest"
                                undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@exportBundle@servletRequest">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>

<%-- don't allow the user to turn off estimate; per server group
                          <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
                            <uix:case name="true">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:checkBox textBinding="ESTIMATE_NONE@importBundle@servletRequest" name="dontEstimateDiskSpace" 
                                                checkedBinding="dontEstimateDiskSpace@importBean@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:spacer width="20"/> 
                                      <uix:styledText styleClass="OraInlineInfoText" textBinding="ESTIMATE_NONE_TEXT@exportBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:rowLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:case>
                          </uix:switcher>
--%>

                          <uix:header textBinding="CONTENT@exportBundle@servletRequest" size="1">
                            <uix:stackLayout>
                              <uix:contents>

                                <uix:labeledFieldLayout labelWidth="30%"> 
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText" textBinding="CONTENT_TEXT@importBundle@servletRequest"/>
                                    <oem:radioButton
                                              name="contentType"
                                              selectedValueBinding="contentType@importBean@servletRequest"
                                              textBinding="ALL@exportBundle@servletRequest"
                                              value="ALL"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="ALL_TEXT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <oem:radioButton
                                                  name="contentType"
                                                  selectedValueBinding="contentType@importBean@servletRequest"
                                                  textBinding="DATA_ONLY@exportBundle@servletRequest"
                                                  value="DATA_ONLY"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="DATA_ONLY_TEXT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>

                                        <oem:radioButton
                                                  name="contentType"
                                                  selectedValueBinding="contentType@importBean@servletRequest"
                                                  textBinding="METADATA_ONLY@exportBundle@servletRequest"
                                                  value="METADATA_ONLY"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/>
                                              <uix:styledText styleClass="OraInlineInfoText" textBinding="METADATA_ONLY_TEXT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:contents>
                                </uix:labeledFieldLayout>  
                                <uix:labeledFieldLayout labelWidth="15%"> 
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText" textBinding="ASSOCIATED_OBJECTS_LABEL@importBundle@servletRequest"/>
                                    <oem:radioButton
                                              name="associatedObjectsType"
                                              selectedValueBinding="associatedObjectsType@importBean@servletRequest"
                                              textBinding="ASSOCIATED_OBJECTS_ALL@exportBundle@servletRequest"
                                              value="ALL"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <oem:radioButton
                                              name="associatedObjectsType"
                                              selectedValueBinding="associatedObjectsType@importBean@servletRequest"
                                              textBinding="INCLUDE@exportBundle@servletRequest"
                                              value="INCLUDE"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <oem:radioButton
                                              name="associatedObjectsType"
                                              selectedValueBinding="associatedObjectsType@importBean@servletRequest"
                                              textBinding="EXCLUDE@exportBundle@servletRequest"
                                              value="EXCLUDE"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <uix:tableLayout>
                                      <uix:rowLayout>
                                        <oem:table name="associatedObjectsTableUI"
                                                 beanKey="importBean"
                                                 textBinding="ASSOCIATED_OBJECTS_TABLE_HEADER@exportBundle@servletRequest"
                                                 summaryBinding="ASSOCIATED_OBJECTS_TABLE_HEADER@exportBundle@servletRequest"
                                                 destination="/console/database/data/export"
                                                 formSubmitted="true"
                                                 dataSourceProp="associatedObjectsTableUI"
                                                 alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
                                          <uix:tableSelection>
                                            <uix:singleSelection 
                                                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                                selectedIndexBinding="selectedIndex@associatedObjectsTableDS@importBean@servletRequest">
                                              <uix:submitButton
                                                  shortDescBinding="REMOVE@exportBundle@servletRequest"
                                                  textBinding="REMOVE@exportBundle@servletRequest"
                                                  name="event" 
                                                  value="deleteAssociatedObject"
                                                  disabledBinding="disableMultipleFilesMode@importBean@servletRequest"/>
                                            </uix:singleSelection>
                                          </uix:tableSelection>
                                          <uix:footer>
                                            <uix:submitButton
                                                shortDescBinding="ADD_FILE@exportBundle@servletRequest"
                                                textBinding="ADD_FILE@exportBundle@servletRequest"
                                                name="event" 
                                                value="addAssociatedObject"
                                                disabledBinding="disableMultipleFilesMode@importBean@servletRequest"/>
                                          </uix:footer>
                                        </oem:table>
                                      </uix:rowLayout>
                                      <uix:rowLayout>
                                        <uix:styledText styleClass="OraInlineInfoText" textBinding="OBJECT_NAME_HINT@exportBundle@servletRequest"/>
                                      </uix:rowLayout>
                                      <uix:rowLayout>
                                        <uix:messageText messageType="error" messageBinding="AssociatedObjects@errors@servletRequest"/>
                                      </uix:rowLayout>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:labeledFieldLayout>  

                              </uix:contents>
                            </uix:stackLayout>
                          </uix:header>

                          <uix:header textBinding="OBJECT_ACTIONS_HEADER@exportBundle@servletRequest" size="1">
                            <uix:stackLayout>
                              <uix:contents>

                                <uix:labeledFieldLayout labelWidth="25%"> 
                                  <uix:contents>
                                    <uix:checkBox textBinding="TABLE_EXISTS@importBundle@servletRequest" 
                                          name="tableExistsActionCheck" checkedBinding="tableExistsActionCheck@importBean@servletRequest"/>
                                    <oem:radioButton
                                              name="tableExistsAction"
                                              selectedValueBinding="tableExistsAction@importBean@servletRequest"
                                              textBinding="TABLE_EXISTS_SKIP@importBundle@servletRequest"
                                              value="SKIP"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/> 
                                            <uix:styledText styleClass="OraInlineInfoText" textBinding="TABLE_EXISTS_SKIP_HINT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <oem:radioButton
                                                  name="tableExistsAction"
                                                  selectedValueBinding="tableExistsAction@importBean@servletRequest"
                                                  textBinding="TABLE_EXISTS_APPEND@importBundle@servletRequest"
                                                  value="APPEND"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/> 
                                            <uix:styledText styleClass="OraInlineInfoText" textBinding="TABLE_EXISTS_APPEND_HINT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <oem:radioButton
                                                  name="tableExistsAction"
                                                  selectedValueBinding="tableExistsAction@importBean@servletRequest"
                                                  textBinding="TABLE_EXISTS_TRUNCATE@importBundle@servletRequest"
                                                  value="TRUNCATE"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/> 
                                            <uix:styledText styleClass="OraInlineInfoText" textBinding="TABLE_EXISTS_TRUNCATE_HINT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <oem:radioButton
                                                  name="tableExistsAction"
                                                  selectedValueBinding="tableExistsAction@importBean@servletRequest"
                                                  textBinding="TABLE_EXISTS_REPLACE@importBundle@servletRequest"
                                                  value="REPLACE"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/> 
                                            <uix:styledText styleClass="OraInlineInfoText" textBinding="TABLE_EXISTS_REPLACE_HINT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:contents>
                                </uix:labeledFieldLayout>  

                                <uix:switcher childNameBinding="typeFull@importBean@servletRequest">
                                  <uix:case name="true">
                                    <uix:stackLayout>
                                      <uix:contents>
                                        <uix:checkBox textBinding="OVERWRITE_DATA_FILES@importBundle@servletRequest" 
                                          name="destroy" checkedBinding="destroy@importBean@servletRequest"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/> 
                                            <uix:styledText styleClass="OraInlineInfoText" textBinding="OVERWRITE_DATA_FILES_HINT@importBundle@servletRequest"/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:case>
                                </uix:switcher>

                                <uix:checkBox textBinding="SKIP_UNUSABLE_INDEXES@importBundle@servletRequest" 
                                  name="skipUnusableIndexes" checkedBinding="skipUnusableIndexes@importBean@servletRequest"/>     

                                <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
                                  <uix:case name="true">
                                    <uix:stackLayout>
                                      <uix:contents>

                                        <uix:checkBox textBinding="EXPORT_READ_CONSISTENT_VIEW@importBundle@servletRequest" name="readConsistent" checkedBinding="readConsistent@importBean@servletRequest"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:spacer width="20"/> 
                                            <uix:stackLayout>
                                              <uix:contents>
                                                <oem:radioButton
                                                            name="exportConsistentType"
                                                            selectedValueBinding="exportConsistentType@importBean@servletRequest"
                                                            textBinding="AS_SPECIFIED_SCN@exportBundle@servletRequest"
                                                            value="FLASHBACK_SCN"/>
                                                <uix:labeledFieldLayout labelWidth="30%"> 
                                                  <uix:contents>
                                                    <uix:styledText styleClass="OraInstructionText" labeledNodeId="flashbackScn"
                                                        textBinding="SYSTEM_CHANGE_NUMBER@exportBundle@servletRequest"/>
                                                    <uix:stackLayout>
                                                      <uix:textInput name="flashbackScn" id="flashbackScn"
                                                          textBinding="flashbackScn@importBean@servletRequest" columns="20"/>
                                                      <uix:messageText messageType="error" messageBinding="FlashbackScn@errors@servletRequest"/>
                                                    </uix:stackLayout>
                                                  </uix:contents>
                                                </uix:labeledFieldLayout>  
                                                <oem:radioButton
                                                            name="exportConsistentType"
                                                            selectedValueBinding="exportConsistentType@importBean@servletRequest"
                                                            textBinding="AS_SCN_MATCHING_TIME@exportBundle@servletRequest"
                                                            value="FLASHBACK_TIME"/>
                                                <uix:labeledFieldLayout labelWidth="30%">
                                                  <uix:contents>
                                                    <uix:styledText labeledNodeId="flashbackTimeDate" styleClass="OraInstructionText" textBinding="DATE@exportBundle@servletRequest"/>
                                                    <uix:dateField name="flashbackTimeDate" id="flashbackTimeDate" columns="16" valueBinding="flashbackTimeDate@importBean@servletRequest">
                                                      <uix:onSubmitValidater>
                                                        <uix:date dateStyle="long"/>
                                                      </uix:onSubmitValidater>
                                                    </uix:dateField>
                                                    <uix:styledText styleClass="OraInstructionText" textBinding="TIME@exportBundle@servletRequest"/>
                                                    <uix:rowLayout>
                                                      <uix:choice
                                                        name="flashbackTimeHour"
                                                        shortDescBinding="timeHour@importBean@servletRequest"
                                                        selectedValueBinding="flashbackTimeHour@importBean@servletRequest">
                                                        <uix:option text="01" value="01"/>
                                                        <uix:option text="02" value="02"/>
                                                        <uix:option text="03" value="03"/>
                                                        <uix:option text="04" value="04"/>
                                                        <uix:option text="05" value="05"/>
                                                        <uix:option text="06" value="06"/>
                                                        <uix:option text="07" value="07"/>
                                                        <uix:option text="08" value="08"/>
                                                        <uix:option text="09" value="09"/>
                                                        <uix:option text="10" value="10"/>
                                                        <uix:option text="11" value="11"/>
                                                        <uix:option text="12" value="00"/>
                                                      </uix:choice>
                                                      <uix:choice
                                                        name="flashbackTimeMinute"
                                                        shortDescBinding="timeMinute@importBean@servletRequest"
                                                        selectedValueBinding="flashbackTimeMinute@importBean@servletRequest">
                                                        <uix:option text="00" value="00"/>
                                                        <uix:option text="05" value="05"/>
                                                        <uix:option text="10" value="10"/>
                                                        <uix:option text="15" value="15"/>
                                                        <uix:option text="20" value="20"/>
                                                        <uix:option text="25" value="25"/>
                                                        <uix:option text="30" value="30"/>
                                                        <uix:option text="35" value="35"/>
                                                        <uix:option text="40" value="40"/>
                                                        <uix:option text="45" value="45"/>
                                                        <uix:option text="50" value="50"/>
                                                        <uix:option text="55" value="55"/>
                                                      </uix:choice>
                                                      <oem:radioButton
                                                        name="flashbackTimeAmPm"
                                                        selectedValueBinding="flashbackTimeAmPm@importBean@servletRequest"
                                                        text="AM"
                                                        value="AM"/>
                                                      <oem:radioButton
                                                        name="flashbackTimeAmPm"
                                                        selectedValueBinding="flashbackTimeAmPm@importBean@servletRequest"
                                                        text="PM"
                                                        value="PM"/>
                                                      </uix:rowLayout>  
                                                  </uix:contents>
                                                    
                                                </uix:labeledFieldLayout>
                                              </uix:contents>
                                            </uix:stackLayout>
                                          </uix:contents>
                                        </uix:rowLayout>

<%--
per server team comments, remove access method
                                        <uix:tableLayout>
                                          <uix:rowLayout>
                                            <uix:styledText styleClass="OraInstructionText" textBinding="ACCESS_METHOD_TEXT@exportBundle@servletRequest"/>
                                            <uix:stackLayout>
                                              <uix:contents>
                                                <oem:radioButton
                                                          name="accessMethodType"
                                                          selectedValueBinding="accessMethodType@importBean@servletRequest"
                                                          textBinding="AUTOMATIC@exportBundle@servletRequest"
                                                          value="AUTOMATIC"/>
                                              </uix:contents>
                                            </uix:stackLayout>
                                          </uix:rowLayout>
                                          <uix:rowLayout>
                                            <uix:cellFormat>
                                            </uix:cellFormat>
                                            <uix:stackLayout>
                                              <uix:contents>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:spacer width="20"/>
                                                      <uix:styledText styleClass="OraInlineInfoText" textBinding="AUTOMATIC_TEXT@importBundle@servletRequest"/>
                                                  </uix:contents>
                                                </uix:rowLayout>

                                                <oem:radioButton
                                                          name="accessMethodType"
                                                          selectedValueBinding="accessMethodType@importBean@servletRequest"
                                                          textBinding="DIRECT_PATH@exportBundle@servletRequest"
                                                          value="DIRECT_PATH"/>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:spacer width="20"/>
                                                      <uix:styledText styleClass="OraInlineInfoText" textBinding="DIRECT_PATH_TEXT@importBundle@servletRequest"/>
                                                  </uix:contents>
                                                </uix:rowLayout>

                                                <oem:radioButton
                                                          name="accessMethodType"
                                                          selectedValueBinding="accessMethodType@importBean@servletRequest"
                                                          textBinding="EXTERNAL_TABLE@exportBundle@servletRequest"
                                                          value="EXTERNAL_TABLE"/>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:spacer width="20"/>
                                                      <uix:styledText styleClass="OraInlineInfoText" textBinding="EXTERNAL_TABLE_TEXT@importBundle@servletRequest"/>
                                                  </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                            </uix:stackLayout>
                                          </uix:rowLayout>
                                        </uix:tableLayout>
per server team comments, remove access method
--%>

                                      </uix:contents>
                                    </uix:stackLayout>
                                  </uix:case>
                                 </uix:switcher>

                              </uix:contents>
                            </uix:stackLayout>
                          </uix:header>

                          <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
                            <uix:case name="true">
                              <uix:header textBinding="QUERY@exportBundle@servletRequest" size="1">
                                <uix:stackLayout>
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInlineInfoText" textBinding="FILTER_TEXT@importBundle@servletRequest"/>
                                    <uix:tableLayout>
                                      <uix:rowLayout>
                                        <oem:table name="filterDataTableUI"
                                                 beanKey="importBean"
                                                 destination="/console/database/data/import"
                                                 summaryBinding="QUERY@exportBundle@servletRequest"
                                                 formSubmitted="true"
                                                 dataSourceProp="filterDataTableUI"
                                                 alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
                                          <uix:tableSelection>
                                            <uix:singleSelection 
                                                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                                selectedIndexBinding="selectedIndex@filterDataTableDS@importBean@servletRequest">
                                              <uix:submitButton
                                                  shortDescBinding="REMOVE@exportBundle@servletRequest"
                                                  textBinding="REMOVE@exportBundle@servletRequest"
                                                  name="event" 
                                                  value="deleteFilterData"/>
                                              <uix:submitButton
                                                  shortDescBinding="EDIT@DBObjectBundle@servletRequest"
                                                  textBinding="EDIT@DBObjectBundle@servletRequest"
                                                  name="event" 
                                                  value="editFilterData"/>
                                            </uix:singleSelection>
                                          </uix:tableSelection>
                                          <uix:footer>
                                            <uix:submitButton
                                                  shortDescBinding="ADD@DBObjectBundle@servletRequest"
                                                  textBinding="ADD@DBObjectBundle@servletRequest"
                                                  name="event" 
                                                value="addFilterData"/>
                                          </uix:footer>
                                        </oem:table>
                                      </uix:rowLayout>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:header>
                            </uix:case>
                          </uix:switcher>

                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:hideShow>

                </uix:contents>
              </uix:stackLayout>
            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="importForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="importForm"
                    maxValueBinding="navMaxValue@importBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@importBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
