<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="importAdvancedFiles10i">

  <uix:header textBinding="OPTIONAL_FILES@exportBundle@servletRequest" size="1">
    <uix:tableLayout cellSpacing="5">
      <uix:contents>

        <uix:stackLayout>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:checkBox name="generateLogFile" checkedBinding="generateLogFile@importBean@servletRequest" textBinding="GENERATE_LOG_FILE@exportBundle@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer width="20"/> 
              <uix:stackLayout>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:labeledFieldLayout labelWidth="20%">
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" labeledNodeId="logDirectoryObject" textBinding="FILE_DIRECTORY@exportBundle@servletRequest"/>
                        <uix:stackLayout>

                          <uix:rowLayout>
                            <uix:contents>
                              <uix:choice name="logDirectoryObject" id="logDirectoryObject"
                                      selectedValueBinding="logDirectoryObject@importBean@servletRequest">
                                <uix:contents childDataBinding="allDirectoryObjects@importBean@servletRequest">
                                  <uix:option textBinding="."/>
                                </uix:contents>
                              </uix:choice>
                              <uix:spacer width="5"/>
                              <uix:submitButton
                                  shortDescBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest"
                                  textBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest"
                                  formName="importForm"
                                  name="event"
                                  value="createDirObject"/>
                            </uix:contents>
                          </uix:rowLayout>

                          <uix:messageText messageType="error" messageBinding="DirectoryObject@errors@servletRequest"/>
                        </uix:stackLayout>
                        <uix:styledText styleClass="OraInstructionText" labeledNodeId="logFileName" 
                            textBinding="LOG_FILE@exportBundle@servletRequest"/>
                        <uix:stackLayout>
                          <uix:textInput name="logFileName" id="logFileName" 
                              textBinding="logFileName@importBean@servletRequest" columns="60"/>
                          <uix:messageText messageType="error" messageBinding="LogFile@errors@servletRequest"/>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:labeledFieldLayout>  
                  </uix:contents>
                </uix:rowLayout>
              </uix:stackLayout>
            </uix:contents>
          </uix:rowLayout>

<%-- bug 2964680; server team says Generate SQL File for Network mode is postpopned until v-next
          <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
            <uix:case name="false">
              <uix:stackLayout>
                <uix:contents>
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:checkBox name="generateSqlFile" checkedBinding="generateSqlFile@importBean@servletRequest" textBinding="GENERATE_SQL_FILE@importBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="20"/> 
                      <uix:stackLayout>
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="GENERATE_SQL_FILE_TEXT@importBundle@servletRequest"/>
                        <uix:rowLayout>
                          <uix:contents>

                            <uix:labeledFieldLayout labelWidth="20%">
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText" labeledNodeId="sqlDirectoryObject" textBinding="FILE_DIRECTORY@exportBundle@servletRequest"/>
                                <uix:stackLayout>

                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:choice name="sqlDirectoryObject" id="sqlDirectoryObject"
                                              selectedValueBinding="sqlDirectoryObject@importBean@servletRequest">
                                        <uix:contents childDataBinding="allDirectoryObjects@importBean@servletRequest">
                                          <uix:option textBinding="."/>
                                        </uix:contents>
                                      </uix:choice>
                                      <uix:spacer width="5"/>
                                      <uix:submitButton
                                          shortDescBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest"
                                          textBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest"
                                          formName="importForm"
                                          name="event"
                                          value="createDirObject"/>
                                    </uix:contents>
                                  </uix:rowLayout>

                                  <uix:messageText messageType="error" messageBinding="DirectoryObject@errors@servletRequest"/>
                                </uix:stackLayout>
                                <uix:styledText styleClass="OraInstructionText" labeledNodeId="sqlFileName"
                                    textBinding="SQL_FILE@importBundle@servletRequest"/>
                                <uix:stackLayout>
                                  <uix:textInput name="sqlFileName" id="sqlFileName" textBinding="sqlFileName@importBean@servletRequest" columns="60"/>
                                  <uix:messageText messageType="error" messageBinding="SqlFile@errors@servletRequest"/>
                                </uix:stackLayout>
                              </uix:contents>
                            </uix:labeledFieldLayout>  
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>
--%>
        </uix:stackLayout>

      </uix:contents>
    </uix:tableLayout>
  </uix:header>

</uix:buildTree>
