<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="AVAILABLE_TABLES@exportBundle@servletRequest"/>

      <script language="JavaScript">
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>
      <script>
        function filterTableSelect(tableField)
        {
          var proxy = new TableProxy('availTableTable');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var tableElement = proxy.getFormElement('3', selectedIndex);
            var schemaElement = proxy.getFormElement('2', selectedIndex);
            tableField.value = schemaElement.value + "." + tableElement.value;
            window.close();
          }
        }
      </script>            
    </uix:metaContainer>   

    <uix:body>
      <db:form name="importForm" method="post" copyParams="target,type,cancelURL"
        destination="/console/database/data/import">

      <uix:formValue 
            name="pageName" 
            value="/database/data/importAvailableTable"/>

      <uix:contents>
        <uix:pageLayout titleBinding="AVAILABLE_TABLES@exportBundle@servletRequest">

          <uix:header
            textBinding="SEARCH@DBObjectBundle@servletRequest">
            <uix:stackLayout>

              <%-- Use different text for different types of objects --%>
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText"
                          textBinding="ENTER_OBJECT_NAME@DBObjectBundle@servletRequest"/>
              </uix:rowLayout>

              <uix:labeledFieldLayout labelWidth="10%">
                <uix:styledText labeledNodeId="userSearchFilter"
                        textBinding="SCHEMA@DBObjectBundle@servletRequest"/>
                <uix:textInput name="userSearchFilter" id="userSearchFilter"
                        readOnlyBinding="userSearchFilterReadOnly@importBean@servletRequest"
                        textBinding="userSearchFilter@importAvailTablesTableBean@servletRequest"/>
                <uix:styledText labeledNodeId="tableSearchFilter"
                        textBinding="TABLE@DBObjectBundle@servletRequest"/>
                <uix:textInput name="tableSearchFilter" id="tableSearchFilter"
                        textBinding="tableSearchFilter@importAvailTablesTableBean@servletRequest"/>
                <uix:styledText text=""/>
                <uix:submitButton 
                        shortDescBinding="GO@DBObjectBundle@servletRequest"
                        textBinding="GO@DBObjectBundle@servletRequest"
                        onFocus="true"
                        selected="true" name="event" value="search"/>
              </uix:labeledFieldLayout>

            </uix:stackLayout>
          </uix:header>

          <%-------------------------
           -  Available Tables Table
           ---------------------------%>

          <uix:header 
            textBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
            >
            <oem:table 
              width="80%" 
              blockSize="10"
              formSubmitted="true"
              summaryBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
              name="availTableTable" 
              beanKey="importAvailTablesTableBean"
              dataSourceProp="availTableTable"
              alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest"
              >
              <uix:tableSelection>
                <uix:singleSelection 
                    shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                    selectedIndex="0"/>
              </uix:tableSelection>
            </oem:table>
          </uix:header>

          <%-------------------------
         -  PageButtons
         ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:button
                shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                textBinding="CANCEL@DBObjectBundle@servletRequest"
                destination="javascript:self.close()"/>
              <uix:button
                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                textBinding="SELECT@DBObjectBundle@servletRequest"
                destinationBinding="selectFilterTableDestination@servletRequest"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </uix:contents>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

