<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="availableUsersPageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="selectUserForm" method="post" copyParams="target,type,cancelURL"
      destination="/console/database/data/import">

      <uix:formValue 
          name="pageName" 
          value="/database/data/importAvailableUsers"/>

      <uix:pageLayout
        titleBinding="availableUsersPageHeader@importBean@servletRequest"
        >

        <%@ include file="/database/global.jspf" %>

        <%-- Train must be within pageLayout location child to display above title --%>
        <uix:location>
          <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
            <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
        </uix:location>

<uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

        <%-- Use the pageStatus tag to provide page context (target name) --%>
        <uix:pageStatus>
          <uix:labeledFieldLayout labelWidth="10%">
            <uix:contents>
              <uix:messagePrompt
                  promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
              <uix:styledText
                 styleClass="OraDataText"
                 textBinding="targetDBName@importBean@servletRequest"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:pageStatus>

        <uix:separator/>

        <%-------------------------
         -  Search Filter
         ---------------------------%>
        <uix:header
          textBinding="SEARCH@DBObjectBundle@servletRequest">
          <uix:stackLayout>

            <%-- Use different text for different types of objects --%>
            <uix:rowLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText" 
                  textBinding="ENTER_OBJECT_NAME@DBObjectBundle@servletRequest"/>
                <uix:cellFormat>
                  <uix:contents>
                    <uix:spacer width="5"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:contents>
            </uix:rowLayout>

            <%-- Display the object name --%>
            <uix:labeledFieldLayout labelWidth="20%"> 
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText" labeledNodeId="searchFilter"
                  textBinding="USER@exportBundle@servletRequest"/>
                <uix:textInput name="searchFilter" id="searchFilter"
                  textBinding="searchFilter@importAvailUsersTableBean@servletRequest"/>
                <uix:styledText styleClass="OraInlineInfoText" text=""/>
                <uix:submitButton 
                  shortDescBinding="GO@DBObjectBundle@servletRequest"
                  textBinding="GO@DBObjectBundle@servletRequest"
                  onFocus="true"
                  selected="true" name="event" value="search"/>
              </uix:contents>
            </uix:labeledFieldLayout>  

          </uix:stackLayout>
        </uix:header>

        <%-------------------------
         -  Available Users Table
         ---------------------------%>

        <uix:header 
          textBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
          >

          <oem:table 
            width="80%" 
            blockSize="10"
            formSubmitted="true"
            summaryBinding="SEARCH_RESULTS@DBObjectBundle@servletRequest"
            name="availUserTable" 
            beanKey="importAvailUsersTableBean"
            dataSourceProp="availUserTable"
            alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest"
            >
            <uix:tableSelection>
              <uix:multipleSelection
                selectionBinding="selection@importAvailUsersTableBean@servletRequest"
                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                selectedBinding="selected"/>
            </uix:tableSelection>
          </oem:table>
        </uix:header>

        <%-------------------------
         -  PageButtons
         ---------------------------%>
        <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event" 
              shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
              textBinding="CANCEL@DBObjectBundle@servletRequest"
              value="cancelSelect"/>

            <uix:submitButton
              name="event" 
              shortDescBinding="SELECT@DBObjectBundle@servletRequest"
              textBinding="SELECT@DBObjectBundle@servletRequest"
              value="selectItems"/>

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

