<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="estimatePageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importEstimateResults"/>

          <uix:pageLayout titleBinding="estimatePageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>
            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:stackLayout>
              <uix:contents>
                <uix:spacer height="10"/>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:labeledFieldLayout labelWidth="180" fieldWidth="80" columns="1">
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" textBinding="ESTIMATE_TYPE@exportBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInstructionText" textBinding="estimateTypeLabel@importBean@servletRequest"/>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:labeledFieldLayout labelWidth="180" fieldWidth="80" columns="1">
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" textBinding="ESTIMATE_RESULT@exportBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInstructionText" textBinding="estimateResult@importBean@servletRequest"/>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton shortDescBinding="OK@DBObjectBundle@servletRequest" formName="importForm" textBinding="OK@DBObjectBundle@servletRequest" name="event" value="gotoAdvanced"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
