<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="filesPageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importFiles"/>

          <uix:pageLayout titleBinding="filesPageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
              <uix:case name="true">
                <%-- <uix:header textBinding="IMPORT_DBLINK@importBundle@servletRequest"> --%>
                  <uix:tableLayout cellSpacing="5">
                    <uix:contents>
                
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_IMPORT_DBLINK@importBundle@servletRequest"/>
                          <uix:labeledFieldLayout labelWidth="20%">
                            <uix:styledText styleClass="OraInstructionText" labeledNodeId="databaseLink" textBinding="IMPORT_DBLINK_TEXT@importBundle@servletRequest"/>
                            <uix:stackLayout>
                              <uix:rowLayout>
                                <uix:choice name="databaseLink" id="databaseLink" 
                                        selectedValueBinding="databaseLink@importBean@servletRequest">
                                  <uix:contents childDataBinding="allDatabaseLinks@importBean@servletRequest">
                                    <uix:option textBinding="."/>
                                  </uix:contents>
                                </uix:choice>
                                <uix:spacer width="5"/>
                                <uix:submitButton
                                    shortDescBinding="DBLINK_CREATE_LABEL@importBundle@servletRequest"
                                    textBinding="DBLINK_CREATE_LABEL@importBundle@servletRequest"
                                    formName="importForm"
                                    name="event"
                                    value="createDBLink"/>
                              </uix:rowLayout>
                              <uix:messageText messageType="error" messageBinding="DatabaseLink@errors@servletRequest"/>
                            </uix:stackLayout>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:stackLayout>

                    </uix:contents>
                  </uix:tableLayout>
                <%-- </uix:header> --%>
              </uix:case>
              <uix:case name="false">
                <uix:stackLayout>
                  <uix:contents>

                    <uix:switcher childNameBinding="showPre10iChoice@importBean@servletRequest">
                      <uix:case name="true">
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:labeledFieldLayout labelWidth="30%">
                              <uix:styledText styleClass="OraInstructionText" labeledNodeId="fileVersion" textBinding="PRE10I_TEXT@importBundle@servletRequest"/>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:choice name="fileVersion" id="fileVersion" 
                                          selectedValueBinding="fileVersion@importBean@servletRequest">
                                    <uix:contents>
                                      <uix:option textBinding="PRE10I_10I_OR_LATER@importBundle@servletRequest"/>
                                      <uix:option textBinding="PRE10I_PRIOR_TO_10I@importBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:choice>
                                </uix:contents>
                                <uix:submitButton
                                    shortDescBinding="GO@DBObjectBundle@servletRequest"
                                    textBinding="GO@DBObjectBundle@servletRequest"
                                    name="event"
                                    value="setFileVersion"/>
                              </uix:rowLayout>
                              <uix:styledText styleClass="OraInlineInfoText" text=""/>
                              <uix:styledText styleClass="OraInlineInfoText" textBinding="PRE10I_HINT@importBundle@servletRequest"/>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:case>
                    </uix:switcher>

                    <uix:header textBinding="FILES@exportBundle@servletRequest">
                      <uix:tableLayout cellSpacing="5">
                        <uix:contents>
                          <uix:stackLayout>
                            <uix:switcher childNameBinding="DB10orHigher@importBean@servletRequest">
                              <uix:case name="true">

                                <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
                                  <uix:case name="true">
                                    <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_IMPORT_FILES_10I@importBundle@servletRequest"/>
                                  </uix:case>
                                  <uix:case name="false">
                                    <uix:tableLayout width="100%">
                                      <uix:rowLayout>
                                        <uix:cellFormat hAlign="left" width="80%">
                                          <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_IMPORT_FILES_10I@importBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:spacer width="5"/>
                                        <uix:cellFormat hAlign="right" width="20%">
                                          <uix:submitButton
                                              shortDescBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest"
                                              textBinding="DIRECTORY_OBJECT_CREATE_LABEL@exportBundle@servletRequest"
                                              formName="importForm"
                                              name="event"
                                              value="createDirObject"/>
                                        </uix:cellFormat>
                                      </uix:rowLayout>
                                    </uix:tableLayout>
                                  </uix:case>
                                </uix:switcher>

                              </uix:case>
                              <uix:case name="false">
                                <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_IMPORT_FILES@importBundle@servletRequest"/>
                              </uix:case>
                            </uix:switcher>

                            <uix:tableLayout width="100%">
                              <uix:switcher childNameBinding="DB10orHigher@importBean@servletRequest">
                                <uix:case name="false">
                                  <uix:rowLayout hAlign="right">
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:submitButton
                                              shortDescBinding="REORDER@exportBundle@servletRequest"
                                              textBinding="REORDER@exportBundle@servletRequest"
                                              name="event"
                                              value="reorderFiles"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:rowLayout>
                                </uix:case>
                              </uix:switcher>

                              
                              <oem:table name="filesTableUI"
                                       beanKey="importBean"
                                       destination="/console/database/data/import"
                                       summaryBinding="IMPORT_FILES@importBundle@servletRequest"
                                       formSubmitted="true"
                                       dataSourceProp="filesTableUI"
                                       width="100%">
                                <uix:tableSelection>
                                  <oem:singleSelection 
                                      shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                      selectedIndexBinding="selectedIndex@filesTableDS@importBean@servletRequest">
                                    <uix:submitButton
                                        shortDescBinding="REMOVE@exportBundle@servletRequest"
                                        textBinding="REMOVE@exportBundle@servletRequest"
                                        name="event"
                                        value="deleteImportFile"/>
                                  </oem:singleSelection>
                                </uix:tableSelection>
                                <uix:footer>
                                  <uix:submitButton
                                      shortDescBinding="ADD_FILE@exportBundle@servletRequest"
                                      textBinding="ADD_FILE@exportBundle@servletRequest"
                                      name="event"
                                      value="addImportFile"/>
                                </uix:footer>
                              </oem:table>
                            
                              <uix:messageText messageType="error" messageBinding="ImportFile@errors@servletRequest"/>
                            </uix:tableLayout>
                            <%--  <oem:messageText errorTableKey="errors" errorKey="datafilesTable" messageType="error"/>  --%>

                            <uix:switcher childNameBinding="DB10orHigher@importBean@servletRequest">
                              <uix:case name="true">
                                <uix:styledText styleClass="OraInlineInfoText" textBinding="FILE_TABLE_HINT@importBundle@servletRequest"/>
                              </uix:case>
                            </uix:switcher>

                          </uix:stackLayout>
                        </uix:contents>
                      </uix:tableLayout>
                    </uix:header>

                  </uix:contents>
                </uix:stackLayout>
              </uix:case>
            </uix:switcher>

            <uix:header textBinding="IMPORT_TYPE@importBundle@servletRequest">
              <uix:switcher childNameBinding="DB10orHigher@importBean@servletRequest">
                <uix:case name="true">

                    <uix:stackLayout>
                      <uix:contents>

                        <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
                          <uix:case name="true">
                            <uix:stackLayout>
                              <uix:contents>
                                <oem:radioButton
                                          name="importType"
                                          selectedValueBinding="importType@importBean@servletRequest"
                                          selected="true"
                                          textBinding="DATABASE@exportBundle@servletRequest"
                                          value="FULL"/>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer width="20"/> 
                                    <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_DATABASE_FILE@importBundle@servletRequest"/>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:case>
                          <uix:case name="false">
                            <oem:radioButton
                                      name="importType"
                                      selectedValueBinding="importType@importBean@servletRequest"
                                      selected="true"
                                      textBinding="ENTIRE_FILE@importBundle@servletRequest"
                                      value="FULL"/>
                          </uix:case>
                        </uix:switcher>

                        <oem:radioButton
                                  name="importType"
                                  selectedValueBinding="importType@importBean@servletRequest"
                                  selected="false"
                                  textBinding="USER@exportBundle@servletRequest"
                                  value="USER"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_USER_FILE@importBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                        <oem:radioButton
                                  name="importType"
                                  selectedValueBinding="importType@importBean@servletRequest"
                                  selected="false"
                                  textBinding="TABLE@exportBundle@servletRequest"
                                  value="TABLE"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_TABLE_FILE_10I@importBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                        <oem:radioButton
                                  name="importType"
                                  selectedValueBinding="importType@importBean@servletRequest"
                                  selected="true"
                                  textBinding="TABLESPACE@exportBundle@servletRequest"
                                  value="TABLESPACES"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_TABLESPACE_FILE@importBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>

<%-- comment out transport tablespaces for now
                        <oem:radioButton
                                  name="importType"
                                  disabled="true"
                                  selectedValueBinding="importType@importBean@servletRequest"
                                  selected="true"
                                  textBinding="TRANSPORT_TABLESPACE@exportBundle@servletRequest"
                                  value="TRANSPORT_TABLESPACE"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer width="20"/> 
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_TRANSPORT_TABLESPACE_FILE@importBundle@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
--%>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:case>
                  <uix:case name="false">

                  <uix:stackLayout>
                    <uix:contents>
                      <oem:radioButton
                                name="manualEditingMode"
                                selectedValueBinding="manualEditingMode@importBean@servletRequest"
                                selected="true"
                                textBinding="ENTIRE_FILE@importBundle@servletRequest"
                                value="FULL"/>

                      <oem:radioButton
                                name="manualEditingMode"
                                selectedValueBinding="manualEditingMode@importBean@servletRequest"
                                textBinding="IMPORT_CHOICE_MANUAL@importBundle@servletRequest"
                                value="YES"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_CHOICE_MANUAL_DB_MORE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>

                      <oem:radioButton
                                name="manualEditingMode"
                                selectedValueBinding="manualEditingMode@importBean@servletRequest"
                                textBinding="IMPORT_CHOICE_READ_FILE@importBundle@servletRequest"
                                value="NO"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="20"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_CHOICE_READ_FILE_MORE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:case>
              </uix:switcher>
            </uix:header>

            <uix:header textBinding="HOST_CREDENTIALS@exportBundle@servletRequest" size="1">
              <uix:contents>
                <%@ include file="/credentials.jspf"%>
              </uix:contents>
            </uix:header>

            <uix:pageButtons> 
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="CONTINUE@DBObjectBundle@servletRequest" textBinding="CONTINUE@DBObjectBundle@servletRequest" formName="importForm" name="event" value="continue"/>
                <uix:contents>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons> 

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
