<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="summaryPageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importReview"/>

          <uix:pageLayout titleBinding="summaryPageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="REVIEW@exportBundle@servletRequest"> --%>
              <uix:switcher childNameBinding="DB10orHigher@importBean@servletRequest">
                <uix:case name="true">
                  <uix:switcher childNameBinding="networkMode@importBean@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:labeledFieldLayout labelWidth="40%">
                            <uix:contents>
                              <uix:messagePrompt promptBinding="IMPORT_TYPE@importBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryImportType@importBean@servletRequest"/>
                              <uix:messagePrompt promptBinding="IMPORT_DBLINK@importBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="databaseLink@importBean@servletRequest"/>
                              <uix:messagePrompt promptBinding="LOG_FILE@exportBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryLogFile@importBean@servletRequest"/>
                              <uix:messagePrompt promptBinding="PARALLELISM@exportBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="parallelism@importBean@servletRequest"/>
                              <uix:messagePrompt promptBinding="JOB_SCHEDULE@exportBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryScheduleType@importBean@servletRequest"/>
<%-- remove KEEP MASTER per server group commenmts
                              <uix:messagePrompt promptBinding="KEEP_MASTER@importBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryKeepMaster@importBean@servletRequest"/>
--%>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                          <uix:switcher childNameBinding="typeFull@importBean@servletRequest">
                            <uix:case name="true">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:labeledFieldLayout labelWidth="40%">
                                    <uix:contents>
                                      <uix:messagePrompt promptBinding="OVERWRITE_DATA_FILES@importBundle@servletRequest"/>
                                      <uix:styledText
                                          styleClass="OraDataText"
                                          textBinding="summaryDestroy@importBean@servletRequest"/>
                                    </uix:contents>
                                  </uix:labeledFieldLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:case>
                          </uix:switcher>
                          <uix:hideShow disclosedBinding="showParameters@importBean@servletRequest"
                                        formSubmitted="true" id="hideShow"
                                        disclosedTextBinding="HIDE_PLSQL@exportBundle@servletRequest"
                                        undisclosedTextBinding="SHOW_PLSQL@exportBundle@servletRequest">
                            <uix:contents>
                              <uix:messagePrompt labeledNodeId="parameterCommand" promptBinding="SUMMARY_DBL_PL_SQL@importBundle@servletRequest"/>
                              <uix:textInput name="parameterCommand" id="parameterCommand" rows="10" 
                                  textBinding="parameterCommand@importBean@servletRequest" columns="100"
                                  readOnly="true"/>
                            </uix:contents>
                          </uix:hideShow>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:labeledFieldLayout labelWidth="40%">
                            <uix:contents>
                              <uix:messagePrompt promptBinding="IMPORT_TYPE@importBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryImportType@importBean@servletRequest"/>
                              <uix:messagePrompt promptBinding="IMPORT_FILES@importBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryImportFiles@importBean@servletRequest"/>
                              <uix:messagePrompt promptBinding="LOG_FILE@exportBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryLogFile@importBean@servletRequest"/>
<%-- bug 2964680; server team says Generate SQL File for Network mode is postpopned until v-next
                              <uix:messagePrompt promptBinding="SQL_FILE@importBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summarySqlFile@importBean@servletRequest"/>
--%>
                              <uix:messagePrompt promptBinding="PARALLELISM@exportBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="parallelism@importBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="JOB_SCHEDULE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryScheduleType@importBean@servletRequest"/>
<%-- remove KEEP MASTER per server group commenmts
                              <uix:messagePrompt promptBinding="KEEP_MASTER@importBundle@servletRequest"/>
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="summaryKeepMaster@importBean@servletRequest"/>
--%>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                          <uix:switcher childNameBinding="typeFull@importBean@servletRequest">
                            <uix:case name="true">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:labeledFieldLayout labelWidth="40%">
                                    <uix:contents>
                                      <uix:messagePrompt promptBinding="OVERWRITE_DATA_FILES@importBundle@servletRequest"/>
                                      <uix:styledText
                                          styleClass="OraDataText"
                                          textBinding="summaryDestroy@importBean@servletRequest"/>
                                    </uix:contents>
                                  </uix:labeledFieldLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:case>
                          </uix:switcher>
                          <uix:hideShow disclosedBinding="showParameters@importBean@servletRequest"
                                        formSubmitted="true" id="hideShow"
                                        disclosedTextBinding="HIDE_PLSQL@exportBundle@servletRequest"
                                        undisclosedTextBinding="SHOW_PLSQL@exportBundle@servletRequest">
                            <uix:contents>
                              <uix:messagePrompt labeledNodeId="parameterCommand" promptBinding="SUMMARY_PL_SQL@importBundle@servletRequest"/>
                              <uix:textInput name="parameterCommand" id="parameterCommand" rows="10" 
                                  textBinding="parameterCommand@importBean@servletRequest" columns="100"
                                  readOnly="true"/>
                            </uix:contents>
                          </uix:hideShow>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:case>
                <uix:case name="false">
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:labeledFieldLayout labelWidth="40%">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="IMPORT_TYPE@importBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryImportType@importBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="IMPORT_FILES@importBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryImportFiles@importBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="LOG_FILE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryLogFile@importBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="FAIL_JOBS_ON_ERRORS@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryFailJobs@importBean@servletRequest"/>
                          <uix:messagePrompt promptBinding="JOB_SCHEDULE@exportBundle@servletRequest"/>
                          <uix:styledText
                              styleClass="OraDataText"
                              textBinding="summaryScheduleType@importBean@servletRequest"/>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                      <uix:switcher childNameBinding="typeFull@importBean@servletRequest">
                        <uix:case name="true">
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:labeledFieldLayout labelWidth="40%">
                                <uix:contents>
                                  <uix:messagePrompt promptBinding="OVERWRITE_DATA_FILES@importBundle@servletRequest"/>
                                  <uix:styledText
                                      styleClass="OraDataText"
                                      textBinding="summaryDestroy@importBean@servletRequest"/>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:case>
                      </uix:switcher>
                      <uix:hideShow disclosedBinding="showParameters@importBean@servletRequest"
                                    formSubmitted="true" id="hideShow"
                                    disclosedTextBinding="HIDE_PARAMETERS@exportBundle@servletRequest"
                                    undisclosedTextBinding="SHOW_PARAMETERS@exportBundle@servletRequest">
                        <uix:contents>
                          <uix:messagePrompt labeledNodeId="parameterCommand" promptBinding="SUMMARY_PARAMETERS@importBundle@servletRequest"/>
                          <uix:textInput name="parameterCommand" id="parameterCommand" rows="10" 
                              textBinding="parameterCommand@importBean@servletRequest" columns="100"
                              readOnly="true"/>
                        </uix:contents>
                      </uix:hideShow>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:case>
              </uix:switcher>

            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="importForm"
                    maxValueBinding="navMaxValue@importBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@importBean@servletRequest"/>
                </uix:contents>
                <uix:submitButton shortDescBinding="SUBMIT_JOB@exportBundle@servletRequest" formName="importForm" textBinding="SUBMIT_JOB@exportBundle@servletRequest" name="event" value="submit"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
