<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="schedulePageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importSchedule"/>

          <uix:pageLayout titleBinding="schedulePageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

         <%-- <uix:header textBinding="SCHEDULE@exportBundle@servletRequest"> --%>
          <uix:contents>
           <uix:stackLayout>
            <uix:contents>

	           <uix:tableLayout width="100%">
	            <uix:rowLayout>
	             <uix:styledText 	styleClass="OraInstructionText"
			  	      textBinding="JOB_TEXT@importBundle@servletRequest"/>
	            </uix:rowLayout>
	           </uix:tableLayout>

	           <%--.................. job ...................--%>	
	           <uix:header textBinding="JOB_PARAMETERS@exportBundle@servletRequest">
	            <uix:contents>

	             <uix:tableLayout width="100%">
	              <uix:rowLayout>
	               <uix:cellFormat hAlign="right" width="20%">
	                <uix:messagePrompt labeledNodeId="jobName" promptBinding="JOB_NAME@exportBundle@servletRequest"/>
	               </uix:cellFormat>
	                <uix:spacer width="5"/>
	               <uix:cellFormat hAlign="left" width="80%">
	                <uix:textInput name="jobName" id="jobName" columns="60"
			               textBinding="jobName@importBean@servletRequest"/>
	               </uix:cellFormat>
	              </uix:rowLayout>

	              <uix:rowLayout>
	               <uix:cellFormat hAlign="right" width="20%">
	                <uix:messagePrompt labeledNodeId="jobDescription" promptBinding="JOB_DESCRIPTION@exportBundle@servletRequest"/>
	               </uix:cellFormat>
	                <uix:spacer width="5"/>
	               <uix:cellFormat hAlign="left" width="80%">
	                <uix:textInput name="jobDescription" id="jobDescription"
			               textBinding="jobDescription@importBean@servletRequest"
			  	       columns="60" />
	               </uix:cellFormat>
	              </uix:rowLayout>
	             </uix:tableLayout>

	            </uix:contents>
	           </uix:header>

                 <%--...................... schedule .......................--%>
                 <uix:header textBinding="JOB_SCHEDULE@exportBundle@servletRequest">
                   <uix:switcher childNameBinding="canRepeatJob@importBean@servletRequest">
                     <uix:case name="true">
                       <%@ include file="/sdk/schedule/schedule.jspf" %>
                     </uix:case>
                     <uix:case name="false">
                       <%@ include file="/sdk/schedule/start.jspf" %>
                     </uix:case>
                   </uix:switcher>
                 </uix:header>

               </uix:contents>
              </uix:stackLayout>
             </uix:contents>
            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
<%--                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="importForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>  --%>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="importForm"
                    maxValueBinding="navMaxValue@importBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@importBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>
      
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
