<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="typePageTitle@importBean@servletRequest"/> 
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importTypeFile"/>

          <uix:pageLayout titleBinding="typePageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="IMPORT_TYPE@importBundle@servletRequest"> --%>
              <uix:tableLayout cellSpacing="5">
                <uix:contents>

                  <uix:stackLayout>
                    <uix:contents>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" textBinding="WHAT_IMPORT_TYPE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                      <%--
                      <oem:radioButton
                                name="importType"
                                selectedValueBinding="importType@importBean@servletRequest"
                                selected="true"
                                textBinding="DATABASE@exportBundle@servletRequest"
                                value="FULL"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="30"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_DATABASE_FILE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                      --%>
                      <oem:radioButton
                                name="importType"
                                selectedValueBinding="importType@importBean@servletRequest"
                                selected="false"
                                textBinding="USER@exportBundle@servletRequest"
                                value="USER"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="30"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_USER_FILE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                      <oem:radioButton
                                name="importType"
                                selectedValueBinding="importType@importBean@servletRequest"
                                selected="false"
                                textBinding="TABLE@exportBundle@servletRequest"
                                value="TABLE"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="30"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_TABLE_FILE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>


<%--
                      <oem:radioButton
                                name="importType"
                                selectedValueBinding="importType@importBean@servletRequest"
                                selected="true"
                                textBinding="TABLESPACE@exportBundle@servletRequest"
                                value="TABLESPACE"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="30"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_TABLESPACE_FILE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
--%>
<%--
                      <oem:radioButton
                                name="importType"
                                disabled="true"
                                selectedValueBinding="importType@importBean@servletRequest"
                                selected="true"
                                textBinding="TRANSPORT_TABLESPACE@exportBundle@servletRequest"
                                value="TRANSPORT_TABLESPACE"/>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:spacer width="30"/> 
                          <uix:styledText styleClass="OraInlineInfoText" textBinding="IMPORT_TRANSPORT_TABLESPACE_FILE@importBundle@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
--%>
                    </uix:contents>
                  </uix:stackLayout>

                </uix:contents>
              </uix:tableLayout>
            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
<%--                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="importForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>  --%>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="importForm"
                    maxValueBinding="navMaxValue@importBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@importBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
