<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="userMappingPageTitle@importBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="importForm" destination="/console/database/data/import" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/importUserMapping"/>

          <uix:pageLayout titleBinding="userMappingPageHeader@importBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@importBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@importBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>


            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@importBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="SCHEMA_MAPPING@importBundle@servletRequest"> --%>
              <uix:tableLayout cellSpacing="5">
                <uix:contents>

                   <uix:switcher childNameBinding="privilegedUser@importBean@servletRequest">
                     <uix:case name="true">
                       <uix:header textBinding="REMAP_SCHEMAS_HEADER@importBundle@servletRequest" size="1">
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="YOU_CAN_MAP_SCHEMAS@importBundle@servletRequest"/>
                            <oem:table name="userMappingTableUI"
                                     beanKey="importBean"
                                     destination="/console/database/data/import"
                                     summaryBinding="REMAP_SCHEMAS_HEADER@importBundle@servletRequest"
                                     formSubmitted="true"
                                     dataSourceProp="userMappingTableUI"
                                     alternateTextBinding="NO_SCHEMAS_SELECTED@exportBundle@servletRequest">
                              <uix:tableSelection>
                                <uix:singleSelection 
                                    shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                    selectedIndexBinding="selectedIndex@userMappingTableDS@importBean@servletRequest">
                                  <uix:submitButton
                                      shortDescBinding="REMOVE@exportBundle@servletRequest"
                                      textBinding="REMOVE@exportBundle@servletRequest"
                                      name="event" 
                                      value="deleteUser"/>
                                </uix:singleSelection>
                              </uix:tableSelection>
                              <uix:footer>
                                <uix:submitButton
                                      shortDescBinding="ADD_FILE@exportBundle@servletRequest"
                                      textBinding="ADD_FILE@exportBundle@servletRequest"
                                      name="event" 
                                    value="addUser"/>
                              </uix:footer>
                            </oem:table>

                          </uix:contents>
                        </uix:stackLayout>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="DB10orHigher@importBean@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                        <uix:contents>

                          <uix:header textBinding="REMAP_TABLESPACES_HEADER@importBundle@servletRequest" size="1">
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText" textBinding="YOU_CAN_MAP_TABLESPACES@importBundle@servletRequest"/>
                                <oem:table name="tablespaceMappingTableUI"
                                         beanKey="importBean"
                                         destination="/console/database/data/import"
                                         summaryBinding="REMAP_TABLESPACES_HEADER@importBundle@servletRequest"
                                         formSubmitted="true"
                                         dataSourceProp="tablespaceMappingTableUI"
                                         alternateTextBinding="NO_TABLESPACES_SELECTED@exportBundle@servletRequest">
                                  <uix:tableSelection>
                                    <uix:singleSelection 
                                        shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                        selectedIndexBinding="selectedIndex@tablespaceMappingTableDS@importBean@servletRequest">
                                      <uix:submitButton
                                          shortDescBinding="REMOVE@exportBundle@servletRequest"
                                          textBinding="REMOVE@exportBundle@servletRequest"
                                          name="event" 
                                          value="deleteTablespace"/>
                                    </uix:singleSelection>
                                  </uix:tableSelection>
                                  <uix:footer>
                                    <uix:submitButton
                                        shortDescBinding="ADD_FILE@exportBundle@servletRequest"
                                        textBinding="ADD_FILE@exportBundle@servletRequest"
                                        name="event" 
                                        value="addTablespace"/>
                                  </uix:footer>
                                </oem:table>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:header>

                          <uix:switcher childNameBinding="displayDatafileMapping@importBean@servletRequest">
                            <uix:case name="true">
                              <uix:header textBinding="REMAP_DATAFILES_HEADER@importBundle@servletRequest" size="1">
                                <uix:stackLayout>
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText" textBinding="YOU_CAN_MAP_DATAFILES@importBundle@servletRequest"/>
                                    <oem:table name="datafileMappingTableUI"
                                             beanKey="importBean"
                                             destination="/console/database/data/import"
                                             summaryBinding="REMAP_DATAFILES_HEADER@importBundle@servletRequest"
                                             formSubmitted="true"
                                             dataSourceProp="datafileMappingTableUI"
                                             alternateTextBinding="NO_DATAFILES_SELECTED@exportBundle@servletRequest">
                                      <uix:tableSelection>
                                        <uix:singleSelection 
                                            shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                            selectedIndexBinding="selectedIndex@datafileMappingTableDS@importBean@servletRequest">
                                          <uix:submitButton
                                              shortDescBinding="REMOVE@exportBundle@servletRequest"
                                              textBinding="REMOVE@exportBundle@servletRequest"
                                              name="event" 
                                              value="deleteDatafile"/>
                                        </uix:singleSelection>
                                      </uix:tableSelection>
                                      <uix:footer>
                                        <uix:submitButton
                                            shortDescBinding="ADD_FILE@exportBundle@servletRequest"
                                            textBinding="ADD_FILE@exportBundle@servletRequest"
                                            name="event" 
                                            value="addDatafile"/>
                                      </uix:footer>
                                    </oem:table>
                                  </uix:contents>
                                </uix:stackLayout>
                              </uix:header>
                            </uix:case>
                          </uix:switcher>

                        </uix:contents>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>

                </uix:contents>
              </uix:tableLayout>
            <%-- </uix:header> --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="importForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="importForm"
                    maxValueBinding="navMaxValue@importBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@importBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
