<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="optionsPageTitle@loadBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadAdvanced"/>

          <uix:pageLayout titleBinding="TITLE_OPTIONS@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="OPTIONS@exportBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>
                  <%-- <uix:header textBinding="GENERAL@exportBundle@servletRequest" size="1"> --%>

                    <uix:checkBox textBinding="LIMIT_RECORDS@loadBundle@servletRequest" name="limitRecords" checkedBinding="limitRecords@loadBean@servletRequest"/>
                    <uix:labeledFieldLayout labelWidth="20%"> 
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" labeledNodeId="load" 
                            textBinding="LIMIT_RECORDS_LABEL@loadBundle@servletRequest"/>
                        <uix:stackLayout>
                          <uix:textInput name="load" id="load" 
                              textBinding="load@loadBean@servletRequest" columns="10"/>
                          <uix:messageText messageType="error" messageBinding="Load@errors@servletRequest"/>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:labeledFieldLayout>

                    <uix:checkBox textBinding="RECORDS_TO_BE_SKIPPED@loadBundle@servletRequest" name="skipRecords" checkedBinding="skipRecords@loadBean@servletRequest"/>
                    <uix:labeledFieldLayout labelWidth="20%"> 
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" labeledNodeId="skip" 
                            textBinding="RECORDS_TO_BE_SKIPPED_LABEL@loadBundle@servletRequest"/>
                        <uix:stackLayout>
                          <uix:textInput name="skip" id="skip" 
                              textBinding="skip@loadBean@servletRequest" columns="10"/>
                          <uix:messageText messageType="error" messageBinding="Skip@errors@servletRequest"/>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:labeledFieldLayout>

                    <uix:checkBox textBinding="FAIL_JOBS_ON_ERRORS@exportBundle@servletRequest" name="SMPIgnore" checkedBinding="SMPIgnore@loadBean@servletRequest"/>

                    <uix:header textBinding="LOAD_TERMINATION@loadBundle@servletRequest" size="1">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:labeledFieldLayout labelWidth="30%"> 
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText" labeledNodeId="errors" 
                                  textBinding="MAX_INSERT_ERRORS@loadBundle@servletRequest"/>
                              <uix:stackLayout>
                                <uix:textInput name="errors" id="errors" 
                                    textBinding="errors@loadBean@servletRequest" columns="10"/>
                                <uix:messageText messageType="error" messageBinding="Errors@errors@servletRequest"/>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:labeledFieldLayout>

                          <uix:checkBox textBinding="LIMIT_DISCARD_RECORDS@loadBundle@servletRequest" name="limitDiscardRecords" checkedBinding="limitDiscardRecords@loadBean@servletRequest"/>
                          <uix:labeledFieldLayout labelWidth="30%"> 
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText" labeledNodeId="discardMax" 
                                  textBinding="LIMIT_DISCARD_RECORDS_LABEL@loadBundle@servletRequest"/>
                              <uix:stackLayout>
                                <uix:textInput name="discardMax" id="discardMax" 
                                    textBinding="discardMax@loadBean@servletRequest" columns="10"/>
                                <uix:messageText messageType="error" messageBinding="DiscardMax@errors@servletRequest"/>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:header>

                    <uix:header textBinding="INDEXES@loadBundle@servletRequest" size="1">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:checkBox textBinding="ALLOW_UNUSABLE_INDEXES@loadBundle@servletRequest" name="skipUnusableIndexes" checkedBinding="skipUnusableIndexes@loadBean@servletRequest"/>
                          <uix:checkBox 
                            name="skipIndexMaintenance" 
                            textBinding="SKIP_INDEX_MAINTENANCE@loadBundle@servletRequest" 
                            disabledBinding="disableSkipIndexMaintenance@loadBean@servletRequest"
                            checkedBinding="skipIndexMaintenance@loadBean@servletRequest"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:header>

                    <uix:header textBinding="OPTIONAL_FILES@loadBundle@servletRequest" size="1">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:checkBox textBinding="GENERATE_BAD_FILE@loadBundle@servletRequest" name="generateBadFile" checkedBinding="generateBadFile@loadBean@servletRequest"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/> 
                              <uix:labeledFieldLayout labelWidth="20%">
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="badFile" 
                                      textBinding="BAD_FILE@loadBundle@servletRequest"/>
                                  <uix:stackLayout>
                                    <uix:textInput name="badFile" id="badFile" 
                                        textBinding="badFile@loadBean@servletRequest" columns="60"/>
                                    <uix:messageText messageType="error" messageBinding="BadFile@errors@servletRequest"/>
                                  </uix:stackLayout>
                                </uix:contents>
                              </uix:labeledFieldLayout>   
                            </uix:contents>
                          </uix:rowLayout>

                          <uix:checkBox textBinding="GENERATE_DISCARD_FILE@loadBundle@servletRequest" name="generateDiscardFile" checkedBinding="generateDiscardFile@loadBean@servletRequest"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/> 
                              <uix:labeledFieldLayout labelWidth="20%">
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="discardFile" 
                                      textBinding="DISCARD_FILE@loadBundle@servletRequest"/>
                                  <uix:stackLayout>
                                    <uix:textInput name="discardFile" id="discardFile" 
                                        textBinding="discardFile@loadBean@servletRequest" columns="60"/>
                                    <uix:messageText messageType="error" messageBinding="DiscardFile@errors@servletRequest"/>
                                  </uix:stackLayout>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:contents>
                          </uix:rowLayout>

                          <uix:checkBox textBinding="GENERATE_LOG_FILE@loadBundle@servletRequest" name="generateLogFile" checkedBinding="generateLogFile@loadBean@servletRequest"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:spacer width="20"/> 
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:labeledFieldLayout labelWidth="20%">
                                    <uix:contents>
                                      <uix:messageLovField
                                          id="logFileName"
                                          name="logFileName"
                                          promptBinding="LOG_FILE_COLON@exportBundle@servletRequest"
                                          textBinding="logFileName@loadBean@servletRequest"
                                          columns="60"
                                          searchDescBinding="CLICK_TO_SELECT_LOG_FILE@exportBundle@servletRequest"
                                          onClick="startFileBrowser('logFileName')"/>
                                    </uix:contents>
                                  </uix:labeledFieldLayout>
                                  <uix:messageText messageType="error" messageBinding="LogFile@errors@servletRequest"/>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:rowLayout>

                          <uix:switcher childNameBinding="disableOverwriteDataFile@loadBean@servletRequest">
                            <uix:case name="false">
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:checkBox 
                                    name="overwriteDataFile" 
                                    textBinding="OVERWRITE_DEFAULT_DATA_FILE@loadBundle@servletRequest" 
                                    disabledBinding="disableOverwriteDataFile@loadBean@servletRequest"
                                    checkedBinding="overwriteDataFile@loadBean@servletRequest"/>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:spacer width="20"/> 
                                      <uix:labeledFieldLayout labelWidth="20%">
                                        <uix:contents>
                                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="dumpFileName" textBinding="DATABASE_FILE@loadBundle@servletRequest"/>
                                          <uix:stackLayout>
                                            <oem:choice 
                                              name="dumpFileName"
                                              id="dumpFileName"
                                              optionsBinding="availableDatabaseFiles@loadBean@servletRequest"
                                              disabledBinding="disableDumpFileName@loadBean@servletRequest"
                                              selectedValueBinding="dumpFileName@loadBean@servletRequest"/>
                                            <uix:messageText messageType="error" messageBinding="DatabaseFile@errors@servletRequest"/>
                                          </uix:stackLayout>
                                        </uix:contents>
                                      </uix:labeledFieldLayout>
                              
                                    </uix:contents>
                                  </uix:rowLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:case>
                          </uix:switcher>

                        </uix:contents>
                      </uix:stackLayout>
                    </uix:header>                      

                  <%-- </uix:header> --%>

                  <uix:hideShow disclosedBinding="showAdvancedOptions@loadBean@servletRequest"
                                formSubmitted="true" id="hideShow"
                                disclosedTextBinding="HIDE_ADVANCED_OPTIONS@exportBundle@servletRequest"
                                undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@exportBundle@servletRequest">
                    <uix:contents>
                      <uix:stackLayout>
                      <uix:contents>

                        <uix:header textBinding="TUNING@exportBundle@servletRequest" size="1">
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:labeledFieldLayout labelWidth="30%">
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="rows" 
                                      textBinding="ROWS_PER_COMMIT@loadBundle@servletRequest"/>
                                  <uix:textInput name="rows" id="rows" 
                                    textBinding="rows@loadBean@servletRequest" columns="8"/>
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="bindSize" 
                                      textBinding="MAX_SIZE_BIND_ARRAY@loadBundle@servletRequest"/>
                                  <uix:textInput name="bindSize" id="bindSize" 
                                      textBinding="bindSize@loadBean@servletRequest" columns="8"/>
                                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="readSize" 
                                      textBinding="MAX_SIZE_READ_BUFFER@loadBundle@servletRequest"/>
                                  <uix:textInput name="readSize" id="readSize" 
                                      textBinding="readSize@loadBean@servletRequest" columns="8"/>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:header>

                        <uix:header textBinding="OTHER@exportBundle@servletRequest" size="1">
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText" textBinding="IF_PARAMETERS@exportBundle@servletRequest"/>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:spacer width="20"/>
                                  <uix:labeledFieldLayout labelWidth="20%"> 
                                    <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText" labeledNodeId="other" 
                                          textBinding="PARAMETERS@exportBundle@servletRequest"/>
                                      <uix:textInput name="other" id="other" 
                                          textBinding="other@loadBean@servletRequest" columns="80"/>
                                      <uix:styledText styleClass="OraInstructionText" text=""/>
                                      <uix:styledText styleClass="OraInlineInfoText" textBinding="OTHER_EXAMPLE@exportBundle@servletRequest"/>
                                    </uix:contents>
                                  </uix:labeledFieldLayout>
                                </uix:contents>
                              </uix:rowLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:header>

                        </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>
                  </uix:hideShow>

                  </uix:contents>
                </uix:stackLayout>
              <%-- </uix:header> --%>

              <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                  <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="loadForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                  <uix:contents>
                    <uix:navigationBar
                      name="ctNav"
                      blockSize="-1"
                      formSubmitted="true"
                      formName="loadForm"
                      maxValueBinding="navMaxValue@loadBean@servletRequest"
                      minValue="1"
                      valueBinding="navValue@loadBean@servletRequest"/>
                  </uix:contents>
                </uix:pageButtonBar>
              </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
