<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="controlFilePageTitle@loadBean@servletRequest"/> 
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadControlFile"/>

          <uix:pageLayout titleBinding="TITLE_CONTROL_FILE@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Train must be within pageLayout location child to display above title --%>
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <%-- <uix:header textBinding="CONTROL_FILE@loadBundle@servletRequest"> --%>
              <uix:stackLayout>
                <uix:contents>
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" labeledNodeId="controlFile"
                        textBinding="CONTROL_FILE_IS_USED@loadBundle@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:stackLayout>
                      <uix:messageLovField
                          id="controlFile"
                          name="controlFile"
                          textBinding="controlFile@loadBean@servletRequest"
                          columns="80"
                          searchDescBinding="CLICK_TO_SELECT_CONTROL_FILE@loadBundle@servletRequest"
                          onClick="startFileBrowser('controlFile')"/>
                        <uix:messageText messageType="error" messageBinding="ControlFile@errors@servletRequest"/>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:stackLayout>
            <%-- </uix:header> --%>

<%--
            <uix:header textBinding="HOST_CREDENTIALS@exportBundle@servletRequest">
              <uix:contents>
                <%@ include file="/credentials.jspf"%>
              </uix:contents>
           </uix:header>
--%>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="loadForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="loadForm"
                    maxValueBinding="navMaxValue@loadBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@loadBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
