<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="reviewControlFileContentsPageTitle@loadBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadControlFileContents"/>

          <uix:pageLayout titleBinding="TITLE_REVIEW_CONTROL_FILE_CONTENTS@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                               errorTableBinding="errors@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:stackLayout>
              <uix:contents>
                <uix:tip>
                  <uix:contents>
                    <uix:styledText styleClass="OraTipText" textBinding="EDIT_CONTROL_FILE_TIP@loadBundle@servletRequest"/>
                  </uix:contents>
                </uix:tip>
                <uix:styledText styleClass="OraInstructionText" labeledNodeId="controlFileContents" 
                    rendered="false" 
                    textBinding="CONTROL_FILE_CONTENTS@loadBundle@servletRequest"/>
                <uix:textInput
                    rows="25"
                    wrap="soft"
                    name="controlFileContents"
                    id="controlFileContents"
                    shortDescBinding="CONTROL_FILE_CONTENTS@loadBundle@servletRequest"
                    textBinding="controlFileContents@loadBean@servletRequest"
                    columns="100"/>
                <uix:messageText messageType="error" messageBinding="ControlFileContents@errors@servletRequest"/>
              </uix:contents>
            </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton shortDescBinding="CANCEL@DBObjectBundle@servletRequest" formName="loadForm" textBinding="CANCEL@DBObjectBundle@servletRequest" name="event" value="gotoReview"/>
                <uix:submitButton shortDescBinding="OK@DBObjectBundle@servletRequest" formName="loadForm" textBinding="OK@DBObjectBundle@servletRequest" name="event" value="controlFileContentsOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
