<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="fileAttributesPageTitle@loadBean@servletRequest"/> 
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadFileAttributes"/>

          <uix:pageLayout titleBinding="TITLE_FILE_ATTRIBUTES@loadBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="."/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="messages@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:contents>

              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="FILE_ATTRIBUTES_INSTR@loadBundle@servletRequest"/>

              <uix:tip>
                <uix:contents>
                  <uix:styledText
                      styleClass="OraTipText"
                      textBinding="FILE_ATTRIBUTES_TIP@loadBundle@servletRequest"/>
                </uix:contents>
              </uix:tip>

              <uix:borderLayout>
                <uix:left>
                  <uix:switcher childNameBinding="characterDelimited@loadBean@servletRequest">
                    <uix:case name="true">
                      <uix:tableLayout cellSpacing="5" width="100%">
                      <uix:rowLayout>
                      <uix:cellFormat vAlign="top">
                      <uix:header textBinding="CHARACTER_DELIMITERS@loadBundle@servletRequest">
                        <uix:contents>
                          <uix:labeledFieldLayout labelWidth="30%">
                            <uix:contents>
                              <uix:messageTextInput
                                  id="fieldDelimiter"
                                  name="fieldDelimiter"
                                  textBinding="fieldDelimiter@loadBean@servletRequest"
                                  promptBinding="FIELD_DELIMITER@loadBundle@servletRequest"
                                  tipBinding="FIELD_DELIMITER_TAB_TIP@loadBundle@servletRequest"
                                  columns="10"/>
                              <uix:messageTextInput
                                  id="fieldEnclosure"
                                  name="fieldEnclosure"
                                  textBinding="fieldEnclosure@loadBean@servletRequest"
                                  promptBinding="FIELD_ENCLOSURE@loadBundle@servletRequest"
                                  columns="10"/>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:header>
                      </uix:cellFormat>
                      </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:tableLayout cellSpacing="5" width="100%">
                      <uix:rowLayout>
                      <uix:cellFormat vAlign="top">
                      <uix:header textBinding="FIXED_LENGTH_DELIMITER@loadBundle@servletRequest">
                        <uix:contents>
                          <uix:labeledFieldLayout labelWidth="1%">
                            <uix:contents>
                              <uix:messageRadioButton
                                  name="fixedLengthDelimiter"
                                  selectedValueBinding="fixedLengthDelimiter@loadBean@servletRequest"
                                  textBinding="USE_RECORD_DELIMITER@loadBundle@servletRequest"
                                  messageBinding="(USE_RECORD_DELIMITER@loadBundle@servletRequest)@messages@servletRequest"
                                  messageTypeBinding="(USE_RECORD_DELIMITER@loadBundle@servletRequest)@messageTypes@servletRequest"
                                  value="USE_RECORD_DELIMITER">
                                <uix:end>
                                  <uix:textInput
                                      id="recordDelimiter"
                                      name="recordDelimiter"
                                      shortDescBinding="RECORD_DELIMITER@loadBundle@servletRequest"
                                      textBinding="recordDelimiter@loadBean@servletRequest"
                                      columns="10"/>
                                </uix:end>
                              </uix:messageRadioButton>
                              <uix:messageRadioButton
                                  name="fixedLengthDelimiter"
                                  selectedValueBinding="fixedLengthDelimiter@loadBean@servletRequest"
                                  textBinding="USE_RECORD_LENGTH@loadBundle@servletRequest"
                                  messageBinding="(USE_RECORD_LENGTH@loadBundle@servletRequest)@messages@servletRequest"
                                  messageTypeBinding="(USE_RECORD_LENGTH@loadBundle@servletRequest)@messageTypes@servletRequest"
                                  value="USE_RECORD_LENGTH">
                                <uix:end>
                                  <uix:textInput
                                      id="recordLength"
                                      name="recordLength"
                                      shortDescBinding="RECORD_LENGTH@loadBundle@servletRequest"
                                      textBinding="recordLength@loadBean@servletRequest"
                                      columns="10">
                                    <uix:onSubmitValidater>
                                      <uix:decimal/>
                                    </uix:onSubmitValidater>
                                  </uix:textInput>
                                </uix:end>
                              </uix:messageRadioButton>
                            </uix:contents>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:header>
                      </uix:cellFormat>
                      </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:left>
                <uix:right>
                  <uix:tableLayout cellSpacing="5" width="100%">
                  <uix:rowLayout>
                  <uix:cellFormat vAlign="top">
                  <uix:header textBinding="DATA_FILE_ATTRIBUTES@loadBundle@servletRequest">
                    <uix:contents>
                      <uix:labeledFieldLayout labelWidth="35%">
                        <uix:contents>
                          <uix:messageTextInput
                              id="numRowsToSkip"
                              name="numRowsToSkip"
                              textBinding="numRowsToSkip@loadBean@servletRequest"
                              promptBinding="NUM_ROWS_TO_SKIP@loadBundle@servletRequest"
                              columns="10"
                              messageBinding="(NUM_ROWS_TO_SKIP@loadBundle@servletRequest)@messages@servletRequest"
                              messageTypeBinding="(NUM_ROWS_TO_SKIP@loadBundle@servletRequest)@messageTypes@servletRequest">
                            <uix:onSubmitValidater>
                              <uix:decimal/>
                            </uix:onSubmitValidater>
                          </uix:messageTextInput>
                        </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:contents>
                  </uix:header>
                  </uix:cellFormat>
                  </uix:rowLayout>
                  </uix:tableLayout>
                </uix:right>
              </uix:borderLayout>

              <uix:header textBinding="FIELD_ATTRIBUTES@loadBundle@servletRequest">
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>

                      <uix:flowLayout>
                        <uix:contents>
                          <uix:messagePrompt
                              promptBinding="TABLE@loadBundle@servletRequest"/>
                          <uix:spacer width="10"/>
                          <uix:styledText
                             styleClass="OraDataText"
                             textBinding="loadTable@loadBean@servletRequest"/>
                        </uix:contents>
                      </uix:flowLayout>

                      <uix:switcher childNameBinding="characterDelimited@loadBean@servletRequest">
                        <uix:case name="true">
                          <uix:styledText
                              styleClass="OraInstructionText"
                              textBinding="FIELD_ATTR_TIP_CHARACTER_DELIMITED@loadBundle@servletRequest"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:tableLayout width="100%">
                            <uix:contents>
                              <uix:rowLayout>
                                <uix:styledText
                                    styleClass="OraInstructionText"
                                    textBinding="FIELD_ATTR_TIP_FIXED_LENGTH@loadBundle@servletRequest"/>
                              </uix:rowLayout>
                              <uix:rowLayout hAlign="right">
                                <uix:cellFormat wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:pageButtonBar>
                                      <uix:submitButton
                                          name="event"
                                          value="resetStartAndLength"
                                          shortDescBinding="RESET_START_AND_LENGTH@loadBundle@servletRequest"
                                          textBinding="RESET_START_AND_LENGTH@loadBundle@servletRequest"/>
                                    </uix:pageButtonBar>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:rowLayout>
                            </uix:contents>
                          </uix:tableLayout>
                        </uix:case>
                      </uix:switcher>

                      <uix:dataScope
                          currentDataBinding="fieldAttributesTable@loadBean@servletRequest">

                        <uix:table
                            id="fieldAttributesTable"
                            name="fieldAttributesTable" 
                            formSubmitted="true"
                            width="100%"
                            tableDataBinding="rowData"
                            minValue="1"
                            valueBinding="startIndex"
                            maxValueBinding="numRows"
                            blockSizeBinding="blockSize"
                            partialRenderMode="self"
                            showAll="yes"
                            summary="summary text">

                          <uix:tableSelection>
                            <uix:singleSelection
                                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                                selectedIndexBinding="selectedAttributeIndex@loadBean@servletRequest">
                              <uix:submitButton
                                  shortDescBinding="EDIT_ATTRIBUTES@loadBundle@servletRequest"
                                  textBinding="EDIT_ATTRIBUTES@loadBundle@servletRequest"
                                  name="event"
                                  value="editFieldAttributes"/>
                            </uix:singleSelection>
                          </uix:tableSelection>

                          <uix:tableFormat
                              tableBanding="rowBanding"/>

                          <uix:column renderedBinding="renderFieldCol"> 
                            <uix:columnHeader>
                              <uix:sortableHeader 
                                  textBinding="FIELD@loadBundle@servletRequest"/>
                            </uix:columnHeader> 
                            <uix:columnFormat 
                                columnDataFormat="numberFormat"
                                width="5%"/>
                            <uix:messageTextInput
                                promptBinding="FIELD@loadBundle@servletRequest"
                                nameBinding="fieldColumnIndex"
                                textBinding="fieldColumn"
                                messageBinding="fieldColumnMessage"
                                messageTypeBinding="fieldColumnMessageType"
                                columns="3">
                              <uix:onSubmitValidater>
                                <uix:decimal maxScale="0"/>
                              </uix:onSubmitValidater>
                            </uix:messageTextInput>
                          </uix:column>

                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader 
                                  textBinding="NAME@loadBundle@servletRequest"/>
                            </uix:columnHeader> 
                            <uix:columnFormat 
                                columnDataFormat="textFormat"/>
                            <uix:styledText 
                                textBinding="nameColumn"/>
                          </uix:column>

                          <uix:column> 
                            <uix:columnHeader>
                              <uix:sortableHeader 
                                  textBinding="TYPE@loadBundle@servletRequest"/>
                            </uix:columnHeader> 
                            <uix:columnFormat 
                                columnDataFormat="textFormat"/>
                            <uix:styledText 
                                textBinding="typeColumn"/>
                          </uix:column>

                          <uix:column renderedBinding="renderStartCol"> 
                            <uix:columnHeader>
                              <uix:sortableHeader 
                                  textBinding="START@loadBundle@servletRequest"/>
                            </uix:columnHeader> 
                            <uix:columnFormat 
                                columnDataFormat="numberFormat"
                                width="10%"/>
                            <uix:messageTextInput
                                promptBinding="START@loadBundle@servletRequest"
                                nameBinding="startColumnIndex"
                                textBinding="startColumn"
                                messageBinding="startColumnMessage"
                                messageTypeBinding="startColumnMessageType"
                                columns="10">
                              <uix:onSubmitValidater>
                                <uix:decimal/>
                              </uix:onSubmitValidater>
                            </uix:messageTextInput>
                          </uix:column>

                          <uix:column renderedBinding="renderLengthCol"> 
                            <uix:columnHeader>
                              <uix:sortableHeader 
                                  textBinding="LENGTH@loadBundle@servletRequest"/>
                            </uix:columnHeader> 
                            <uix:columnFormat 
                                columnDataFormat="numberFormat"
                                width="10%"/>
                            <uix:messageTextInput
                                promptBinding="LENGTH@loadBundle@servletRequest"
                                nameBinding="lengthColumnIndex"
                                textBinding="lengthColumn"
                                messageBinding="lengthColumnMessage"
                                messageTypeBinding="lengthColumnMessageType"
                                columns="10">
                              <uix:onSubmitValidater>
                                <uix:decimal/>
                              </uix:onSubmitValidater>
                            </uix:messageTextInput>
                          </uix:column>

                          <uix:column> 
                            <uix:columnHeader>
                              <uix:sortableHeader 
                                  textBinding="ATTRIBUTES@loadBundle@servletRequest"/>
                            </uix:columnHeader> 
                            <uix:columnFormat 
                                columnDataFormat="textFormat"/>
                            <uix:styledText 
                                textBinding="attributesColumn"/>
                          </uix:column>

                        </uix:table>
                      </uix:dataScope>

                      <uix:switcher childNameBinding="characterDelimited@loadBean@servletRequest">
                        <uix:case name="true">
                          <uix:tip>
                            <uix:contents>
                              <uix:styledText
                                  styleClass="OraTipText"
                                  textBinding="FIELD_INDEX_TIP@loadBundle@servletRequest"/>
                            </uix:contents>
                          </uix:tip>
                        </uix:case>
                      </uix:switcher>

                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
              </uix:header>

              <uix:header textBinding="PREVIEW_DATA@loadBundle@servletRequest">
                <uix:contents>
                  <uix:tableLayout width="100%">
                    <uix:contents>
                      <uix:rowLayout>
                        <uix:flowLayout>
                          <uix:contents>
                            <uix:switcher childNameBinding="dataFileLocation@loadBean@servletRequest">
                              <uix:case name="DATA_FILE_LOCATED_ON_TARGET">
                                <uix:messagePrompt
                                    promptBinding="DATA_FILE_ON_TARGET_RESULT@loadBundle@servletRequest"/>
                              </uix:case>
                              <uix:case name="DATA_FILE_LOCATED_ON_BROWSER">
                                <uix:messagePrompt
                                    promptBinding="DATA_FILE_ON_TARGET_RESULT_COPY@loadBundle@servletRequest"/>
                              </uix:case>
                            </uix:switcher>
                            <uix:spacer width="10"/>
                            <uix:styledText
                               styleClass="OraDataText"
                               textBinding="dataFile@loadBean@servletRequest"/>
                          </uix:contents>
                        </uix:flowLayout>
                      </uix:rowLayout>
                      <uix:rowLayout hAlign="right">
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:contents>
                            <uix:pageButtonBar>
                              <uix:submitButton
                                  name="event"
                                  value="applyFileFormatAttributes"
                                  shortDescBinding="APPLY_FILE_FORMAT_ATTRIBUTES@loadBundle@servletRequest"
                                  textBinding="APPLY_FILE_FORMAT_ATTRIBUTES@loadBundle@servletRequest"/>
                            </uix:pageButtonBar>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:contents>
                          <oem:table 
                              name="previewDataTable" 
                              dataSourceProp="previewDataTable"
                              beanKey="loadBean"
                              summaryBinding="PREVIEW_DATA@loadBundle@servletRequest"
                              width="100%" 
                              formSubmitted="true"/>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:tableLayout>
                </uix:contents>
              </uix:header>

            </uix:contents>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button shortDescBinding="CANCEL@DBObjectBundle@servletRequest" textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton shortDescBinding="FINISH@exportBundle@servletRequest" formName="loadForm" textBinding="FINISH@exportBundle@servletRequest" name="event" value="ok"/>
                <uix:contents>
                  <uix:navigationBar
                    name="ctNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="loadForm"
                    maxValueBinding="navMaxValue@loadBean@servletRequest"
                    minValue="1"
                    valueBinding="navValue@loadBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
