<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="fileFieldAttributesPageTitle@loadBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="loadForm" destination="/console/database/data/load" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/data/loadFileFieldAttributes"/>

          <uix:pageLayout titleBinding="fileFieldAttributesPageHeader@loadBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@loadBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@loadBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

<uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                               errorTableBinding="errors@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@DBObjectBundle@servletRequest"/>
                  <uix:styledText
                     styleClass="OraDataText"
                     textBinding="targetDBName@loadBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:header textBinding="ATTRIBUTES@loadBundle@servletRequest" size="1">
              <uix:stackLayout>
                <uix:contents>
                  <oem:radioButton
                            name="attributeType"
                            selectedValueBinding="attributeType@loadBean@servletRequest"
                            textBinding="ATTRIBUTES_FILE_DATA@loadBundle@servletRequest"
                            value="FILE_DATA"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="20"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText"
                              textBinding="ATTRIBUTES_FILE_DATA_HINT@loadBundle@servletRequest"/>
                          <uix:labeledFieldLayout labelWidth="10%">
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText" labeledNodeId="nullif"
                                  textBinding="NULLIF@loadBundle@servletRequest"/>
                              <uix:stackLayout>
                                <uix:textInput name="nullif" id="nullif"
                                    textBinding="nullif@loadBean@servletRequest" columns="20"/>
                                <uix:messageText messageType="error" messageBinding="(NULLIF@loadBundle@servletRequest)@errors@servletRequest"/>
                              </uix:stackLayout>
                              <uix:styledText styleClass="OraInstructionText" labeledNodeId="defaultif"
                                  textBinding="DEFAULTIF@loadBundle@servletRequest"/>
                              <uix:stackLayout>
                                <uix:textInput name="defaultif" id="defaultif"
                                    textBinding="defaultif@loadBean@servletRequest" columns="20"/>
                                <uix:messageText messageType="error" messageBinding="(DEFAULTIF@loadBundle@servletRequest)@errors@servletRequest"/>
                              </uix:stackLayout>
                              <uix:styledText styleClass="OraInstructionText" labeledNodeId="dateFormat"
                                  renderedBinding="displayDateFormat@loadBean@servletRequest"
                                  textBinding="ATTRIBUTES_DATE_FORMAT@loadBundle@servletRequest"/>
                              <uix:textInput name="dateFormat" id="dateFormat"
                                  renderedBinding="displayDateFormat@loadBean@servletRequest"
                                  textBinding="dateFormat@loadBean@servletRequest" columns="20"/>
                            </uix:contents>
                          </uix:labeledFieldLayout>  
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>
                  <oem:radioButton
                            name="attributeType"
                            selectedValueBinding="attributeType@loadBean@servletRequest"
                            textBinding="ATTRIBUTES_GENERATE_DATA@loadBundle@servletRequest"
                            value="GENERATE_DATA"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width="20"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText"
                              textBinding="ATTRIBUTES_GENERATE_DATA_HINT@loadBundle@servletRequest"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <oem:radioButton
                                        name="generateDataType"
                                        selectedValueBinding="generateDataType@loadBean@servletRequest"
                                        textBinding="ATTRIBUTES_EXPRESSION@loadBundle@servletRequest"
                                        value="GENERATE_EXPRESSION_DATA"/>
                              <uix:spacer width="5"/>
                              <uix:stackLayout>
                                <uix:textInput name="expression" id="expression"
                                      textBinding="expression@loadBean@servletRequest" columns="20"/>
                                <uix:messageText messageType="error" messageBinding="(ATTRIBUTES_EXPRESSION@loadBundle@servletRequest)@errors@servletRequest"/>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:contents>
                              <oem:radioButton
                                        name="generateDataType"
                                        selectedValueBinding="generateDataType@loadBean@servletRequest"
                                        textBinding="ATTRIBUTES_CONSTANT@loadBundle@servletRequest"
                                        value="GENERATE_CONSTANT_DATA"/>
                              <uix:spacer width="18"/>
                              <uix:stackLayout>
                                <uix:textInput name="constant" id="constant"
                                    textBinding="constant@loadBean@servletRequest" columns="20"/>
                                <uix:messageText messageType="error" messageBinding="(ATTRIBUTES_CONSTANT@loadBundle@servletRequest)@errors@servletRequest"/>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:rowLayout>
                          <oem:radioButton
                                    name="generateDataType"
                                    renderedBinding="displaySysdate@loadBean@servletRequest"
                                    selectedValueBinding="generateDataType@loadBean@servletRequest"
                                    textBinding="ATTRIBUTES_SYSDATE@loadBundle@servletRequest"
                                    value="GENERATE_SYSDATE_DATA"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:stackLayout>
            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                  shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                  formName="loadForm"
                  textBinding="CANCEL@DBObjectBundle@servletRequest"
                  name="event"
                  value="gotoFileAttributes"/>
                <uix:submitButton
                  shortDescBinding="OK@DBObjectBundle@servletRequest"
                  formName="loadForm"
                  textBinding="OK@DBObjectBundle@servletRequest"
                  name="event"
                  value="fieldAttributesEditOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
